/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.bearer;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.token.bearer.BearerTokenConfiguration;
import io.micronaut.security.token.cookie.CookieTokenReader;
import io.micronaut.security.token.reader.HttpHeaderTokenReader;
import io.micronaut.security.token.reader.TokenReader;
import jakarta.inject.Singleton;

@Requirements(value={@Requires(classes={HttpRequest.class}), @Requires(property="micronaut.security.token.bearer.enabled", notEquals="false")})
@Singleton
public class BearerTokenReader
extends HttpHeaderTokenReader
implements TokenReader<HttpRequest<?>> {
    public static final Integer ORDER = CookieTokenReader.ORDER - 100;
    protected final BearerTokenConfiguration bearerTokenConfiguration;

    public BearerTokenReader(BearerTokenConfiguration bearerTokenConfiguration) {
        this.bearerTokenConfiguration = bearerTokenConfiguration;
    }

    @Override
    protected String getHeaderName() {
        return this.bearerTokenConfiguration.getHeaderName();
    }

    @Override
    protected String getPrefix() {
        return this.bearerTokenConfiguration.getPrefix();
    }

    public int getOrder() {
        return ORDER;
    }
}

