/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde;

import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.DeserializerLocator;
import io.micronaut.serde.NamingStrategyLocator;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.PropertyReference;
import io.micronaut.serde.reference.PropertyReferenceManager;
import java.io.IOException;

@Indexed(value=Deserializer.class)
public interface Deserializer<T> {
    @NonNull
    default public Deserializer<T> createSpecific(@NonNull DecoderContext context, @NonNull Argument<? super T> type) throws SerdeException {
        return this;
    }

    @Nullable
    public T deserialize(@NonNull Decoder var1, @NonNull DecoderContext var2, @NonNull Argument<? super T> var3) throws IOException;

    default public boolean allowNull() {
        return false;
    }

    @Nullable
    default public T getDefaultValue(@NonNull DecoderContext context, @NonNull Argument<? super T> type) {
        return null;
    }

    public static interface DecoderContext
    extends PropertyReferenceManager,
    DeserializerLocator,
    NamingStrategyLocator {
        @NonNull
        default public ConversionService<?> getConversionService() {
            return ConversionService.SHARED;
        }

        default public boolean hasView(Class<?> ... views) {
            return false;
        }

        @Internal
        @Nullable
        public <B, P> PropertyReference<B, P> resolveReference(@NonNull PropertyReference<B, P> var1);
    }
}

