/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.exceptions.SerdeException;

@Internal
public abstract class LimitingStream {
    public static final int DEFAULT_MAXIMUM_DEPTH = 1024;
    public static final RemainingLimits DEFAULT_LIMITS = new RemainingLimits(1024);
    private int remainingDepth;

    public LimitingStream(@NonNull RemainingLimits remainingLimits) {
        this.remainingDepth = remainingLimits.remainingDepth;
    }

    @NonNull
    protected final RemainingLimits ourLimits() {
        return new RemainingLimits(this.remainingDepth);
    }

    @NonNull
    protected final RemainingLimits childLimits() throws SerdeException {
        if (this.remainingDepth == 0) {
            this.reportMaxDepthExceeded();
        }
        return new RemainingLimits(this.remainingDepth - 1);
    }

    protected final void increaseDepth() throws SerdeException {
        if (this.remainingDepth == 0) {
            this.reportMaxDepthExceeded();
        }
        --this.remainingDepth;
    }

    protected final void decreaseDepth() {
        ++this.remainingDepth;
    }

    private void reportMaxDepthExceeded() throws SerdeException {
        boolean encoder = this instanceof Encoder;
        throw new SerdeException("Maximum depth exceeded while " + (encoder ? "serializing" : "deserializing") + ". The maximum nesting depth can be increased, if necessary, using the micronaut.serde.maximum-nesting-depth config property.");
    }

    public static RemainingLimits limitsFromConfiguration(SerdeConfiguration configuration) {
        return new RemainingLimits(configuration.getMaximumNestingDepth());
    }

    public static final class RemainingLimits {
        final int remainingDepth;

        private RemainingLimits(int remainingDepth) {
            this.remainingDepth = remainingDepth;
        }
    }
}

