/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.config;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;

@ConfigurationProperties(value="micronaut.serde")
@BootstrapContextCompatible
final class DefaultSerdeConfiguration
implements SerdeConfiguration {
    private final Optional<String> dateFormat;
    private final SerdeConfiguration.TimeShape timeWriteShape;
    private final SerdeConfiguration.NumericTimeUnit numericTimeUnit;
    private final boolean writeBinaryAsArray;
    private final Optional<Locale> locale;
    private final Optional<TimeZone> timeZone;
    private final List<String> includedIntrospectionPackages;
    private final int maximumNestingDepth;
    private final boolean inetAddressAsNumeric;
    private final String propertyNamingStrategyName;
    private final PropertyNamingStrategy propertyNamingStrategy;

    @ConfigurationInject
    DefaultSerdeConfiguration(Optional<String> dateFormat, @Bindable(defaultValue="STRING") SerdeConfiguration.TimeShape timeWriteShape, @Bindable(defaultValue="SECONDS") SerdeConfiguration.NumericTimeUnit numericTimeUnit, @Bindable(defaultValue="true") boolean writeBinaryAsArray, Optional<Locale> locale, Optional<TimeZone> timeZone, @Bindable(defaultValue="io.micronaut") List<String> includedIntrospectionPackages, @Bindable(defaultValue="1024") int maximumNestingDepth, @Bindable(defaultValue="false") boolean inetAddressAsNumeric, @Nullable String propertyNamingStrategy) {
        this.dateFormat = dateFormat;
        this.timeWriteShape = timeWriteShape;
        this.numericTimeUnit = numericTimeUnit;
        this.writeBinaryAsArray = writeBinaryAsArray;
        this.locale = locale;
        this.timeZone = timeZone;
        this.includedIntrospectionPackages = includedIntrospectionPackages;
        this.maximumNestingDepth = maximumNestingDepth;
        this.inetAddressAsNumeric = inetAddressAsNumeric;
        this.propertyNamingStrategyName = propertyNamingStrategy;
        this.propertyNamingStrategy = PropertyNamingStrategy.forName(propertyNamingStrategy).orElse(null);
    }

    @Override
    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    @Override
    public String getPropertyNamingStrategyName() {
        return this.propertyNamingStrategyName;
    }

    @Override
    public Optional<String> getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public SerdeConfiguration.TimeShape getTimeWriteShape() {
        return this.timeWriteShape;
    }

    @Override
    public SerdeConfiguration.NumericTimeUnit getNumericTimeUnit() {
        return this.numericTimeUnit;
    }

    @Override
    public boolean isWriteBinaryAsArray() {
        return this.writeBinaryAsArray;
    }

    @Override
    public Optional<Locale> getLocale() {
        return this.locale;
    }

    @Override
    public Optional<TimeZone> getTimeZone() {
        return this.timeZone;
    }

    @Override
    public List<String> getIncludedIntrospectionPackages() {
        return this.includedIntrospectionPackages;
    }

    @Override
    public int getMaximumNestingDepth() {
        return this.maximumNestingDepth;
    }

    @Override
    public boolean isInetAddressAsNumeric() {
        return this.inetAddressAsNumeric;
    }
}

