/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import java.io.IOException;
import java.util.Locale;

final class EnumCreatorDeserializer<E extends Enum<E>>
implements Deserializer<E> {
    private final Argument<Object> argumentType;
    private final Deserializer<Object> argumentDeserializer;
    private final BeanIntrospection<? super E> deserializableIntrospection;
    private final boolean allowNull;

    public EnumCreatorDeserializer(Argument<Object> argumentType, Deserializer<Object> argumentDeserializer, BeanIntrospection<? super E> deserializableIntrospection, boolean allowNull) {
        this.argumentType = argumentType;
        this.argumentDeserializer = argumentDeserializer;
        this.deserializableIntrospection = deserializableIntrospection;
        this.allowNull = allowNull;
    }

    @NonNull
    private E transform(Object v) {
        try {
            return (E)((Enum)this.deserializableIntrospection.instantiate(!this.allowNull, new Object[]{v}));
        }
        catch (IllegalArgumentException e) {
            if (v instanceof String) {
                String string = (String)v;
                try {
                    return (E)((Enum)this.deserializableIntrospection.instantiate(!this.allowNull, new Object[]{string.toUpperCase(Locale.ENGLISH)}));
                }
                catch (IllegalArgumentException ex) {
                    throw e;
                }
            }
            throw e;
        }
    }

    public E deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) throws IOException {
        return this.transform(this.argumentDeserializer.deserialize(decoder, context, this.argumentType));
    }

    public E deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) throws IOException {
        Object v = this.argumentDeserializer.deserializeNullable(decoder, context, this.argumentType);
        if (!this.allowNull && v == null) {
            return null;
        }
        return this.transform(v);
    }
}

