/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.support.serdes.EnumSerde;
import java.io.IOException;
import java.util.Map;

final class EnumPropertyDeserializer<E extends Enum<E>>
implements Deserializer<E> {
    private final Map<String, E> cache;
    private final boolean acceptCaseInsensitive;

    EnumPropertyDeserializer(Map<String, E> cache, boolean acceptCaseInsensitive) {
        this.cache = cache;
        this.acceptCaseInsensitive = acceptCaseInsensitive;
    }

    public E deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) throws IOException {
        String value = decoder.decodeString();
        Enum result = (Enum)this.cache.get(value);
        if (result != null) {
            return (E)result;
        }
        if (this.acceptCaseInsensitive) {
            for (Map.Entry<String, E> e : this.cache.entrySet()) {
                if (!e.getKey().equalsIgnoreCase(value)) continue;
                return (E)((Enum)e.getValue());
            }
        }
        throw EnumSerde.failedToDeserialize(decoder, this.cache, value);
    }
}

