/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serializers.AbstractMapObjectSerializer;
import io.micronaut.serde.support.util.JsonNodeEncoder;
import java.io.IOException;
import java.util.Map;

@Internal
final class RuntimeMapSerializer<K, V>
extends AbstractMapObjectSerializer<K, V> {
    private final boolean isStringKey;
    private final Argument<K> keyGeneric;
    private final Serializer<K> keySerializer;

    RuntimeMapSerializer(Argument<? extends Map<K, V>> type, Serializer.EncoderContext context) throws SerdeException {
        super(type, context);
        boolean hasGenerics;
        Object[] generics = type.getTypeParameters();
        boolean bl = hasGenerics = ArrayUtils.isNotEmpty((Object[])generics) && generics.length == 2;
        if (hasGenerics) {
            this.keyGeneric = generics[0];
            this.isStringKey = this.keyGeneric.getType() == String.class || CharSequence.class.isAssignableFrom(this.keyGeneric.getType());
        } else {
            this.keyGeneric = Argument.OBJECT_ARGUMENT;
            this.isStringKey = false;
        }
        this.keySerializer = RuntimeMapSerializer.findKeySerializer(context, this.keyGeneric);
    }

    @Override
    protected void encodeKey(Encoder encoder, Serializer.EncoderContext context, K k) throws IOException {
        if (k == null) {
            encoder.encodeNull();
        } else if (this.isStringKey || k instanceof CharSequence) {
            encoder.encodeKey(k.toString());
        } else {
            RuntimeMapSerializer.encodeMapKey(context, encoder, this.keyGeneric, this.keySerializer, k);
        }
    }

    private static <K> Serializer<K> findKeySerializer(Serializer.EncoderContext context, Argument<K> keyGeneric) throws SerdeException {
        try {
            return context.findSerializer(keyGeneric).createSpecific(context, keyGeneric);
        }
        catch (SerdeException e) {
            if (e.getCause() instanceof IntrospectionException) {
                return (encoder, ctx, type, value) -> RuntimeMapSerializer.convertMapKeyToStringAndEncode(ctx, encoder, value);
            }
            throw e;
        }
    }

    private static <K> void encodeMapKey(Serializer.EncoderContext context, Encoder encoder, Argument<K> keyGeneric, Serializer<? super K> keySerializer, K k) throws IOException {
        JsonNodeEncoder keyEncoder = JsonNodeEncoder.create();
        try {
            keySerializer.serialize((Encoder)keyEncoder, context, keyGeneric, k);
        }
        catch (SerdeException e) {
            if (e.getCause() instanceof IntrospectionException) {
                RuntimeMapSerializer.convertMapKeyToStringAndEncode(context, encoder, k);
                return;
            }
            throw e;
        }
        JsonNode keyNode = keyEncoder.getCompletedValue();
        if (keyNode.isString()) {
            encoder.encodeKey(keyNode.getStringValue());
        } else {
            if (keyNode.isNull()) {
                throw new SerdeException("Null key for a Map not allowed in JSON");
            }
            if (keyNode.isBoolean() || keyNode.isNumber()) {
                encoder.encodeKey(keyNode.coerceStringValue());
            } else {
                RuntimeMapSerializer.convertMapKeyToStringAndEncode(context, encoder, keyNode.getValue());
            }
        }
    }

    private static void convertMapKeyToStringAndEncode(Serializer.EncoderContext context, Encoder encoder, Object keyValue) throws IOException {
        try {
            String result = (String)context.getConversionService().convertRequired(keyValue, Argument.STRING);
            if (result == null) {
                throw new SerdeException("Null key for a Map not allowed in JSON");
            }
            encoder.encodeKey(result);
        }
        catch (ConversionErrorException ce) {
            throw new SerdeException("Error converting Map key [" + String.valueOf(keyValue) + "] to String: " + ce.getMessage(), (Throwable)ce);
        }
    }
}

