/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import java.io.IOException;
import java.util.Collection;

@Internal
final class RuntimeValueIterableSerializer<T>
implements Serializer<Iterable<T>> {
    RuntimeValueIterableSerializer() {
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Iterable<T>> type, Iterable<T> value) throws IOException {
        Encoder childEncoder = encoder.encodeArray(type);
        Class<?> lastValueClass = null;
        Serializer componentSerializer = null;
        Argument generic = null;
        for (T t : value) {
            if (t == null) {
                childEncoder.encodeNull();
                continue;
            }
            if (lastValueClass != t.getClass() || componentSerializer == null) {
                generic = Argument.of(t.getClass());
                componentSerializer = context.findSerializer(generic).createSpecific(context, generic);
                lastValueClass = t.getClass();
            }
            componentSerializer.serialize(childEncoder, context, generic, t);
        }
        childEncoder.finishStructure();
    }

    public boolean isEmpty(Serializer.EncoderContext context, Iterable<T> value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty();
        }
        return !value.iterator().hasNext();
    }

    public boolean isAbsent(Serializer.EncoderContext context, Iterable<T> value) {
        return value == null;
    }
}

