/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import io.micronaut.serde.support.util.SubtypeInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Internal
record DeserBeanSubtypeInfo<T>(Class<T> beanType, @NonNull Map<String, SubtypeDef<T>> subtypes, SubtypeInfo info, @Nullable SubtypeDef<T> defaultType) {
    @NonNull
    DeserBean<? extends T> findDeserBean(@Nullable String discriminatorValue) throws SerdeException {
        SubtypeDef<T> subtypeDef = discriminatorValue == null ? this.defaultType : this.subtypes.getOrDefault(discriminatorValue, this.defaultType);
        if (subtypeDef == null) {
            throw this.unknownSuperTypeException();
        }
        return subtypeDef.deserBean;
    }

    @NonNull
    public SerdeException unknownSuperTypeException() {
        return new SerdeException("Could not resolve subtype of [" + this.beanType.getName() + "] missing type id property '" + this.info.discriminatorName() + "'");
    }

    @Nullable
    static <T> DeserBeanSubtypeInfo<T> create(@Nullable SubtypeInfo subtypeInfo, BeanIntrospection<T> introspection, Deserializer.DecoderContext decoderContext, DeserBean<T> superTypeDeserBean, DeserializationConfiguration deserializationConfiguration, DeserBeanRegistry deserBeanRegistry) throws SerdeException {
        if (subtypeInfo == null) {
            return null;
        }
        Class superType = introspection.getBeanType();
        Collection subtypeIntrospections = decoderContext.getDeserializableSubtypes(superType);
        HashMap subtypes = CollectionUtils.newHashMap((int)subtypeIntrospections.size());
        Class defaultType = introspection.classValue(DefaultImplementation.class).orElseGet(() -> introspection.classValue("defaultImpl").orElse(null));
        if (defaultType == null && !deserializationConfiguration.isSubtypesRequireDefaultImpl()) {
            defaultType = introspection.getBeanType();
        }
        SubtypeDef<Object> defaultDeserType = null;
        if (defaultType != null && "com.fasterxml.jackson.annotation.JsonTypeInfo".equals(introspection.stringValue(SerdeConfig.SerSubtyped.class, "defaultImpl").orElse(null))) {
            defaultType = null;
        }
        if (introspection.getBeanType().equals(defaultType)) {
            defaultDeserType = new SubtypeDef<T>(superTypeDeserBean, introspection.asArgument());
        }
        for (BeanIntrospection subtypeIntrospection : subtypeIntrospections) {
            String[] names;
            SubtypeDef<Object> subtypeDef;
            Class subBeanType = subtypeIntrospection.getBeanType();
            Argument argument = subtypeIntrospection.asArgument();
            boolean hasNotResolvedGenerics = false;
            for (BeanProperty beanProperty : subtypeIntrospection.getBeanProperties()) {
                String[] argument1 = beanProperty.asArgument();
                hasNotResolvedGenerics |= argument1.isTypeVariable();
            }
            if (hasNotResolvedGenerics) {
                subtypeDef = new SubtypeDef(null, argument);
            } else {
                DeserBean deserBean = deserBeanRegistry.getDeserializableBean(argument, null, decoderContext);
                subtypeDef = new SubtypeDef(deserBean, argument);
            }
            if (defaultDeserType == null && defaultType != null && defaultType.equals(subBeanType)) {
                defaultDeserType = subtypeDef;
            }
            if (subtypeInfo.deduct()) {
                subtypes.put(subBeanType.getName(), subtypeDef);
                continue;
            }
            String[] types = subtypeInfo.subtypes().get(subBeanType);
            if (types != null) {
                for (String type : types) {
                    subtypes.put(type, subtypeDef);
                }
            }
            subtypeIntrospection.stringValue(SerdeConfig.class, "typeName").ifPresent(name -> subtypes.put(name, subtypeDef));
            for (String name2 : names = subtypeIntrospection.stringValues(SerdeConfig.class, "typeNames")) {
                subtypes.put(name2, subtypeDef);
            }
        }
        if (defaultDeserType == null && defaultType != null && !subtypeIntrospections.isEmpty()) {
            if (defaultType == introspection.getBeanType()) {
                defaultDeserType = new SubtypeDef<T>(superTypeDeserBean, introspection.asArgument());
            } else {
                Argument argument = Argument.of((Class)defaultType);
                defaultDeserType = new SubtypeDef(deserBeanRegistry.getDeserializableBean(argument, null, decoderContext), argument);
            }
        }
        return new DeserBeanSubtypeInfo<T>(introspection.getBeanType(), subtypes, subtypeInfo, defaultDeserType);
    }

    record SubtypeDef<K>(@Nullable DeserBean<? extends K> deserBean, Argument<? extends K> type) {
    }
}

