/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.UpdatingDeserializer;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DelegatingObjectDeserializer;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserBeanKey;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import io.micronaut.serde.support.deserializers.DeserBeanSubtypeInfo;
import io.micronaut.serde.support.deserializers.DeserializerSubtypeInfo;
import io.micronaut.serde.support.deserializers.ErrorCatchingDeserializer;
import io.micronaut.serde.support.deserializers.ErrorCatchingUpdatingDeserializer;
import io.micronaut.serde.support.deserializers.JsonValueDeserializer;
import io.micronaut.serde.support.deserializers.ResolvedDeserializerSubtypeInfo;
import io.micronaut.serde.support.deserializers.SerdeDeserializationPreInstantiateCallback;
import io.micronaut.serde.support.deserializers.SimpleObjectDeserializer;
import io.micronaut.serde.support.deserializers.SimpleRecordLikeObjectDeserializer;
import io.micronaut.serde.support.deserializers.SpecificObjectDeserializer;
import io.micronaut.serde.support.deserializers.SubtypedDeductionDeserializer;
import io.micronaut.serde.support.deserializers.SubtypedExternalPropertyObjectDeserializer;
import io.micronaut.serde.support.deserializers.SubtypedPropertyObjectDeserializer;
import io.micronaut.serde.support.deserializers.WrappedArraySubtypedDeserializer;
import io.micronaut.serde.support.deserializers.WrappedObjectDeserializer;
import io.micronaut.serde.support.deserializers.WrappedObjectSubtypedDeserializer;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import io.micronaut.serde.support.util.SubtypeInfo;
import io.micronaut.serde.util.CustomizableDeserializer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

@Internal
public class ObjectDeserializer
implements CustomizableDeserializer<Object>,
DeserBeanRegistry {
    private final SerdeIntrospections introspections;
    private final Map<DeserBeanKey, Supplier<DeserBean<?>>> deserBeanMap = new ConcurrentHashMap(50);
    private final DeserializationConfiguration deserializationConfiguration;
    private final SerdeConfiguration serdeConfiguration;
    @Nullable
    private final SerdeDeserializationPreInstantiateCallback preInstantiateCallback;
    private final ReentrantLock lock = new ReentrantLock();

    public ObjectDeserializer(SerdeIntrospections introspections, DeserializationConfiguration deserializationConfiguration, SerdeConfiguration serdeConfiguration, @Nullable SerdeDeserializationPreInstantiateCallback preInstantiateCallback) {
        this.introspections = introspections;
        this.deserializationConfiguration = deserializationConfiguration;
        this.serdeConfiguration = serdeConfiguration;
        this.preInstantiateCallback = preInstantiateCallback;
    }

    @Deprecated
    public ObjectDeserializer(SerdeIntrospections introspections, DeserializationConfiguration deserializationConfiguration, @Nullable SerdeDeserializationPreInstantiateCallback preInstantiateCallback) {
        this.introspections = introspections;
        this.deserializationConfiguration = deserializationConfiguration;
        this.serdeConfiguration = null;
        this.preInstantiateCallback = preInstantiateCallback;
    }

    public Deserializer<Object> createSpecific(Deserializer.DecoderContext context, Argument<? super Object> type) throws SerdeException {
        if (type.equalsType(Argument.OBJECT_ARGUMENT)) {
            return (decoder, ignore1, ignore2) -> decoder.decodeArbitrary();
        }
        DeserializationConfiguration deserializationConfiguration = context.getDeserializationConfiguration().orElse(this.deserializationConfiguration);
        DeserBean<? super Object> deserBean = this.getDeserializableBean(type, null, context);
        if (deserBean.subtypeInfo != null) {
            return this.createSubtypeDeserializer(context, deserializationConfiguration, deserBean, type);
        }
        return this.findDeserializer(deserializationConfiguration, deserBean, false);
    }

    private Deserializer<Object> createSubtypeDeserializer(final Deserializer.DecoderContext context, final DeserializationConfiguration deserializationConfiguration, DeserBean<? super Object> deserBean, final Argument<? super Object> type) {
        DeserializerSubtypeInfo<Object> deserializerSubtypeInfo;
        DeserBean defaultDeserBean;
        final DeserBeanSubtypeInfo subtypeInfo = deserBean.subtypeInfo;
        SubtypeInfo info = subtypeInfo.info();
        SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = info.discriminatorType();
        final HashMap subtypeDeserializers = CollectionUtils.newHashMap((int)subtypeInfo.subtypes().size());
        final boolean disallowUnwrap = discriminatorType == SerdeConfig.SerSubtyped.DiscriminatorType.WRAPPER_OBJECT;
        Deserializer<Object> defaultDeserializer = null;
        boolean hasUnresolved = false;
        for (Map.Entry e : subtypeInfo.subtypes().entrySet()) {
            DeserBeanSubtypeInfo.SubtypeDef subtypeDef = e.getValue();
            DeserBean subtypeDeserBean = subtypeDef.deserBean();
            if (subtypeDeserBean == null) {
                hasUnresolved = true;
                continue;
            }
            Deserializer<Object> subtypeDeserializer = this.findDeserializer(deserializationConfiguration, subtypeDeserBean, disallowUnwrap);
            subtypeDeserializers.put(e.getKey(), subtypeDeserializer);
            if (defaultDeserializer != null || subtypeInfo.defaultType() != subtypeDef) continue;
            defaultDeserializer = subtypeDeserializer;
        }
        if (defaultDeserializer == null && subtypeInfo.defaultType() != null && (defaultDeserBean = subtypeInfo.defaultType().deserBean()) != null) {
            defaultDeserializer = this.findDeserializer(deserializationConfiguration, defaultDeserBean, disallowUnwrap);
        }
        ResolvedDeserializerSubtypeInfo resolved = new ResolvedDeserializerSubtypeInfo(subtypeInfo, subtypeDeserializers, defaultDeserializer);
        if (!hasUnresolved) {
            deserializerSubtypeInfo = resolved;
        } else {
            final Deserializer<Object> finalDefaultDeserializer = defaultDeserializer;
            deserializerSubtypeInfo = new DeserializerSubtypeInfo<Object>(){

                @Override
                public DeserBeanSubtypeInfo<Object> parent() {
                    return subtypeInfo;
                }

                @Override
                public Deserializer<Object> findDeserializer(String discriminatorValue) throws SerdeException {
                    Argument argument;
                    Deserializer deserializer = (Deserializer)subtypeDeserializers.get(discriminatorValue);
                    if (deserializer != null) {
                        return deserializer;
                    }
                    DeserBeanSubtypeInfo.SubtypeDef subtype = subtypeInfo.subtypes().get(discriminatorValue);
                    if (subtype != null) {
                        argument = subtype.type();
                    } else {
                        if (finalDefaultDeserializer != null) {
                            return finalDefaultDeserializer;
                        }
                        DeserBeanSubtypeInfo.SubtypeDef defaultType = subtypeInfo.defaultType();
                        if (defaultType == null) {
                            throw subtypeInfo.unknownSuperTypeException();
                        }
                        argument = defaultType.type();
                    }
                    DeserBean subtypeDeserBean = ObjectDeserializer.this.getDeserializableBean(argument, type.getTypeVariables(), context);
                    return ObjectDeserializer.this.findDeserializer(deserializationConfiguration, subtypeDeserBean, disallowUnwrap);
                }
            };
        }
        if (info.deduct()) {
            return new SubtypedDeductionDeserializer(deserBean, subtypeDeserializers);
        }
        return switch (info.discriminatorType()) {
            default -> throw new IncompatibleClassChangeError();
            case SerdeConfig.SerSubtyped.DiscriminatorType.WRAPPER_OBJECT -> new WrappedObjectSubtypedDeserializer(deserializerSubtypeInfo, deserBean.ignoreUnknown);
            case SerdeConfig.SerSubtyped.DiscriminatorType.WRAPPER_ARRAY -> new WrappedArraySubtypedDeserializer(deserializerSubtypeInfo, deserBean.ignoreUnknown);
            case SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY, SerdeConfig.SerSubtyped.DiscriminatorType.EXISTING_PROPERTY -> new SubtypedPropertyObjectDeserializer(deserializerSubtypeInfo);
            case SerdeConfig.SerSubtyped.DiscriminatorType.EXTERNAL_PROPERTY -> new SubtypedExternalPropertyObjectDeserializer(deserializerSubtypeInfo);
        };
    }

    private Deserializer<Object> findDeserializer(DeserializationConfiguration deserializationConfiguration, DeserBean<? super Object> deserBean, boolean disallowUnwrap) {
        Object deserializer = deserBean.simpleBean ? new SimpleObjectDeserializer(deserializationConfiguration.isStrictNullable(), deserBean, this.preInstantiateCallback) : (deserBean.recordLikeBean ? new SimpleRecordLikeObjectDeserializer(deserializationConfiguration.isStrictNullable(), deserBean, this.preInstantiateCallback) : (deserBean.delegating ? new DelegatingObjectDeserializer(deserializationConfiguration.isStrictNullable(), deserBean, this.preInstantiateCallback) : (deserBean.isJsonValueProperty ? new JsonValueDeserializer(deserBean) : new SpecificObjectDeserializer(deserializationConfiguration.isStrictNullable(), deserBean, this.preInstantiateCallback))));
        if (!disallowUnwrap && deserBean.wrapperProperty != null) {
            deserializer = new WrappedObjectDeserializer((Deserializer<Object>)deserializer, deserBean.wrapperProperty, deserBean.ignoreUnknown);
        }
        if (deserializer instanceof UpdatingDeserializer) {
            UpdatingDeserializer updatingDeserializer = (UpdatingDeserializer)deserializer;
            return new ErrorCatchingUpdatingDeserializer<Object>(updatingDeserializer);
        }
        return new ErrorCatchingDeserializer<Object>((Deserializer<Object>)deserializer);
    }

    @Override
    public <T> DeserBean<T> getDeserializableBean(Argument<T> type, @Nullable Map<String, Argument<?>> typeArguments, Deserializer.DecoderContext decoderContext) throws SerdeException {
        SerdeArgumentConf serdeArgumentConf = type.getAnnotationMetadata().isEmpty() ? null : new SerdeArgumentConf(type.getAnnotationMetadata());
        DeserBeanKey key = new DeserBeanKey(decoderContext.getSerdeConfiguration().orElse(this.serdeConfiguration), decoderContext.getDeserializationConfiguration().orElse(this.deserializationConfiguration), type, typeArguments, serdeArgumentConf);
        Supplier deserBeanSupplier = this.deserBeanMap.computeIfAbsent(key, ignore -> SupplierUtil.memoizedNonEmpty(() -> this.createDeserBean(type, typeArguments, serdeArgumentConf, decoderContext)));
        DeserBean deserBean = (DeserBean)deserBeanSupplier.get();
        deserBean.initialize(this.lock, decoderContext);
        return deserBean;
    }

    private <T> DeserBean<T> createDeserBean(Argument<T> type, @Nullable Map<String, Argument<?>> typeArguments, @Nullable SerdeArgumentConf serdeArgumentConf, Deserializer.DecoderContext decoderContext) {
        try {
            BeanIntrospection deserializableIntrospection = this.introspections.getDeserializableIntrospection(type);
            Map<String, Argument<?>> ta = typeArguments == null || typeArguments.isEmpty() ? type.getTypeVariables() : typeArguments;
            return new DeserBean(this.deserializationConfiguration, ta, deserializableIntrospection, decoderContext, (DeserBeanRegistry)this, serdeArgumentConf);
        }
        catch (SerdeException e) {
            throw new IntrospectionException("Error creating deserializer for type [" + String.valueOf(type) + "]: " + e.getMessage(), (Throwable)e);
        }
    }
}

