/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.concurrent.TimeUnit;

abstract class NumericSupportTemporalSerde<T extends TemporalAccessor>
extends DefaultFormattedTemporalSerde<T> {
    private static final BigInteger NS_FACTOR = BigInteger.valueOf(1000000000L);
    private final SerdeConfiguration.TimeShape writeShape;
    private final SerdeConfiguration.NumericTimeUnit numericUnit;

    NumericSupportTemporalSerde(@NonNull SerdeConfiguration configuration, @NonNull DateTimeFormatter defaultStringFormatter, @NonNull SerdeConfiguration.NumericTimeUnit legacyUnit) {
        super(configuration, defaultStringFormatter);
        this.writeShape = configuration.getTimeWriteShape();
        this.numericUnit = configuration.getNumericTimeUnit() == SerdeConfiguration.NumericTimeUnit.LEGACY ? legacyUnit : configuration.getNumericTimeUnit();
    }

    protected abstract T fromNanos(long var1, int var3);

    protected abstract long getSecondPart(T var1);

    protected abstract int getNanoPart(T var1);

    @Override
    final T deserializeFallback(DateTimeException exc, String str) {
        BigDecimal raw;
        try {
            raw = new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            exc.addSuppressed(e);
            throw exc;
        }
        BigDecimal s = switch (this.numericUnit) {
            default -> throw new IncompatibleClassChangeError();
            case SerdeConfiguration.NumericTimeUnit.LEGACY -> throw new AssertionError((Object)"Should be replaced in constructor");
            case SerdeConfiguration.NumericTimeUnit.SECONDS -> raw;
            case SerdeConfiguration.NumericTimeUnit.MILLISECONDS -> raw.scaleByPowerOfTen(-3);
            case SerdeConfiguration.NumericTimeUnit.NANOSECONDS -> raw.scaleByPowerOfTen(-9);
        };
        s = s.setScale(9, RoundingMode.DOWN);
        return this.fromNanos(s.longValue(), s.remainder(BigDecimal.ONE).unscaledValue().intValueExact());
    }

    @Override
    final void serialize0(Encoder encoder, T value) throws IOException {
        block0 : switch (this.writeShape) {
            case STRING: {
                super.serialize0(encoder, value);
                break;
            }
            case INTEGER: {
                switch (this.numericUnit) {
                    case LEGACY: {
                        throw new AssertionError((Object)"Should be replaced in constructor");
                    }
                    case SECONDS: {
                        encoder.encodeLong(this.getSecondPart(value));
                        break block0;
                    }
                    case MILLISECONDS: {
                        encoder.encodeLong(this.getSecondPart(value) * 1000L + TimeUnit.NANOSECONDS.toMillis(this.getNanoPart(value)));
                        break block0;
                    }
                    case NANOSECONDS: {
                        encoder.encodeBigInteger(BigInteger.valueOf(this.getSecondPart(value)).multiply(NS_FACTOR).add(BigInteger.valueOf(this.getNanoPart(value))));
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            case DECIMAL: {
                BigDecimal s = BigDecimal.valueOf(this.getSecondPart(value)).add(BigDecimal.valueOf(this.getNanoPart(value), 9));
                switch (this.numericUnit) {
                    case LEGACY: {
                        throw new AssertionError((Object)"Should be replaced in constructor");
                    }
                    case SECONDS: {
                        encoder.encodeBigDecimal(s);
                        break block0;
                    }
                    case MILLISECONDS: {
                        encoder.encodeBigDecimal(s.scaleByPowerOfTen(3));
                        break block0;
                    }
                    case NANOSECONDS: {
                        encoder.encodeBigInteger(s.unscaledValue());
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

