/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerializerRegistrar;
import io.micronaut.serde.support.serializers.CharSequenceKeyMapSerializer;
import io.micronaut.serde.support.serializers.RuntimeMapSerializer;
import io.micronaut.serde.support.serializers.StringKeyMapSerializer;
import io.micronaut.serde.util.CustomizableSerializer;
import java.util.Map;

@Internal
final class CustomizedMapSerializer<K, V>
implements CustomizableSerializer<Map<K, V>>,
SerializerRegistrar<Map<K, V>> {
    CustomizedMapSerializer() {
    }

    public ObjectSerializer<Map<K, V>> createSpecific(Serializer.EncoderContext context, Argument<? extends Map<K, V>> type) throws SerdeException {
        boolean hasGenerics;
        Object[] generics = type.getTypeParameters();
        boolean bl = hasGenerics = ArrayUtils.isNotEmpty((Object[])generics) && generics.length == 2;
        if (hasGenerics) {
            Object keyArgument = generics[0];
            if (keyArgument.getType() == String.class) {
                return new StringKeyMapSerializer(type, context);
            }
            if (CharSequence.class.isAssignableFrom(keyArgument.getType())) {
                return new CharSequenceKeyMapSerializer(type, context);
            }
        }
        return new RuntimeMapSerializer(type, context);
    }

    @Override
    public Argument<Map<K, V>> getType() {
        return Argument.mapOf((Argument)Argument.ofTypeVariable(Object.class, (String)"K"), (Argument)Argument.ofTypeVariable(Object.class, (String)"V"));
    }
}

