/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.generator;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.generator.SourceGenerator;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public final class SourceGenerators {
    private static List<SourceGenerator> sourceGenerators;

    private SourceGenerators() {
    }

    @NonNull
    public static synchronized List<SourceGenerator> getAll() {
        if (sourceGenerators == null) {
            sourceGenerators = SoftServiceLoader.load(SourceGenerator.class).collectAll();
        }
        return sourceGenerators;
    }

    @Nullable
    public static Optional<SourceGenerator> findByLanguage(VisitorContext.Language language) {
        return SourceGenerators.getAll().stream().filter(s -> s.getLanguage() == language).findAny();
    }

    public static void handleFatalException(@NonNull Element originatingElement, @NonNull Class<? extends Annotation> annotation, @NonNull Exception exception, Consumer<RuntimeException> postponeCallback) {
        if (!exception.getClass().getSimpleName().equals("PostponeToNextRoundException") || !(exception instanceof RuntimeException)) {
            String message = exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName();
            throw new ProcessingException(originatingElement, "Failed to generate a @" + annotation.getSimpleName() + ": " + message, (Throwable)exception);
        }
        RuntimeException runtimeException = (RuntimeException)exception;
        postponeCallback.accept(runtimeException);
    }
}

