/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.generator.visitors;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.annotations.SuperBuilder;
import io.micronaut.sourcegen.generator.SourceGenerator;
import io.micronaut.sourcegen.generator.SourceGenerators;
import io.micronaut.sourcegen.generator.visitors.BuilderAnnotationVisitor;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

@Internal
public final class SuperBuilderAnnotationVisitor
implements TypeElementVisitor<SuperBuilder, Object> {
    private final Set<String> processed = new HashSet<String>();

    public void start(VisitorContext visitorContext) {
        this.processed.clear();
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (this.processed.contains(element.getName())) {
            return;
        }
        try {
            String abstractBuilderClassName = this.getAbstractSuperBuilderName(element);
            ClassTypeDef abstractBuilderType = ClassTypeDef.of((String)abstractBuilderClassName);
            TypeDef.TypeVariable selfType = TypeDef.variable((String)"B", (TypeDef[])new TypeDef[0]);
            TypeDef.TypeVariable producingType = TypeDef.variable((String)"C", (TypeDef[])new TypeDef[0]);
            ClassDef.ClassDefBuilder abstractBuilder = (ClassDef.ClassDefBuilder)ClassDef.builder((String)abstractBuilderClassName).addTypeVariable(TypeDef.variable((String)"C", (TypeDef[])new TypeDef[]{TypeDef.of((TypedElement)element)})).addTypeVariable(TypeDef.variable((String)"B", (TypeDef[])new TypeDef[]{TypeDef.parameterized((ClassTypeDef)abstractBuilderType, (TypeDef[])new TypeDef[]{producingType, selfType})})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            ClassElement superType = element.getSuperType().orElse(null);
            if (superType != null && !superType.getName().equals("java.lang.Record")) {
                if (!superType.hasStereotype(SuperBuilder.class)) {
                    throw new ProcessingException((Element)element, "Super type [" + superType.getName() + "] must be annotated with @" + SuperBuilder.class.getSimpleName());
                }
                String abstractSuperBuilderName = this.getAbstractSuperBuilderName(superType);
                abstractBuilder.superclass(TypeDef.parameterized((ClassTypeDef)ClassTypeDef.of((String)abstractSuperBuilderName), List.of(new TypeDef.TypeVariable("C"), new TypeDef.TypeVariable("B"))));
            }
            List properties = element.getBeanProperties();
            for (PropertyElement beanProperty : properties) {
                if (!beanProperty.getDeclaringType().equals(element)) continue;
                BuilderAnnotationVisitor.createModifyPropertyMethod(abstractBuilder, abstractBuilderType, beanProperty, buildContext -> buildContext.aThis().invoke("self", (TypeDef)buildContext.aThis().type(), new ExpressionDef[0]).cast((TypeDef)selfType).returning());
            }
            abstractBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)"self").addModifiers(new Modifier[]{Modifier.ABSTRACT})).returns((TypeDef)selfType).build());
            abstractBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)"build").addModifiers(new Modifier[]{Modifier.ABSTRACT})).returns((TypeDef)producingType).build());
            ClassDef abstractBuilderDef = abstractBuilder.build();
            SourceGenerator sourceGenerator = SourceGenerators.findByLanguage(context.getLanguage()).orElse(null);
            if (sourceGenerator == null) {
                return;
            }
            this.processed.add(element.getName());
            sourceGenerator.write((ObjectDef)abstractBuilderDef, context, new Element[]{element});
            if (!element.isAbstract()) {
                String builderClassName = element.getPackageName() + "." + element.getSimpleName() + "SuperBuilder";
                ClassTypeDef builderType = ClassTypeDef.of((String)builderClassName);
                ClassDef.ClassDefBuilder builder = ((ClassDef.ClassDefBuilder)ClassDef.builder((String)builderClassName).addModifiers(new Modifier[]{Modifier.PUBLIC})).superclass(TypeDef.parameterized((ClassTypeDef)ClassTypeDef.of((ObjectDef)abstractBuilderDef), List.of(ClassTypeDef.of((ClassElement)element), builderType)));
                BuilderAnnotationVisitor.addAnnotations(builder, element.getAnnotation(SuperBuilder.class));
                builder.addMethod(MethodDef.constructor().build());
                if (!properties.isEmpty()) {
                    builder.addMethod(BuilderAnnotationVisitor.createAllPropertiesConstructor(properties));
                }
                @NonNull ParameterElement[] constructorElement = element.getPrimaryConstructor().filter(c -> !c.isPrivate()).or(() -> ((ClassElement)element).getDefaultConstructor()).map(MethodElement::getParameters).orElse(ParameterElement.ZERO_PARAMETER_ELEMENTS);
                List<ParameterElement> constructorParameters = Arrays.asList(constructorElement);
                builder.addMethod(this.createSelfMethod());
                builder.addMethod(BuilderAnnotationVisitor.createBuildMethod(ClassTypeDef.of((ClassElement)element), properties, constructorParameters));
                builder.addMethod(this.createBuilderMethod(builderType));
                ClassDef builderDef = builder.build();
                sourceGenerator.write((ObjectDef)builderDef, context, new Element[]{element});
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            SourceGenerators.handleFatalException((Element)element, SuperBuilder.class, e, exception -> {
                this.processed.remove(element.getName());
                throw exception;
            });
        }
    }

    private MethodDef createBuilderMethod(ClassTypeDef builderType) {
        return ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC})).returns((TypeDef)builderType).addStatement(builderType.instantiate(new ExpressionDef[0]).returning()).build();
    }

    private MethodDef createSelfMethod() {
        return ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"self").addModifiers(new Modifier[]{Modifier.PUBLIC})).build((self, parameterDefs) -> self.returning());
    }

    private String getAbstractSuperBuilderName(ClassElement element) {
        return element.getPackageName() + ".Abstract" + element.getSimpleName() + "SuperBuilder";
    }
}

