/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.visitor;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Set;
import java.util.stream.Stream;

@Internal
public class IntrospectedValidationIndexesVisitor
implements TypeElementVisitor<Object, Object> {
    private static final String ANN_CONSTRAINT = "jakarta.validation.Constraint";
    private static final String ANN_VALID = "jakarta.validation.Valid";
    private static final AnnotationValue<Introspected.IndexedAnnotation> INTROSPECTION_INDEXED_CONSTRAINT = AnnotationValue.builder(Introspected.IndexedAnnotation.class).member("annotation", new AnnotationClassValue[]{new AnnotationClassValue("jakarta.validation.Constraint")}).build();
    private static final AnnotationValue<Introspected.IndexedAnnotation> INTROSPECTION_INDEXED_VALID = AnnotationValue.builder(Introspected.IndexedAnnotation.class).member("annotation", new AnnotationClassValue[]{new AnnotationClassValue("jakarta.validation.Valid")}).build();
    private ClassElement classElement;

    public int getOrder() {
        return -90;
    }

    public Set<String> getSupportedAnnotationNames() {
        return Set.of("jakarta.validation.*");
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        this.classElement = element;
        if (this.classElement.hasStereotype(Introspected.class)) {
            AnnotationMetadata annotationMetadata = this.classElement.getAnnotationMetadata();
            AnnotationValue introspectedAnnotation = annotationMetadata.getAnnotation(Introspected.class);
            this.classElement.annotate(Introspected.class, builder -> {
                AnnotationValue[] indexed = (AnnotationValue[])Stream.concat(introspectedAnnotation.getAnnotations("indexed", Introspected.IndexedAnnotation.class).stream(), Stream.of(INTROSPECTION_INDEXED_CONSTRAINT, INTROSPECTION_INDEXED_VALID)).toArray(AnnotationValue[]::new);
                builder.member("indexed", indexed);
            });
        }
    }
}

