/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.validation.validator.BeanValidationContext;
import io.micronaut.validation.validator.DefaultConstraintViolation;
import io.micronaut.validation.validator.DefaultConstraintViolationBuilder;
import io.micronaut.validation.validator.DefaultValidator;
import io.micronaut.validation.validator.ValidationPath;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.GroupDefinitionException;
import jakarta.validation.GroupSequence;
import jakarta.validation.ValidationException;
import jakarta.validation.groups.ConvertGroup;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Internal
public final class DefaultConstraintValidatorContext<R>
implements ConstraintValidatorContext {
    private static final Map<Class<?>, List<Class<?>>> GROUP_SEQUENCES = new ConcurrentHashMap();
    private static final List<Class<?>> DEFAULT_GROUPS = Collections.singletonList(Default.class);
    boolean disableDefaultConstraintViolation;
    ConstraintDescriptor<Annotation> constraint;
    private final BeanValidationContext validationContext;
    private final DefaultValidator defaultValidator;
    private final BeanIntrospection<R> beanIntrospection;
    private final R rootBean;
    @Nullable
    private final Class<R> rootClass;
    private final Set<Object> validatedObjects = new HashSet<Object>(20);
    private final ValidationPath currentPath;
    private final List<Class<?>> definedGroups;
    private String messageTemplate = null;
    private final Set<ConstraintViolation<R>> overallViolations;
    @Nullable
    private Object[] executableParameterValues;
    @Nullable
    private Object executableReturnValue;
    private List<Class<?>> currentGroups;
    private Map<Class<?>, Class<?>> convertedGroups = Collections.emptyMap();
    private boolean hasCurrentViolations = false;

    DefaultConstraintValidatorContext(DefaultValidator defaultValidator, BeanIntrospection<R> beanIntrospection, R rootBean, BeanValidationContext validationContext) {
        this(defaultValidator, beanIntrospection, validationContext, rootBean, null, new ValidationPath(), new LinkedHashSet<ConstraintViolation<R>>(), null, Collections.emptyList());
    }

    private DefaultConstraintValidatorContext(DefaultValidator defaultValidator, BeanIntrospection<R> beanIntrospection, BeanValidationContext validationContext, R rootBean, Object executableReturnValue, ValidationPath path, Set<ConstraintViolation<R>> overallViolations, Object[] executableParameterValues, List<Class<?>> currentGroups) {
        this.validationContext = validationContext;
        this.defaultValidator = defaultValidator;
        this.beanIntrospection = beanIntrospection;
        this.rootBean = rootBean;
        this.rootClass = beanIntrospection == null ? (rootBean == null ? null : rootBean.getClass()) : beanIntrospection.getBeanType();
        this.executableParameterValues = executableParameterValues;
        this.executableReturnValue = executableReturnValue;
        this.definedGroups = DefaultConstraintValidatorContext.processGroups(validationContext.groups());
        this.currentGroups = currentGroups;
        this.currentPath = path != null ? path : new ValidationPath();
        this.overallViolations = overallViolations;
    }

    @NonNull
    public BeanValidationContext getValidationContext() {
        return this.validationContext;
    }

    private static List<Class<?>> processGroups(List<Class<?>> definedGroups) {
        if (CollectionUtils.isEmpty(definedGroups)) {
            return DEFAULT_GROUPS;
        }
        DefaultConstraintValidatorContext.sanityCheckGroups(definedGroups);
        ArrayList groupList = new ArrayList();
        for (Class<?> group : definedGroups) {
            DefaultConstraintValidatorContext.addInheritedGroups(group, groupList);
        }
        return Collections.unmodifiableList(groupList);
    }

    private static void sanityCheckGroups(List<Class<?>> groups) {
        ArgumentUtils.requireNonNull((String)"groups", groups);
        for (Class<?> clazz : groups) {
            if (clazz == null) {
                throw new IllegalArgumentException("Validation groups must be non-null");
            }
            if (clazz.isInterface()) continue;
            throw new IllegalArgumentException("Validation groups must be interfaces. " + clazz.getName() + " is not.");
        }
    }

    private static boolean hasDefaultGroup(List<Class<?>> definedGroups) {
        return definedGroups.equals(DEFAULT_GROUPS);
    }

    public boolean containsGroup(Collection<Class<?>> constraintGroups) {
        if (this.currentGroups.contains(Default.class) && this.rootClass != null && constraintGroups.contains(this.rootClass)) {
            return true;
        }
        for (Class<?> group : this.currentGroups) {
            if (!constraintGroups.contains(group)) continue;
            return true;
        }
        return false;
    }

    public Object[] getExecutableParameterValues() {
        return this.executableParameterValues;
    }

    public Object getExecutableReturnValue() {
        return this.executableReturnValue;
    }

    public boolean isValidated(Object obj) {
        return this.validatedObjects.contains(obj);
    }

    public ValidationCloseable validating(Object obj) {
        this.validatedObjects.add(obj);
        return () -> this.validatedObjects.remove(obj);
    }

    public ValidationCloseable withExecutableParameterValues(Object[] executableParameterValues) {
        Object[] prevExecutableParameterValues = this.executableParameterValues;
        this.executableParameterValues = executableParameterValues;
        return () -> {
            this.executableParameterValues = prevExecutableParameterValues;
        };
    }

    public ValidationCloseable withExecutableReturnValue(Object executableReturnValue) {
        Object prevExecutableReturnValue = this.executableReturnValue;
        this.executableReturnValue = executableReturnValue;
        return () -> {
            this.executableReturnValue = prevExecutableReturnValue;
        };
    }

    public GroupsValidation withGroupSequence(final @NonNull ValidationGroup validationGroup) {
        final List<Class<?>> prevGroups = this.currentGroups;
        final boolean prevViolations = this.hasCurrentViolations;
        this.currentGroups = validationGroup.groups();
        this.hasCurrentViolations = false;
        return new GroupsValidation(){

            @Override
            public boolean isFailed() {
                if (validationGroup.isRedefinedDefaultGroupSequence()) {
                    return !DefaultConstraintValidatorContext.this.overallViolations.isEmpty();
                }
                return DefaultConstraintValidatorContext.this.hasCurrentViolations;
            }

            @Override
            public void close() {
                DefaultConstraintValidatorContext.this.currentGroups = prevGroups;
                DefaultConstraintValidatorContext.this.hasCurrentViolations = prevViolations;
            }
        };
    }

    public ValidationCloseable convertGroups(@NonNull AnnotationMetadata annotationMetadata) {
        List conversions = annotationMetadata.getAnnotationValuesByType(ConvertGroup.class);
        if (conversions.isEmpty()) {
            return () -> {};
        }
        Map<Class<?>, Class<?>> prevConvertedGroups = this.convertedGroups;
        List<Class<?>> prevGroups = this.currentGroups;
        this.convertedGroups = new HashMap(prevConvertedGroups);
        Map<Class, Class> newConvertGroups = conversions.stream().collect(Collectors.toMap(av -> av.classValue("from").orElse(Default.class), av -> (Class)av.classValue("to").orElseThrow()));
        this.convertedGroups.putAll(newConvertGroups);
        this.currentGroups = prevGroups.stream().map(c -> DefaultConstraintValidatorContext.convertGroup(this.convertedGroups, c)).toList();
        return () -> {
            this.convertedGroups = prevConvertedGroups;
            this.currentGroups = prevGroups;
        };
    }

    List<ValidationGroup> findGroupSequences(@Nullable Object bean) {
        if (bean == null) {
            return this.findGroupSequences();
        }
        BeanIntrospection<Object> beanIntrospection = this.defaultValidator.getBeanIntrospection(bean);
        if (beanIntrospection == null) {
            return this.findGroupSequences();
        }
        return this.findGroupSequences(beanIntrospection);
    }

    public List<ValidationGroup> findGroupSequences(BeanIntrospection<?> beanIntrospection) {
        FindGroupContext ctx = new FindGroupContext(this.defaultValidator, this.convertedGroups, this.definedGroups);
        if (ctx.isDefault()) {
            return this.defaultValidator.findGroupSequencesCache.computeIfAbsent(beanIntrospection, bi -> List.copyOf(DefaultConstraintValidatorContext.findGroupSequences(ctx, bi)));
        }
        return DefaultConstraintValidatorContext.findGroupSequences(ctx, beanIntrospection);
    }

    private static List<ValidationGroup> findGroupSequences(FindGroupContext ctx, BeanIntrospection<?> beanIntrospection) {
        Class[] classGroupSequence;
        if (DefaultConstraintValidatorContext.hasDefaultGroup(ctx.definedGroups) && (classGroupSequence = beanIntrospection.classValues(GroupSequence.class)).length > 0) {
            if (Arrays.stream(classGroupSequence).noneMatch(c -> c == beanIntrospection.getBeanType())) {
                throw new GroupDefinitionException("Group sequence is missing default group defined by the class of: " + String.valueOf(beanIntrospection.getBeanType()));
            }
            ArrayList<ValidationGroup> dest = new ArrayList<ValidationGroup>();
            for (Class group : classGroupSequence) {
                if (group == beanIntrospection.getBeanType()) {
                    dest.add(new ValidationGroup(true, true, List.of(Default.class)));
                    continue;
                }
                DefaultConstraintValidatorContext.findGroups(ctx, dest, List.of(group), new HashSet());
            }
            return dest;
        }
        return DefaultConstraintValidatorContext.findGroupSequences(ctx);
    }

    public List<ValidationGroup> findGroupSequences() {
        FindGroupContext ctx = new FindGroupContext(this.defaultValidator, this.convertedGroups, this.definedGroups);
        if (ctx.isDefault()) {
            return this.defaultValidator.findGroupSequencesCache.computeIfAbsent(null, ignored -> List.copyOf(DefaultConstraintValidatorContext.findGroupSequences(ctx)));
        }
        return DefaultConstraintValidatorContext.findGroupSequences(ctx);
    }

    private static List<ValidationGroup> findGroupSequences(FindGroupContext ctx) {
        ArrayList<ValidationGroup> dest = new ArrayList<ValidationGroup>();
        DefaultConstraintValidatorContext.findGroups(ctx, dest, ctx.definedGroups, new HashSet());
        return dest;
    }

    private static void findGroups(FindGroupContext ctx, List<ValidationGroup> dest, Class<?> group, Set<Class<?>> processedGroups) {
        if (ctx.convertedGroups != null) {
            group = DefaultConstraintValidatorContext.convertGroup(ctx.convertedGroups, group);
        }
        if (!processedGroups.add(group)) {
            throw new GroupDefinitionException("Cyclical group: " + String.valueOf(group));
        }
        Class<?> finalGroup = group;
        List groupSequence = GROUP_SEQUENCES.computeIfAbsent(group, ignore -> ctx.defaultValidator.getBeanIntrospector().findIntrospection(finalGroup).stream().flatMap(introspection -> Arrays.stream(introspection.classValues(GroupSequence.class))).toList());
        if (groupSequence.isEmpty()) {
            dest.add(new ValidationGroup(false, false, List.of(group)));
            return;
        }
        int start = dest.size();
        for (Class g : groupSequence) {
            DefaultConstraintValidatorContext.findGroups(ctx, dest, g, processedGroups);
        }
        for (int i = start; i < groupSequence.size(); ++i) {
            ValidationGroup vg = dest.get(i);
            dest.set(i, new ValidationGroup(true, true, vg.groups));
        }
    }

    private static Class<?> convertGroup(Map<Class<?>, Class<?>> convertedGroups, Class<?> group) {
        Class<?> newGroup = convertedGroups.get(group);
        if (newGroup == null) {
            return group;
        }
        return newGroup;
    }

    private static void findGroups(FindGroupContext ctx, List<ValidationGroup> dest, List<Class<?>> groupSequence, Set<Class<?>> processedGroups) {
        int start = dest.size();
        for (Class<?> g : groupSequence) {
            DefaultConstraintValidatorContext.findGroups(ctx, dest, g, processedGroups);
        }
        boolean anySequence = false;
        for (int i = start; i < groupSequence.size() && !anySequence; anySequence |= dest.get((int)i).isSequence, ++i) {
        }
        if (!anySequence) {
            List<ValidationGroup> subList = dest.subList(start, dest.size());
            ArrayList copy = new ArrayList();
            for (ValidationGroup validationGroup : subList) {
                copy.addAll(validationGroup.groups);
            }
            subList.clear();
            dest.add(new ValidationGroup(false, false, copy));
        }
    }

    public void addViolation(DefaultConstraintViolation<R> violation) {
        this.hasCurrentViolations = true;
        this.overallViolations.add(violation);
    }

    public Set<ConstraintViolation<R>> getOverallViolations() {
        return this.overallViolations;
    }

    public ValidationPath getCurrentPath() {
        return this.currentPath;
    }

    @Nullable
    public R getRootBean() {
        return this.rootBean;
    }

    public Class<R> getRootClass() {
        return this.rootClass;
    }

    private static void addInheritedGroups(Class<?> group, List<Class<?>> groups) {
        if (!groups.contains(group)) {
            groups.add(group);
        }
        for (Class<?> inheritedGroup : group.getInterfaces()) {
            DefaultConstraintValidatorContext.addInheritedGroups(inheritedGroup, groups);
        }
    }

    public void disableDefaultConstraintViolation() {
        this.disableDefaultConstraintViolation = true;
    }

    public String getDefaultConstraintMessageTemplate() {
        return this.getMessageTemplate().orElse(Objects.requireNonNull(this.constraint).getMessageTemplate());
    }

    @Override
    @NonNull
    public ClockProvider getClockProvider() {
        return this.defaultValidator.getClockProvider();
    }

    public ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        return new DefaultConstraintViolationBuilder(messageTemplate, this, this.defaultValidator.messageInterpolator);
    }

    public <T> T unwrap(Class<T> type) {
        throw new ValidationException("Not supported");
    }

    @Override
    public void messageTemplate(@Nullable String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    Optional<String> getMessageTemplate() {
        return Optional.ofNullable(this.messageTemplate);
    }

    DefaultConstraintValidatorContext<R> copy() {
        return new DefaultConstraintValidatorContext<R>(this.defaultValidator, this.beanIntrospection, this.validationContext, this.rootBean, this.executableReturnValue, new ValidationPath(this.currentPath), new LinkedHashSet<ConstraintViolation<R>>(this.overallViolations), this.executableParameterValues, this.currentGroups);
    }

    @Internal
    static interface ValidationCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }

    @Internal
    record ValidationGroup(boolean isSequence, boolean isRedefinedDefaultGroupSequence, List<Class<?>> groups) {
    }

    private record FindGroupContext(DefaultValidator defaultValidator, Map<Class<?>, Class<?>> convertedGroups, List<Class<?>> definedGroups) {
        boolean isDefault() {
            return this.definedGroups == DEFAULT_GROUPS && this.convertedGroups.isEmpty();
        }
    }

    @Internal
    static interface GroupsValidation
    extends ValidationCloseable {
        public boolean isFailed();
    }
}

