/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.InternalConstraintValidatorFactory;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.ValidationException;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Bean(typed={InternalConstraintValidatorFactory.class})
@Singleton
@Internal
public class DefaultInternalConstraintValidatorFactory
implements InternalConstraintValidatorFactory {
    private final Map<Class<?>, ConstraintValidatorEntry> validators = new ConcurrentHashMap();
    private final BeanIntrospector beanIntrospector;
    @Nullable
    private final BeanContext beanContext;

    public DefaultInternalConstraintValidatorFactory(BeanIntrospector beanIntrospector, @Nullable BeanContext beanContext) {
        this.beanIntrospector = beanIntrospector;
        this.beanContext = beanContext;
    }

    @Inject
    public DefaultInternalConstraintValidatorFactory(BeanContext beanContext) {
        this.beanIntrospector = BeanIntrospector.SHARED;
        this.beanContext = beanContext;
    }

    public <T extends jakarta.validation.ConstraintValidator<?, ?>> T getInstance(Class<T> type) {
        ConstraintValidatorEntry entry = this.findConstraintValidator(type);
        if (entry == null) {
            return null;
        }
        return (T)entry.constraintValidator;
    }

    public void releaseInstance(jakarta.validation.ConstraintValidator<?, ?> constraintValidator) {
        this.validators.values().stream().filter(entry -> entry.beanRegistration != null && entry.constraintValidator == constraintValidator).forEach(entry -> this.beanContext.destroyBean(entry.beanRegistration));
    }

    @Override
    public <T extends jakarta.validation.ConstraintValidator<?, ?>> T getInstance(Class<T> type, Class<?> targetType, ConstraintTarget constraintTarget) {
        Class resolvedTargetType;
        ConstraintValidatorEntry entry = this.findConstraintValidator(type);
        if (entry == null) {
            return null;
        }
        Class clazz = resolvedTargetType = targetType.isPrimitive() ? ReflectionUtils.getWrapperType(targetType) : targetType;
        if (this.allowsConstraintTarget(entry.target, constraintTarget) && entry.targetType.isAssignableFrom(resolvedTargetType)) {
            return (T)entry.constraintValidator;
        }
        return null;
    }

    @Nullable
    private <T extends jakarta.validation.ConstraintValidator<?, ?>> ConstraintValidatorEntry findConstraintValidator(Class<T> type) {
        ConstraintValidatorEntry entry = this.validators.get(type);
        if (entry != null) {
            return entry;
        }
        try {
            entry = this.beanIntrospector.findIntrospection(type).map(this::instantiateConstraintValidatorEntry).orElseGet(() -> this.instantiateConstraintValidatorEntryOfBeanRegistration(type));
        }
        catch (Exception e) {
            throw new ValidationException("Cannot initialize validator: " + type.getName());
        }
        if (entry != null) {
            this.validators.put(type, entry);
        }
        return entry;
    }

    @NonNull
    private <T extends jakarta.validation.ConstraintValidator<?, ?>> ConstraintValidatorEntry instantiateConstraintValidatorEntry(@NonNull BeanIntrospection<T> beanIntrospection) {
        return new ConstraintValidatorEntry((jakarta.validation.ConstraintValidator)beanIntrospection.instantiate(), this.getBeanType(beanIntrospection), this.getValidationTarget((AnnotationMetadata)beanIntrospection), null);
    }

    @Nullable
    private <T extends jakarta.validation.ConstraintValidator<?, ?>> ConstraintValidatorEntry instantiateConstraintValidatorEntryOfBeanRegistration(Class<T> type) {
        Collection beanRegistrations = this.beanContext.getBeanRegistrations(type);
        if (CollectionUtils.isEmpty((Collection)beanRegistrations)) {
            return null;
        }
        BeanRegistration beanRegistration = (BeanRegistration)beanRegistrations.iterator().next();
        List typeArguments = beanRegistration.getBeanDefinition().getTypeArguments(jakarta.validation.ConstraintValidator.class);
        return new ConstraintValidatorEntry((jakarta.validation.ConstraintValidator)beanRegistration.bean(), typeArguments.size() == 2 ? ((Argument)typeArguments.get(1)).getType() : Object.class, this.getValidationTarget(beanRegistration.getAnnotationMetadata()), beanRegistration);
    }

    private Class<?> getBeanType(BeanIntrospection<?> beanIntrospection) {
        AnnotatedType[] annotatedInterfaces = beanIntrospection.getBeanType().getAnnotatedInterfaces();
        if (annotatedInterfaces != null) {
            for (AnnotatedType annotatedInterface : annotatedInterfaces) {
                Type typeArgument;
                Type[] typeArguments;
                ParameterizedType parameterizedType;
                Type type = annotatedInterface.getType();
                if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != ConstraintValidator.class && parameterizedType.getRawType() != jakarta.validation.ConstraintValidator.class || (typeArguments = parameterizedType.getActualTypeArguments()).length != 2 || !((typeArgument = typeArguments[1]) instanceof Class)) continue;
                Class aClass = (Class)typeArgument;
                return aClass;
            }
        }
        return Object.class;
    }

    private Set<ValidationTarget> getValidationTarget(AnnotationMetadata annotationMetadata) {
        return Set.of((ValidationTarget[])annotationMetadata.enumValues(SupportedValidationTarget.class, ValidationTarget.class));
    }

    private boolean allowsConstraintTarget(Set<ValidationTarget> validationTarget, ConstraintTarget constraintTarget) {
        if (constraintTarget == ConstraintTarget.PARAMETERS && !validationTarget.contains(ValidationTarget.PARAMETERS)) {
            return false;
        }
        return constraintTarget == ConstraintTarget.PARAMETERS || validationTarget.isEmpty() || validationTarget.contains(ValidationTarget.ANNOTATED_ELEMENT);
    }

    private record ConstraintValidatorEntry(jakarta.validation.ConstraintValidator<?, ?> constraintValidator, Class<?> targetType, Set<ValidationTarget> target, @Nullable BeanRegistration<?> beanRegistration) {
    }
}

