/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.extractors;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.validation.validator.extractors.InternalValueExtractors;
import io.micronaut.validation.validator.extractors.ValueExtractorDefinition;
import io.micronaut.validation.validator.extractors.ValueExtractorRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.valueextraction.ValueExtractor;
import jakarta.validation.valueextraction.ValueExtractorDeclarationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

@Internal
@Singleton
@Introspected
public final class DefaultValueExtractors
implements ValueExtractorRegistry {
    private final Map<Class<?>, List<ValueExtractorDefinition<?>>> internalValueExtractors = new HashMap();
    private final Map<Class<?>, List<ValueExtractorDefinition<?>>> localValueExtractors = new HashMap();
    private final Map<Class<?>, List<ValueExtractorDefinition<?>>> matchingValueExtractors = new ConcurrentHashMap();

    public DefaultValueExtractors() {
        this(null);
    }

    @Inject
    protected DefaultValueExtractors(@Nullable BeanContext beanContext) {
        Collection valueExtractors;
        for (Map.Entry<Argument<Object>, ValueExtractor<?>> entry : InternalValueExtractors.getValueExtractors()) {
            Argument<Object> definition = entry.getKey();
            ValueExtractor<?> valueExtractor = entry.getValue();
            this.addValueExtractor(this.internalValueExtractors, new ValueExtractorDefinition(definition, valueExtractor));
        }
        if (beanContext != null && beanContext.containsBean(ValueExtractor.class) && CollectionUtils.isNotEmpty((Collection)(valueExtractors = beanContext.getBeanRegistrations(ValueExtractor.class)))) {
            for (BeanRegistration reg : valueExtractors) {
                BeanDefinition beanDefinition = reg.getBeanDefinition();
                Argument argument = beanDefinition.asArgument();
                if (argument.getType().equals(ValueExtractor.class)) {
                    this.addValueExtractor(this.localValueExtractors, new ValueExtractorDefinition(argument, (ValueExtractor)reg.getBean()));
                    continue;
                }
                List typeArguments = beanDefinition.getTypeArguments(ValueExtractor.class);
                if (typeArguments.isEmpty()) {
                    throw new IllegalStateException("No value-extractors found for bean definition: " + String.valueOf(beanDefinition));
                }
                this.addValueExtractor(this.localValueExtractors, new ValueExtractorDefinition(Argument.of(ValueExtractor.class, (AnnotationMetadata)beanDefinition.getAnnotationMetadata(), (Argument[])typeArguments.toArray(new Argument[0])), (ValueExtractor)reg.getBean()));
            }
        }
    }

    @Override
    public <T> void addValueExtractor(ValueExtractorDefinition<T> valueExtractorDefinition) {
        this.addValueExtractor(this.localValueExtractors, valueExtractorDefinition);
    }

    private <T> void addValueExtractor(Map<Class<?>, List<ValueExtractorDefinition<?>>> collection, ValueExtractorDefinition<T> valueExtractorDefinition) {
        List valueExtractorDefinitions = collection.computeIfAbsent(valueExtractorDefinition.containerType(), ignore -> new ArrayList());
        if (valueExtractorDefinitions.stream().anyMatch(def -> def.containerType().equals(valueExtractorDefinition.containerType()) && Objects.equals(def.typeArgumentIndex(), valueExtractorDefinition.typeArgumentIndex()))) {
            throw new ValueExtractorDeclarationException("Value extractor with this type and type argument is already defined!");
        }
        valueExtractorDefinitions.add(valueExtractorDefinition);
    }

    @Override
    @NonNull
    public <T> List<ValueExtractorDefinition<T>> findValueExtractors(@NonNull Class<T> targetType) {
        List<ValueExtractorDefinition<Object>> valueExtractorDefinitions = this.matchingValueExtractors.get(targetType);
        if (valueExtractorDefinitions == null) {
            valueExtractorDefinitions = this.localValueExtractors.get(targetType);
            if (valueExtractorDefinitions == null) {
                valueExtractorDefinitions = this.internalValueExtractors.get(targetType);
            }
            if (valueExtractorDefinitions == null) {
                valueExtractorDefinitions = Stream.concat(this.localValueExtractors.entrySet().stream(), this.internalValueExtractors.entrySet().stream()).filter(entry -> ((Class)entry.getKey()).isAssignableFrom(targetType)).map(Map.Entry::getValue).findFirst().orElseGet(List::of);
            }
            this.matchingValueExtractors.put(targetType, valueExtractorDefinitions);
        }
        return valueExtractorDefinitions;
    }
}

