/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;

public class ClassLoadingStrategyChooser {
    private static final Method PRIVATE_LOOKUP_IN;
    private static final Object LOOKUP;

    public static <T> ClassLoadingStrategy<ClassLoader> chooseClassLoadingStrategy(Class<T> type) {
        try {
            ClassLoadingStrategy.Configurable strategy;
            if (!type.getName().startsWith("java.") && ClassInjector.UsingLookup.isAvailable() && PRIVATE_LOOKUP_IN != null && LOOKUP != null) {
                Object privateLookup = PRIVATE_LOOKUP_IN.invoke(null, type, LOOKUP);
                strategy = ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
            } else {
                strategy = ClassInjector.UsingReflection.isAvailable() ? ClassLoadingStrategy.Default.INJECTION.with(type.getProtectionDomain()) : ClassLoadingStrategy.Default.WRAPPER.with(type.getProtectionDomain());
            }
            return strategy;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Failed to invoke 'privateLookupIn' method from java.lang.invoke.MethodHandles$Lookup.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to invoke 'privateLookupIn' method from java.lang.invoke.MethodHandles$Lookup.", e);
        }
    }

    static {
        Method privateLookupIn;
        Object lookup;
        try {
            Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
            lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
            privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
        }
        catch (Exception e) {
            privateLookupIn = null;
            lookup = null;
        }
        PRIVATE_LOOKUP_IN = privateLookupIn;
        LOOKUP = lookup;
    }
}

