/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.servlet;

import io.opencensus.contrib.http.HttpExtractor;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class OcHttpServletExtractor
extends HttpExtractor<HttpServletRequest, HttpServletResponse> {
    OcHttpServletExtractor() {
    }

    public String getHost(HttpServletRequest request) {
        return request.getServerName();
    }

    public String getMethod(HttpServletRequest request) {
        return request.getMethod();
    }

    public String getPath(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }

    public int getStatusCode(@Nullable HttpServletResponse response) {
        if (response != null) {
            return response.getStatus();
        }
        return 0;
    }

    public String getUrl(HttpServletRequest request) {
        return request.getRequestURL().toString() + "?" + request.getQueryString();
    }

    public String getRoute(HttpServletRequest request) {
        return "";
    }
}

