/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.monitoredresource.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class AwsIdentityDocUtils {
    private static final Object monitor = new Object();
    private static final int AWS_IDENTITY_DOC_BUF_SIZE = 2048;
    private static final String AWS_IDENTITY_DOC_LINE_BREAK_SPLITTER = "\n";
    private static final String AWS_IDENTITY_DOC_COLON_SPLITTER = ":";
    private static final URI AWS_INSTANCE_IDENTITY_DOCUMENT_URI = URI.create("http://169.254.169.254/latest/dynamic/instance-identity/document");
    @Nullable
    @GuardedBy(value="monitor")
    private static Map<String, String> awsEnvVarMap = null;
    private static volatile boolean isRunningOnAwsEc2 = false;

    static boolean isRunningOnAwsEc2() {
        return isRunningOnAwsEc2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeAwsIdentityDocument() {
        InputStream stream = null;
        try {
            stream = AwsIdentityDocUtils.openStream(AWS_INSTANCE_IDENTITY_DOCUMENT_URI);
            String awsIdentityDocument = AwsIdentityDocUtils.slurp(new InputStreamReader(stream, Charset.forName("UTF-8")));
            Object object = monitor;
            synchronized (object) {
                awsEnvVarMap = AwsIdentityDocUtils.parseAwsIdentityDocument(awsIdentityDocument);
            }
            isRunningOnAwsEc2 = true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static InputStream openStream(URI uri) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(uri.toURL().openConnection());
        connection.setConnectTimeout(2000);
        connection.setReadTimeout(2000);
        connection.setAllowUserInteraction(false);
        connection.setInstanceFollowRedirects(false);
        return connection.getInputStream();
    }

    private static String slurp(Reader reader) throws IOException {
        StringBuilder to = new StringBuilder();
        CharBuffer buf = CharBuffer.allocate(2048);
        while (reader.read(buf) != -1) {
            buf.flip();
            to.append(buf);
            buf.clear();
        }
        return to.toString();
    }

    static Map<String, String> parseAwsIdentityDocument(String awsIdentityDocument) {
        String[] lines;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : lines = awsIdentityDocument.split(AWS_IDENTITY_DOC_LINE_BREAK_SPLITTER, -1)) {
            String[] keyValuePair = line.split(AWS_IDENTITY_DOC_COLON_SPLITTER, -1);
            if (keyValuePair.length != 2) continue;
            String key = keyValuePair[0].replaceAll("[\" ]", "");
            String value = keyValuePair[1].replaceAll("[\" ,]", "");
            map.put(key, value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static String getValueFromAwsIdentityDocument(String key) {
        Object object = monitor;
        synchronized (object) {
            if (awsEnvVarMap == null) {
                return null;
            }
            return awsEnvVarMap.get(key);
        }
    }

    private AwsIdentityDocUtils() {
    }

    static {
        AwsIdentityDocUtils.initializeAwsIdentityDocument();
    }
}

