/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.monitoredresource.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

final class GcpMetadataConfig {
    private static final String METADATA_URL = "http://metadata/computeMetadata/v1/";

    private GcpMetadataConfig() {
    }

    @Nullable
    static String getProjectId() {
        return GcpMetadataConfig.getAttribute("project/project-id");
    }

    @Nullable
    static String getZone() {
        String zoneId = GcpMetadataConfig.getAttribute("instance/zone");
        if (zoneId == null) {
            return null;
        }
        if (zoneId.contains("/")) {
            return zoneId.substring(zoneId.lastIndexOf(47) + 1);
        }
        return zoneId;
    }

    @Nullable
    static String getInstanceId() {
        return GcpMetadataConfig.getAttribute("instance/id");
    }

    @Nullable
    static String getClusterName() {
        return GcpMetadataConfig.getAttribute("instance/attributes/cluster-name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getAttribute(String attributeName) {
        block6: {
            String string;
            block7: {
                URL url = new URL(METADATA_URL + attributeName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("Metadata-Flavor", "Google");
                InputStream input = connection.getInputStream();
                if (connection.getResponseCode() != 200) break block6;
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(input, Charset.forName("UTF-8")));
                    string = reader.readLine();
                    if (reader == null) break block7;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                reader.close();
            }
            return string;
        }
        return null;
    }
}

