/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.monitoredresource.util;

import io.opencensus.contrib.monitoredresource.util.AutoValue_MonitoredResource_AwsEc2InstanceMonitoredResource;
import io.opencensus.contrib.monitoredresource.util.AutoValue_MonitoredResource_GcpGceInstanceMonitoredResource;
import io.opencensus.contrib.monitoredresource.util.AutoValue_MonitoredResource_GcpGkeContainerMonitoredResource;
import io.opencensus.contrib.monitoredresource.util.AwsIdentityDocUtils;
import io.opencensus.contrib.monitoredresource.util.GcpMetadataConfig;
import io.opencensus.contrib.monitoredresource.util.ResourceType;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class MonitoredResource {
    MonitoredResource() {
    }

    public abstract ResourceType getResourceType();

    private static <T> T firstNonNull(@Nullable T first, @Nullable T second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException("Both parameters are null");
    }

    static /* synthetic */ Object access$000(Object x0, Object x1) {
        return MonitoredResource.firstNonNull(x0, x1);
    }

    @Immutable
    public static abstract class GcpGkeContainerMonitoredResource
    extends MonitoredResource {
        private static final String GCP_ACCOUNT_ID = (String)MonitoredResource.access$000(GcpMetadataConfig.getProjectId(), "");
        private static final String GCP_CLUSTER_NAME = (String)MonitoredResource.access$000(GcpMetadataConfig.getClusterName(), "");
        private static final String GCP_CONTAINER_NAME = (String)MonitoredResource.access$000(System.getenv("CONTAINER_NAME"), "");
        private static final String GCP_NAMESPACE_ID = (String)MonitoredResource.access$000(System.getenv("NAMESPACE"), "");
        private static final String GCP_INSTANCE_ID = (String)MonitoredResource.access$000(GcpMetadataConfig.getInstanceId(), "");
        private static final String GCP_POD_ID = (String)MonitoredResource.access$000(System.getenv("HOSTNAME"), "");
        private static final String GCP_ZONE = (String)MonitoredResource.access$000(GcpMetadataConfig.getZone(), "");

        @Override
        public ResourceType getResourceType() {
            return ResourceType.GCP_GKE_CONTAINER;
        }

        public abstract String getAccount();

        public abstract String getClusterName();

        public abstract String getContainerName();

        public abstract String getNamespaceId();

        public abstract String getInstanceId();

        public abstract String getPodId();

        public abstract String getZone();

        public static GcpGkeContainerMonitoredResource create(String account, String clusterName, String containerName, String namespaceId, String instanceId, String podId, String zone) {
            return new AutoValue_MonitoredResource_GcpGkeContainerMonitoredResource(account, clusterName, containerName, namespaceId, instanceId, podId, zone);
        }

        static GcpGkeContainerMonitoredResource create() {
            return GcpGkeContainerMonitoredResource.create(GCP_ACCOUNT_ID, GCP_CLUSTER_NAME, GCP_CONTAINER_NAME, GCP_NAMESPACE_ID, GCP_INSTANCE_ID, GCP_POD_ID, GCP_ZONE);
        }
    }

    @Immutable
    public static abstract class GcpGceInstanceMonitoredResource
    extends MonitoredResource {
        private static final String GCP_ACCOUNT_ID = (String)MonitoredResource.access$000(GcpMetadataConfig.getProjectId(), "");
        private static final String GCP_INSTANCE_ID = (String)MonitoredResource.access$000(GcpMetadataConfig.getInstanceId(), "");
        private static final String GCP_ZONE = (String)MonitoredResource.access$000(GcpMetadataConfig.getZone(), "");

        @Override
        public ResourceType getResourceType() {
            return ResourceType.GCP_GCE_INSTANCE;
        }

        public abstract String getAccount();

        public abstract String getInstanceId();

        public abstract String getZone();

        public static GcpGceInstanceMonitoredResource create(String account, String instanceId, String zone) {
            return new AutoValue_MonitoredResource_GcpGceInstanceMonitoredResource(account, instanceId, zone);
        }

        static GcpGceInstanceMonitoredResource create() {
            return GcpGceInstanceMonitoredResource.create(GCP_ACCOUNT_ID, GCP_INSTANCE_ID, GCP_ZONE);
        }
    }

    @Immutable
    public static abstract class AwsEc2InstanceMonitoredResource
    extends MonitoredResource {
        private static final String AWS_ACCOUNT = (String)MonitoredResource.access$000(AwsIdentityDocUtils.getValueFromAwsIdentityDocument("accountId"), "");
        private static final String AWS_INSTANCE_ID = (String)MonitoredResource.access$000(AwsIdentityDocUtils.getValueFromAwsIdentityDocument("instanceId"), "");
        private static final String AWS_REGION = (String)MonitoredResource.access$000(AwsIdentityDocUtils.getValueFromAwsIdentityDocument("region"), "");

        @Override
        public ResourceType getResourceType() {
            return ResourceType.AWS_EC2_INSTANCE;
        }

        public abstract String getAccount();

        public abstract String getInstanceId();

        public abstract String getRegion();

        public static AwsEc2InstanceMonitoredResource create(String account, String instanceId, String region) {
            return new AutoValue_MonitoredResource_AwsEc2InstanceMonitoredResource(account, instanceId, region);
        }

        static AwsEc2InstanceMonitoredResource create() {
            return AwsEc2InstanceMonitoredResource.create(AWS_ACCOUNT, AWS_INSTANCE_ID, AWS_REGION);
        }
    }
}

