/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.zipkin;

import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.zipkin.ZipkinExporterConfiguration;
import javax.annotation.Nullable;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.Sender;

final class AutoValue_ZipkinExporterConfiguration
extends ZipkinExporterConfiguration {
    private final String serviceName;
    private final String v2Url;
    private final Sender sender;
    private final SpanBytesEncoder encoder;
    private final Duration deadline;

    private AutoValue_ZipkinExporterConfiguration(String serviceName, String v2Url, @Nullable Sender sender, SpanBytesEncoder encoder, Duration deadline) {
        this.serviceName = serviceName;
        this.v2Url = v2Url;
        this.sender = sender;
        this.encoder = encoder;
        this.deadline = deadline;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getV2Url() {
        return this.v2Url;
    }

    @Override
    @Nullable
    public Sender getSender() {
        return this.sender;
    }

    @Override
    public SpanBytesEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    public Duration getDeadline() {
        return this.deadline;
    }

    public String toString() {
        return "ZipkinExporterConfiguration{serviceName=" + this.serviceName + ", v2Url=" + this.v2Url + ", sender=" + this.sender + ", encoder=" + this.encoder + ", deadline=" + this.deadline + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ZipkinExporterConfiguration) {
            ZipkinExporterConfiguration that = (ZipkinExporterConfiguration)o;
            return this.serviceName.equals(that.getServiceName()) && this.v2Url.equals(that.getV2Url()) && (this.sender == null ? that.getSender() == null : this.sender.equals(that.getSender())) && this.encoder.equals((Object)that.getEncoder()) && this.deadline.equals(that.getDeadline());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.serviceName.hashCode();
        h *= 1000003;
        h ^= this.v2Url.hashCode();
        h *= 1000003;
        h ^= this.sender == null ? 0 : this.sender.hashCode();
        h *= 1000003;
        h ^= this.encoder.hashCode();
        h *= 1000003;
        return h ^= this.deadline.hashCode();
    }

    static final class Builder
    extends ZipkinExporterConfiguration.Builder {
        private String serviceName;
        private String v2Url;
        private Sender sender;
        private SpanBytesEncoder encoder;
        private Duration deadline;

        Builder() {
        }

        @Override
        public ZipkinExporterConfiguration.Builder setServiceName(String serviceName) {
            if (serviceName == null) {
                throw new NullPointerException("Null serviceName");
            }
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public ZipkinExporterConfiguration.Builder setV2Url(String v2Url) {
            if (v2Url == null) {
                throw new NullPointerException("Null v2Url");
            }
            this.v2Url = v2Url;
            return this;
        }

        @Override
        String getV2Url() {
            if (this.v2Url == null) {
                throw new IllegalStateException("Property \"v2Url\" has not been set");
            }
            return this.v2Url;
        }

        @Override
        public ZipkinExporterConfiguration.Builder setSender(@Nullable Sender sender) {
            this.sender = sender;
            return this;
        }

        @Override
        @Nullable
        Sender getSender() {
            return this.sender;
        }

        @Override
        public ZipkinExporterConfiguration.Builder setEncoder(SpanBytesEncoder encoder) {
            if (encoder == null) {
                throw new NullPointerException("Null encoder");
            }
            this.encoder = encoder;
            return this;
        }

        @Override
        public ZipkinExporterConfiguration.Builder setDeadline(Duration deadline) {
            if (deadline == null) {
                throw new NullPointerException("Null deadline");
            }
            this.deadline = deadline;
            return this;
        }

        @Override
        Duration getDeadline() {
            if (this.deadline == null) {
                throw new IllegalStateException("Property \"deadline\" has not been set");
            }
            return this.deadline;
        }

        @Override
        ZipkinExporterConfiguration autoBuild() {
            String missing = "";
            if (this.serviceName == null) {
                missing = missing + " serviceName";
            }
            if (this.v2Url == null) {
                missing = missing + " v2Url";
            }
            if (this.encoder == null) {
                missing = missing + " encoder";
            }
            if (this.deadline == null) {
                missing = missing + " deadline";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ZipkinExporterConfiguration(this.serviceName, this.v2Url, this.sender, this.encoder, this.deadline);
        }
    }
}

