/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.equinox.metatype.EquinoxMetaTypeInformation;
import org.eclipse.equinox.metatype.impl.LogTracker;
import org.eclipse.equinox.metatype.impl.MetaTypeProviderImpl;
import org.eclipse.equinox.metatype.impl.ObjectClassDefinitionImpl;
import org.eclipse.equinox.metatype.impl.Persistence;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MetaTypeInformationImpl
extends MetaTypeProviderImpl
implements EquinoxMetaTypeInformation {
    static final String[] emptyStringArray = new String[0];

    MetaTypeInformationImpl(Bundle bundle, SAXParser parser, LogTracker logger) {
        super(bundle, parser, logger);
    }

    public MetaTypeInformationImpl(Bundle bundle, LogTracker logger, Map<String, ObjectClassDefinitionImpl> pidOCDs, Map<String, ObjectClassDefinitionImpl> fPidOCDs) {
        super(bundle, logger, pidOCDs, fPidOCDs);
    }

    @Override
    public String[] getPids() {
        if (this._allPidOCDs.isEmpty()) {
            return emptyStringArray;
        }
        return this._allPidOCDs.keySet().toArray(emptyStringArray);
    }

    @Override
    public String[] getFactoryPids() {
        if (this._allFPidOCDs.isEmpty()) {
            return emptyStringArray;
        }
        return this._allFPidOCDs.keySet().toArray(emptyStringArray);
    }

    @Override
    public Bundle getBundle() {
        return this._bundle;
    }

    static MetaTypeInformationImpl load(BundleContext systemContext, LogTracker log, Persistence.Reader reader) throws IOException {
        long lastModified;
        long id = reader.readLong();
        Bundle b = systemContext.getBundle(id);
        boolean valid = true;
        if (b == null) {
            valid = false;
            b = systemContext.getBundle("System Bundle");
        }
        if ((lastModified = reader.readLong()) != b.getLastModified()) {
            valid = false;
        }
        HashMap<String, ObjectClassDefinitionImpl> allPidOCDs = new HashMap<String, ObjectClassDefinitionImpl>();
        int numPidOCDs = reader.readInt();
        int i = 0;
        while (i < numPidOCDs) {
            String key = reader.readString();
            ObjectClassDefinitionImpl ocd = ObjectClassDefinitionImpl.load(b, log, reader);
            allPidOCDs.put(key, ocd);
            ++i;
        }
        HashMap<String, ObjectClassDefinitionImpl> allFPidOCDs = new HashMap<String, ObjectClassDefinitionImpl>();
        int numFPidOCDs = reader.readInt();
        int i2 = 0;
        while (i2 < numFPidOCDs) {
            String key = reader.readString();
            ObjectClassDefinitionImpl ocd = ObjectClassDefinitionImpl.load(b, log, reader);
            allFPidOCDs.put(key, ocd);
            ++i2;
        }
        return !valid ? null : new MetaTypeInformationImpl(b, log, allPidOCDs, allFPidOCDs);
    }

    void write(Persistence.Writer writer) throws IOException {
        writer.writeLong(this.getBundle().getBundleId());
        writer.writeLong(this.getBundle().getLastModified());
        writer.writeInt(this._allPidOCDs.size());
        for (Map.Entry entry : this._allPidOCDs.entrySet()) {
            writer.writeString((String)entry.getKey());
            ((ObjectClassDefinitionImpl)entry.getValue()).write(writer);
        }
        writer.writeInt(this._allFPidOCDs.size());
        for (Map.Entry entry : this._allFPidOCDs.entrySet()) {
            writer.writeString((String)entry.getKey());
            ((ObjectClassDefinitionImpl)entry.getValue()).write(writer);
        }
    }
}

