/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.ws.logging.collector.BurstDateFormat;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.AuditData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.JSONObject;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import com.ibm.ws.logging.data.Pair;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class CollectorJsonHelpers {
    private static String startMessageJsonFields = null;
    private static String startAccessLogJsonFields = null;
    private static String startTraceJsonFields = null;
    private static String startFFDCJsonFields = null;
    private static String startAuditJsonFields = null;
    private static String startMessageLogstashCollector = null;
    private static String startAccessLogLogstashCollector = null;
    private static String startTraceLogstashCollector = null;
    private static String startFFDCLogstashCollector = null;
    private static String startAuditLogstashCollector = null;
    private static String startGCLogstashCollector = null;
    public static String hostName = null;
    public static String wlpUserDir = null;
    public static String serverName = null;
    public static final String TRUE_BOOL = "true";
    public static final String FALSE_BOOL = "false";
    public static final String INT_SUFFIX = "_int";
    public static final String FLOAT_SUFFIX = "_float";
    public static final String BOOL_SUFFIX = "_bool";
    public static final String LONG_SUFFIX = "_long";
    public static final String LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    public static final String OMIT_FIELDS_STRING = "@@@OMIT@@@";
    private static final int JSON_KEY = 0;
    private static final int LOGSTASH_KEY = 1;
    public static ThreadLocal<BurstDateFormat> dateFormatTL = new ThreadLocal<BurstDateFormat>(){

        @Override
        protected BurstDateFormat initialValue() {
            return new BurstDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        }
    };

    public static void setHostName(String host) {
        hostName = host;
    }

    public static void setWlpUserDir(String userDir) {
        wlpUserDir = userDir;
    }

    public static void setServerName(String server) {
        serverName = server;
    }

    protected static String getEventType(String source, String location) {
        if (source.equals("com.ibm.ws.health.center.source.gcsource") && location.equals("memory")) {
            return "liberty_gc";
        }
        if (source.equals("com.ibm.ws.logging.source.message") && location.equals("memory")) {
            return "liberty_message";
        }
        if (source.endsWith("com.ibm.ws.logging.source.trace") && location.equals("memory")) {
            return "liberty_trace";
        }
        if (source.endsWith("com.ibm.ws.logging.ffdc.source.ffdcsource") && location.equals("memory")) {
            return "liberty_ffdc";
        }
        if (source.endsWith("com.ibm.ws.http.logging.source.accesslog") && location.equals("memory")) {
            return "liberty_accesslog";
        }
        if (source.contains("audit")) {
            return "liberty_audit";
        }
        return "";
    }

    protected static boolean addToJSON(StringBuilder sb, String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue, boolean trim, boolean isFirstField) {
        boolean b = CollectorJsonHelpers.addToJSON(sb, name, value, jsonEscapeName, jsonEscapeValue, trim, isFirstField, false);
        return b;
    }

    protected static boolean addToJSON(StringBuilder sb, String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue, boolean trim, boolean isFirstField, boolean isQuoteless) {
        if (name == null || value == null) {
            return false;
        }
        if (name.equals(OMIT_FIELDS_STRING)) {
            return false;
        }
        if (!isFirstField) {
            sb.append(",");
        }
        if (trim) {
            value = value.trim();
        }
        sb.append("\"");
        if (jsonEscapeName) {
            CollectorJsonHelpers.jsonEscape3(sb, name);
        } else {
            sb.append(name);
        }
        if (isQuoteless) {
            sb.append("\":");
            if (jsonEscapeValue) {
                CollectorJsonHelpers.jsonEscape3(sb, value);
            } else {
                sb.append(value);
            }
        } else {
            sb.append("\":\"");
            if (jsonEscapeValue) {
                CollectorJsonHelpers.jsonEscape3(sb, value);
            } else {
                sb.append(value);
            }
            sb.append("\"");
        }
        return true;
    }

    protected static void jsonEscape3(StringBuilder sb, String s) {
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append("\\");
                    sb.append(c);
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    public static void updateFieldMappings() {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        for (int i = 0; i < 2; ++i) {
            jsonBuilder = new JSONObject.JSONObjectBuilder();
            jsonBuilder.addField(AuditData.getTypeKey(i), "liberty_audit", false, false).addField(AuditData.getHostKey(i), hostName, false, false).addField(AuditData.getUserDirKey(i), wlpUserDir, false, true).addField(AuditData.getServerNameKey(i), serverName, false, false);
            if (i == 0) {
                startAuditJsonFields = jsonBuilder.toString();
            } else if (i == 1) {
                startAuditLogstashCollector = jsonBuilder.toString();
            }
            jsonBuilder = new JSONObject.JSONObjectBuilder();
            jsonBuilder.addField(LogTraceData.getTypeKey(i, true), "liberty_message", false, false).addField(LogTraceData.getHostKey(i, true), hostName, false, false).addField(LogTraceData.getUserDirKey(i, true), wlpUserDir, false, true).addField(LogTraceData.getServerNameKey(i, true), serverName, false, false);
            if (i == 0) {
                startMessageJsonFields = jsonBuilder.toString();
            } else if (i == 1) {
                startMessageLogstashCollector = jsonBuilder.toString();
            }
            jsonBuilder = new JSONObject.JSONObjectBuilder();
            jsonBuilder.addField(LogTraceData.getTypeKey(i, false), "liberty_trace", false, false).addField(LogTraceData.getHostKey(i, false), hostName, false, false).addField(LogTraceData.getUserDirKey(i, false), wlpUserDir, false, true).addField(LogTraceData.getServerNameKey(i, false), serverName, false, false);
            if (i == 0) {
                startTraceJsonFields = jsonBuilder.toString();
            } else if (i == 1) {
                startTraceLogstashCollector = jsonBuilder.toString();
            }
            jsonBuilder = new JSONObject.JSONObjectBuilder();
            jsonBuilder.addField(AccessLogData.getTypeKey(i), "liberty_accesslog", false, false).addField(AccessLogData.getHostKey(i), hostName, false, false).addField(AccessLogData.getUserDirKey(i), wlpUserDir, false, true).addField(AccessLogData.getServerNameKey(i), serverName, false, false);
            if (i == 0) {
                startAccessLogJsonFields = jsonBuilder.toString();
            } else if (i == 1) {
                startAccessLogLogstashCollector = jsonBuilder.toString();
            }
            jsonBuilder = new JSONObject.JSONObjectBuilder();
            jsonBuilder.addField(FFDCData.getTypeKey(i), "liberty_ffdc", false, false).addField(FFDCData.getHostKey(i), hostName, false, false).addField(FFDCData.getUserDirKey(i), wlpUserDir, false, true).addField(FFDCData.getServerNameKey(i), serverName, false, false);
            if (i == 0) {
                startFFDCJsonFields = jsonBuilder.toString();
                continue;
            }
            if (i != 1) continue;
            startFFDCLogstashCollector = jsonBuilder.toString();
        }
        jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addField("type", "liberty_gc", false, false).addField("hostName", hostName, false, false).addField("wlpUserDir", wlpUserDir, false, true).addField("serverName", serverName, false, false);
        startGCLogstashCollector = jsonBuilder.toString();
    }

    protected static JSONObject.JSONObjectBuilder startGC() {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addPreformatted(startGCLogstashCollector);
        return jsonBuilder;
    }

    protected static JSONObject.JSONObjectBuilder startAudit(int format) {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        if (format == 0) {
            jsonBuilder.addPreformatted(startAuditJsonFields);
        } else if (format == 1) {
            jsonBuilder.addPreformatted(startAuditLogstashCollector);
        }
        return jsonBuilder;
    }

    protected static JSONObject.JSONObjectBuilder startMessage(int format) {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        if (format == 0) {
            jsonBuilder.addPreformatted(startMessageJsonFields);
        } else if (format == 1) {
            jsonBuilder.addPreformatted(startMessageLogstashCollector);
        }
        return jsonBuilder;
    }

    protected static JSONObject.JSONObjectBuilder startTrace(int format) {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        if (format == 0) {
            jsonBuilder.addPreformatted(startTraceJsonFields);
        } else if (format == 1) {
            jsonBuilder.addPreformatted(startTraceLogstashCollector);
        }
        return jsonBuilder;
    }

    protected static JSONObject.JSONObjectBuilder startFFDC(int format) {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        if (format == 0) {
            jsonBuilder.addPreformatted(startFFDCJsonFields);
        } else if (format == 1) {
            jsonBuilder.addPreformatted(startFFDCLogstashCollector);
        }
        return jsonBuilder;
    }

    protected static JSONObject.JSONObjectBuilder startAccessLog(int format) {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        if (format == 0) {
            jsonBuilder.addPreformatted(startAccessLogJsonFields);
        } else if (format == 1) {
            jsonBuilder.addPreformatted(startAccessLogLogstashCollector);
        }
        return jsonBuilder;
    }

    protected static String formatMessage(String message, int maxLength) {
        return message.length() > maxLength && maxLength > 0 ? message.substring(0, maxLength) + "..." : message;
    }

    protected static String removeIBMTag(String s) {
        s = s.replace("ibm_", "");
        return s;
    }

    protected static StringBuilder addTagNameForVersion(StringBuilder sb) {
        sb.append(",\"tags\":");
        return sb;
    }

    protected static String jsonifyTags(String[] tags) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[");
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tags[i].trim();
            if (tags[i].contains(" ") || tags[i].contains("-")) continue;
            sb.append("\"");
            CollectorJsonHelpers.jsonEscape3(sb, tags[i]);
            sb.append("\"");
            if (i == tags.length - 1) continue;
            sb.append(",");
        }
        if (sb.toString().lastIndexOf(",") == sb.toString().length() - 1) {
            sb.delete(sb.toString().lastIndexOf(","), sb.toString().lastIndexOf(",") + 1);
        }
        sb.append("]");
        return sb.toString();
    }

    protected static String jsonRemoveSpace(String s) {
        StringBuilder sb = new StringBuilder();
        boolean isLine = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                sb.append(c);
                isLine = true;
                continue;
            }
            if (c == ' ' && isLine) continue;
            if (isLine && c != ' ') {
                isLine = false;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected static String getLogLevel(ArrayList<Pair> pairs) {
        KeyValuePair kvp = null;
        String loglevel = null;
        for (Pair p : pairs) {
            if (!(p instanceof KeyValuePair) || !(kvp = (KeyValuePair)((Object)p)).getKey().equals("loglevel")) continue;
            loglevel = kvp.getStringValue();
            break;
        }
        return loglevel;
    }

    public static void handleExtensions(KeyValuePairList extensions, String extKey, String extValue) {
        extKey = "ext_" + extKey;
        if (extKey.indexOf(95, 4) != -1) {
            if (extKey.endsWith(INT_SUFFIX)) {
                try {
                    extensions.addKeyValuePair(extKey, Integer.parseInt(extValue));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (extKey.endsWith(FLOAT_SUFFIX)) {
                try {
                    extensions.addKeyValuePair(extKey, Float.parseFloat(extValue));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (extKey.endsWith(BOOL_SUFFIX)) {
                if (extValue.toLowerCase().trim().equals(TRUE_BOOL)) {
                    extensions.addKeyValuePair(extKey, true);
                } else if (extValue.toLowerCase().trim().equals(FALSE_BOOL)) {
                    extensions.addKeyValuePair(extKey, false);
                }
            } else if (extKey.endsWith(LONG_SUFFIX)) {
                try {
                    extensions.addKeyValuePair(extKey, Long.parseLong(extValue));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                extensions.addKeyValuePair(extKey, extValue);
            }
        } else {
            extensions.addKeyValuePair(extKey, extValue);
        }
    }
}

