/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.feature.internal.FeatureManager;
import com.ibm.ws.kernel.feature.internal.subsystem.KernelFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.provisioning.packages.PackageIndex;
import com.ibm.ws.kernel.provisioning.packages.SharedPackageInspector;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PackageInspectorImpl
implements SharedPackageInspector,
Introspector {
    private static final TraceComponent tc = Tr.register(PackageInspectorImpl.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    private ServiceRegistration<?> registration = null;
    private volatile ProductPackages packageIndex = null;
    static final long serialVersionUID = -5575384688725981944L;

    void activate(BundleContext bundleContext) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.vendor", "IBM");
        this.registration = bundleContext.registerService(new String[]{SharedPackageInspector.class.getName(), Introspector.class.getName()}, (Object)this, props);
    }

    void deactivate() {
        this.registration.unregister();
    }

    final void populateSPIInfo(BundleContext bundleContext, FeatureManager fm) {
        if (bundleContext != null) {
            ProductPackages newPackageIndex = new ProductPackages();
            Collection<ProvisioningFeatureDefinition> allInstalledFeatures = fm.getInstalledFeatureDefinitions();
            allInstalledFeatures.addAll(KernelFeatureDefinitionImpl.getKernelFeatures(bundleContext, fm.getLocationService()));
            for (ProvisioningFeatureDefinition def : allInstalledFeatures) {
                newPackageIndex.addPackages(def);
            }
            newPackageIndex.compact();
            this.packageIndex = newPackageIndex;
        }
    }

    public Iterator<String> listApiPackages() {
        ProductPackages index = this.packageIndex;
        if (index != null) {
            return index.packageIterator((PackageIndex.Filter)new PackageIndex.Filter<PackageInfo>(){
                static final long serialVersionUID = 958725680908001120L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public boolean includeValue(String packageName, PackageInfo value) {
                    return value.isApi();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.PackageInspectorImpl$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
                }
            });
        }
        return new EmptyIterator();
    }

    public SharedPackageInspector.PackageType getExportedPackageType(String packageName) {
        ProductPackages index = this.packageIndex;
        if (index != null) {
            return (SharedPackageInspector.PackageType)index.find(packageName);
        }
        return null;
    }

    public String getIntrospectorName() {
        return "SharedPackages";
    }

    public String getIntrospectorDescription() {
        return "List of declared API/SPI packages in the runtime";
    }

    public void introspect(PrintWriter ps) throws IOException {
        ProductPackages index = this.packageIndex;
        if (index == null) {
            ps.println("Product packages = null");
        } else {
            ps.println("Product packages: ");
            ps.println(index.dump());
        }
        ps.flush();
    }

    public Iterator<String> getExtensionPackages(final String productName) {
        ProductPackages index = this.packageIndex;
        if (index == null) {
            return Collections.emptyList().iterator();
        }
        return index.packageIterator((PackageIndex.Filter)new PackageIndex.Filter<PackageInfo>(){
            static final long serialVersionUID = 3035283594274270652L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public boolean includeValue(String packageName, PackageInfo value) {
                return value.exportedByProduct(productName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.PackageInspectorImpl$2", 2.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    public Iterator<String> getGatewayPackages(final String productName) {
        ProductPackages index = this.packageIndex;
        if (index == null) {
            return Collections.emptyList().iterator();
        }
        return index.packageIterator((PackageIndex.Filter)new PackageIndex.Filter<PackageInfo>(){
            static final long serialVersionUID = 7651543027501129856L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public boolean includeValue(String packageName, PackageInfo value) {
                return value.isApi() && value.exportedByProduct(productName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.PackageInspectorImpl$3", 3.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    public Iterator<String> listKernelBlockedApiPackages() {
        ProductPackages index = this.packageIndex;
        if (index != null) {
            return index.packageIterator((PackageIndex.Filter)new PackageIndex.Filter<PackageInfo>(){
                static final long serialVersionUID = 4099524407415344550L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public boolean includeValue(String packageName, PackageInfo value) {
                    return value.isApi() && value.isKernelExportBlockedPackage();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.PackageInspectorImpl$4", 4.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
                }
            });
        }
        return new EmptyIterator();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class EmptyIterator
    implements Iterator<String> {
        static final long serialVersionUID = -6161999785109406997L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.PackageInspectorImpl$EmptyIterator", EmptyIterator.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class ProductPackages
    extends PackageIndex<PackageInfo> {
        static final long serialVersionUID = 159714834825646918L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ProductPackages() {
        }

        public void addPackages(ProvisioningFeatureDefinition def) {
            this.addPackages(def, "IBM-API-Package", PkgType.API);
            this.addPackages(def, "IBM-SPI-Package", PkgType.SPI);
        }

        private void addPackages(ProvisioningFeatureDefinition def, String packageHeader, PkgType defaultPkgType) {
            String packages = def.getHeader(packageHeader);
            if (packages != null && !packages.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"feature {0} added {1} packages to product {2}: {3}", (Object[])new Object[]{def.getFeatureName(), defaultPkgType, def.getBundleRepositoryType(), packages});
                }
                for (ManifestHeaderProcessor.NameValuePair nvp : ManifestHeaderProcessor.parseExportString((String)packages)) {
                    String packageName = nvp.getName();
                    String type = (String)nvp.getAttributes().get("type");
                    String requireOsgiEE = (String)nvp.getAttributes().get("require-java:");
                    if (requireOsgiEE != null && JavaInfo.majorVersion() < Integer.parseInt(requireOsgiEE)) continue;
                    PkgType expType = PkgType.fromString(type, defaultPkgType);
                    if (expType == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"{0} was associated with an unknown type {1}", (Object[])new Object[]{packageName, nvp});
                        continue;
                    }
                    PackageInfo packageInfo = new PackageInfo(expType, def.getBundleRepositoryType(), def.isKernel());
                    if (this.add(packageName, packageInfo)) continue;
                    PackageInfo prevValue = (PackageInfo)this.find(packageName);
                    prevValue.add(expType, def.getBundleRepositoryType(), def.isKernel());
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"{0} was provided by more than one feature, combined attributes are {1}", (Object[])new Object[]{packageName, prevValue});
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.PackageInspectorImpl$ProductPackages", ProductPackages.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class PackageInfo
    implements SharedPackageInspector.PackageType {
        final EnumSet<PkgType> types;
        final ArrayList<String> productRepo;
        private boolean isKernelExport = false;
        private boolean isCoreExport = false;
        private boolean isExtensionExport = false;
        static final long serialVersionUID = 2167570071167020491L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        PackageInfo(PkgType expType, String repo, boolean isKrnlExport) {
            this.types = EnumSet.of(expType);
            this.productRepo = new ArrayList(1);
            this.productRepo.add(repo);
            this.evaluateForFeatureType(repo, isKrnlExport);
        }

        public void add(PkgType anotherType, String repo, boolean isKrnlExport) {
            this.add(anotherType, repo);
            this.evaluateForFeatureType(repo, isKrnlExport);
        }

        private void evaluateForFeatureType(String repo, boolean isKrnlExport) {
            if (isKrnlExport) {
                this.isKernelExport = true;
            }
            if (repo.equals("") && !isKrnlExport) {
                this.isCoreExport = true;
            }
            if (repo.equals("usr") && !isKrnlExport) {
                this.isExtensionExport = true;
            }
        }

        public void add(PkgType anotherType, String repo) {
            this.types.add(anotherType);
            if (!this.productRepo.contains(repo)) {
                this.productRepo.add(repo);
            }
        }

        public boolean exportedByProduct(String repo) {
            return this.productRepo.contains(repo);
        }

        public boolean isApi() {
            for (PkgType type : this.types) {
                if (!type.isApi) continue;
                return true;
            }
            return false;
        }

        public boolean isSpi() {
            for (PkgType type : this.types) {
                if (type.isApi) continue;
                return true;
            }
            return false;
        }

        public boolean isUserDefinedApi() {
            return this.types.contains((Object)PkgType.API);
        }

        public boolean isIbmApi() {
            return this.types.contains((Object)PkgType.API_IBM);
        }

        public boolean isInternalApi() {
            return this.types.contains((Object)PkgType.API_Internal);
        }

        public boolean isSpecApi() {
            return this.types.contains((Object)PkgType.API_Spec) || this.types.contains((Object)PkgType.API_SpecOsgi);
        }

        public boolean isSpecOsgiApi() {
            return this.types.contains((Object)PkgType.API_SpecOsgi);
        }

        public boolean isStrictSpecApi() {
            return this.types.contains((Object)PkgType.API_Spec);
        }

        public boolean isThirdPartyApi() {
            return this.types.contains((Object)PkgType.API_ThirdParty);
        }

        public boolean isStableApi() {
            return this.types.contains((Object)PkgType.API_Stable);
        }

        public boolean isKernelExportBlockedPackage() {
            return this.isKernelExport && this.isCoreExport && !this.isSpecOsgiApi() && !this.isSpi();
        }

        public String toString() {
            return this.types + "|" + this.productRepo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.PackageInspectorImpl$PackageInfo", PackageInfo.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    static enum PkgType {
        API(true, "api"),
        API_IBM(true, "ibm-api"),
        API_Internal(true, "internal"),
        API_Spec(true, "spec"),
        API_SpecOsgi(true, "spec:osgi"),
        API_ThirdParty(true, "third-party"),
        API_Stable(true, "stable"),
        SPI(false, "spi"),
        SPI_Spec(false, "spec"),
        SPI_ThirdParty(false, "third-party");

        private final boolean isApi;
        private final String attributeName;
        static EnumSet<PkgType> API_types;
        static EnumSet<PkgType> SPI_types;

        private PkgType(boolean isApi, String attributeName) {
            this.isApi = isApi;
            this.attributeName = attributeName;
        }

        static PkgType fromString(String value, PkgType defaultType) {
            if (value != null) {
                value = value.trim();
                Set<PkgType> possible = Collections.emptySet();
                if (defaultType == API) {
                    possible = API_types;
                } else if (defaultType == SPI) {
                    possible = SPI_types;
                }
                for (PkgType t : possible) {
                    if (!t.attributeName.equals(value)) continue;
                    return t;
                }
            }
            return defaultType;
        }

        static {
            API_types = EnumSet.noneOf(PkgType.class);
            SPI_types = EnumSet.noneOf(PkgType.class);
            for (PkgType type : PkgType.values()) {
                if (type.isApi) {
                    API_types.add(type);
                    continue;
                }
                SPI_types.add(type);
            }
        }
    }
}

