/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.AbstractDirector;
import com.ibm.ws.install.internal.Engine;
import com.ibm.ws.install.internal.EventManager;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.FeatureDependencyChecker;
import com.ibm.ws.install.internal.FixDependencyChecker;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.Product;
import com.ibm.ws.install.internal.adaptor.ESAAdaptor;
import com.ibm.ws.install.internal.adaptor.FixAdaptor;
import com.ibm.ws.install.internal.asset.UninstallAsset;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.product.utility.extension.ifix.xml.Problem;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UninstallDirector
extends AbstractDirector {
    private final Engine engine;
    private FeatureDependencyChecker dependencyChecker;
    private FixDependencyChecker fixDependencyChecker;
    private static String[] excludePathSuffix = new String[]{"bin", "tools", "installUtility.bat", "ws-installUtility.jar", "featureUtility.bat", "ws-featureUtility.jar", "featureManager.bat", "ws-featureManager.jar"};
    private List<UninstallAsset> uninstallAssets;
    private boolean setScriptsPermission = false;

    public UninstallDirector(Product product, Engine engine, EventManager eventManager, Logger logger) {
        super(product, eventManager, logger);
        this.engine = engine;
    }

    void cleanUp() {
        this.uninstallAssets = null;
    }

    void uninstall(boolean checkDependency, String productId, Collection<File> toBeDeleted) throws InstallException {
        String[] productIds = new String[]{productId};
        this.uninstall(checkDependency, productIds, toBeDeleted);
    }

    void retrieveUninstallFileList(UninstallAsset uninstallAsset, boolean checkDependency) throws InstallException {
        if (uninstallAsset.getType().equals((Object)UninstallAsset.UninstallAssetType.feature) && uninstallAsset.getFeatureFileList().isEmpty()) {
            uninstallAsset.setFeaturePath(ESAAdaptor.getFeaturePath(uninstallAsset.getProvisioningFeatureDefinition(), this.engine.getBaseDir(uninstallAsset.getProvisioningFeatureDefinition())));
            uninstallAsset.setFeatureFileList(ESAAdaptor.determineFilesToBeDeleted(uninstallAsset.getProvisioningFeatureDefinition(), this.product.getFeatureDefinitions(), this.engine.getBaseDir(uninstallAsset.getProvisioningFeatureDefinition()), uninstallAsset.getFeaturePath(), checkDependency, uninstallAsset.getFixUpdatesFeature()));
        }
    }

    void uninstall(boolean checkDependency, String[] productIds, Collection<File> toBeDeleted) throws InstallException {
        if (this.uninstallAssets.isEmpty()) {
            return;
        }
        if (InstallUtils.isWindows) {
            this.fireProgressEvent(16, 10, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING", new Object[0]));
            HashSet<File> baseDirs = new HashSet<File>();
            for (UninstallAsset uninstallAsset : this.uninstallAssets) {
                baseDirs.addAll(this.getAssetBaseDirectories(uninstallAsset, this.engine.getBaseDir(uninstallAsset.getProvisioningFeatureDefinition())));
            }
            HashSet<Path> lockedPaths = new HashSet<Path>();
            for (File baseDir : baseDirs) {
                try {
                    Stream<Path> filesStream = Files.walk(baseDir.toPath(), new FileVisitOption[0]);
                    try {
                        List<Path> allPathsFromBaseDir = filesStream.collect(Collectors.toList());
                        allPathsFromBaseDir = this.removePathExceptions(allPathsFromBaseDir);
                        for (Path path : allPathsFromBaseDir) {
                            try {
                                InstallUtils.isFileLocked("ERROR_UNINSTALL_FEATURE_FILE_LOCKED", path.toString(), path.toFile());
                            }
                            catch (InstallException ie) {
                                lockedPaths.add(path);
                            }
                        }
                    }
                    finally {
                        if (filesStream == null) continue;
                        filesStream.close();
                    }
                }
                catch (IOException e) {
                    throw ExceptionUtils.create(e);
                }
            }
            if (!lockedPaths.isEmpty()) {
                this.logger.log(Level.SEVERE, "Uninstall found the following files are locked: {0}", Arrays.toString(lockedPaths.toArray()));
                for (Path path : lockedPaths) {
                    InstallUtils.isFileLocked("ERROR_UNINSTALL_FEATURE_FILE_LOCKED", path.toString(), path.toFile());
                }
            }
        }
        int progress = 20;
        int interval = 70 / this.uninstallAssets.size();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (UninstallAsset uninstallAsset : this.uninstallAssets) {
            this.fireProgressEvent(128, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_UNINSTALLING", uninstallAsset.getName()));
            progress += interval;
            try {
                this.retrieveUninstallFileList(uninstallAsset, checkDependency);
                this.engine.uninstall(uninstallAsset, checkDependency, arrayList);
                this.log(Level.FINE, uninstallAsset.uninstalledLogMsg());
            }
            catch (IOException e) {
                throw ExceptionUtils.create(e);
            }
            catch (Exception e) {
                String errorMsg = uninstallAsset.getType().equals((Object)UninstallAsset.UninstallAssetType.feature) ? InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNINSTALL_FEATURE_INVALID_META_DATA", uninstallAsset.getName()) : InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNINSTALL_FIX_INVALID_META_DATA", uninstallAsset.getName());
                throw ExceptionUtils.create(errorMsg, e);
            }
        }
        this.checkSetScriptsPermission(arrayList);
        if (toBeDeleted != null) {
            for (File f : toBeDeleted) {
                if (f.isFile()) {
                    InstallUtils.delete(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                InstallUtils.deleteDirectory(f);
            }
        }
    }

    public List<Path> removePathExceptions(List<Path> allPathsFromBaseDir) {
        ArrayList<Path> exceptionsRemoved = new ArrayList<Path>();
        List<String> excludes = Arrays.asList(excludePathSuffix);
        for (Path path : allPathsFromBaseDir) {
            if (excludes.stream().anyMatch(p -> path.toString().endsWith((String)p))) continue;
            exceptionsRemoved.add(path);
        }
        return exceptionsRemoved;
    }

    protected Set<File> getAssetBaseDirectories(UninstallAsset uninstallAsset, File baseDir) throws InstallException {
        HashSet<File> baseDirs = new HashSet<File>();
        Set<String> assetLocations = this.getAssetLocations(uninstallAsset);
        for (String assetLocation : assetLocations) {
            List<String> subDirs = this.getFirstChildSubdirectoryFromLocations(assetLocation);
            for (String subDir : subDirs) {
                File base = new File(baseDir + File.separator + subDir);
                if (!base.exists()) continue;
                baseDirs.add(base);
            }
        }
        return baseDirs;
    }

    public Set<String> getAssetLocations(UninstallAsset uninstallAsset) {
        List<SubsystemContentType> resourceFilter = Arrays.asList(SubsystemContentType.BUNDLE_TYPE, SubsystemContentType.JAR_TYPE, SubsystemContentType.BOOT_JAR_TYPE, SubsystemContentType.FILE_TYPE);
        return uninstallAsset.getProvisioningFeatureDefinition().getConstituents(null).stream().filter(s -> resourceFilter.contains(s.getType()) && s.getLocation() != null).map(s -> s.getLocation()).collect(Collectors.toSet());
    }

    public List<String> getFirstChildSubdirectoryFromLocations(String locString) {
        ArrayList<String> subdirectories = new ArrayList<String>();
        if (locString != null && !locString.isEmpty()) {
            String[] locs;
            String[] stringArray;
            if (locString.contains(",")) {
                stringArray = locString.split(",");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = locString;
            }
            for (String loc : locs = stringArray) {
                int index;
                File fle = new File(loc);
                String fileStr = fle.toString();
                if (fileStr.charAt(0) == File.separatorChar) {
                    fileStr = fileStr.substring(1);
                }
                if ((index = fileStr.indexOf(File.separator)) > 0) {
                    fileStr = fileStr.substring(0, fileStr.indexOf(File.separator));
                }
                subdirectories.add(fileStr);
            }
        }
        return subdirectories;
    }

    void uninstall(Collection<String> ids, boolean force) throws InstallException {
        Collection<ProvisioningFeatureDefinition> installedFeatureDefinitions = this.product.getAllFeatureDefinitions().values();
        ArrayList<String> featureNames = new ArrayList<String>();
        featureNames.addAll(ids);
        Collection<String> installFeatureRequiredFeatures = this.getInstallFeatureRequiredFeatures(ids);
        if (!installFeatureRequiredFeatures.isEmpty()) {
            for (String featureName : featureNames) {
                ProvisioningFeatureDefinition pd = this.getProvisioningFeatureDefinition(installedFeatureDefinitions, featureName);
                if (!installFeatureRequiredFeatures.contains(pd.getSymbolicName())) continue;
                installFeatureRequiredFeatures.remove(pd.getSymbolicName());
            }
        }
        featureNames.addAll(installFeatureRequiredFeatures);
        this.uninstallFeatures(featureNames, this.getInstallFeatures(ids), force);
        this.uninstall(true, (String)null, null);
        this.uninstallInternalAndAutoFeatures(featureNames, installedFeatureDefinitions, null);
        this.uninstall(true, (String)null, null);
    }

    void uninstallFeatures(Collection<String> featureNames, Collection<String> uninstallInstallFeatures, boolean force) {
        this.product.refresh();
        Collection<ProvisioningFeatureDefinition> installedFeatureDefinitions = this.product.getAllFeatureDefinitions().values();
        Collection<ProvisioningFeatureDefinition> uninstallFeatures = this.getProvisioningFeatureDefinition(installedFeatureDefinitions, featureNames);
        this.uninstallAssets = new ArrayList<UninstallAsset>();
        for (ProvisioningFeatureDefinition uninstallFeature : uninstallFeatures) {
            if (this.contains(uninstallFeature)) continue;
            this.log(Level.FINEST, "Feature is going to be uninstalled : " + uninstallFeature.getSymbolicName());
            this.uninstallAssets.add(new UninstallAsset(uninstallFeature));
        }
        Map<UninstallAsset, String> nonUninstallableAssets = this.getNotUninstallableAssets(this.uninstallAssets, installedFeatureDefinitions, uninstallInstallFeatures, false);
        if (!force) {
            this.uninstallAssets = this.removeUninstallableAssets(this.uninstallAssets, nonUninstallableAssets.keySet());
        }
        this.dependencyChecker = new FeatureDependencyChecker();
        this.uninstallAssets = this.dependencyChecker.determineOrder(this.uninstallAssets);
    }

    boolean contains(ProvisioningFeatureDefinition pfd) {
        for (UninstallAsset ua : this.uninstallAssets) {
            ProvisioningFeatureDefinition uaPfd = ua.getProvisioningFeatureDefinition();
            if (uaPfd == null || !uaPfd.getSymbolicName().equals(pfd.getSymbolicName())) continue;
            return true;
        }
        return false;
    }

    void uninstallFeaturesByProductId(String productId, boolean exceptPlatfromFeatuers) throws InstallException {
        String[] productIds = new String[]{productId};
        this.uninstallFeaturesByProductId(productIds, exceptPlatfromFeatuers);
    }

    void uninstallFeaturesByProductId(String[] productIds, boolean exceptPlatfromFeatuers) throws InstallException {
        this.fireProgressEvent(16, 1, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING", new Object[0]));
        Map<String, ProvisioningFeatureDefinition> installedFeatures = exceptPlatfromFeatuers ? this.product.getAllCoreFeatureDefinitionsExceptPlatform() : this.product.getAllCoreFeatureDefinitions();
        this.uninstallAssets = new ArrayList<UninstallAsset>();
        for (ProvisioningFeatureDefinition targetPd : installedFeatures.values()) {
            String pid = targetPd.getHeader("IBM-ProductID");
            if (pid == null) continue;
            for (String productId : productIds) {
                if (!pid.equals(productId)) continue;
                this.uninstallAssets.add(new UninstallAsset(targetPd));
            }
        }
    }

    void uninstallFeaturesPrereqChecking(Collection<String> featureNames, boolean allowUninstallAll, boolean force) throws InstallException {
        Collection<String> usrFeatures;
        if (!allowUninstallAll && !(usrFeatures = this.getUsrFeatures(featureNames)).isEmpty()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNINSTALL_FAILED_USR", usrFeatures.toArray()));
        }
        Collection<ProvisioningFeatureDefinition> installedFeatureDefinitions = this.product.getAllFeatureDefinitions().values();
        Collection<String> featuresWithUnfoundExtension = this.getFeaturesWithUnfoundExtension(featureNames);
        if (!featuresWithUnfoundExtension.isEmpty()) {
            String featureName = featuresWithUnfoundExtension.iterator().next();
            String[] extFeature = featureName.split(":");
            String ext = extFeature[0];
            String feaName = extFeature[1];
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_EXTENSION_NOT_FOUND", feaName, ext));
        }
        Collection<String> unfoundUserFeaturesUnderGivenExtension = this.getUnfoundUserFeatures(installedFeatureDefinitions, featureNames);
        if (!unfoundUserFeaturesUnderGivenExtension.isEmpty()) {
            String featureName = unfoundUserFeaturesUnderGivenExtension.iterator().next();
            String[] extFeature = featureName.split(":");
            String ext = extFeature[0];
            String feaName = extFeature[1];
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FEATURE_NOT_FOUND_IN_EXTENSION", feaName, ext));
        }
        Collection<String> notInstalledFeatures = this.getNotInstalledFeatures(installedFeatureDefinitions, featureNames);
        if (!notInstalledFeatures.isEmpty()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FEATURE_NOT_INSTALLED", notInstalledFeatures.toArray()));
        }
        ArrayList<UninstallAsset> uninstallAssets = new ArrayList<UninstallAsset>();
        Collection<ProvisioningFeatureDefinition> uninstallFeatures = this.getProvisioningFeatureDefinition(installedFeatureDefinitions, featureNames);
        this.log(Level.FINE, InstallUtils.NEWLINE + InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_PENDING_UNINSTALLING_FEATURE", new Object[0]));
        for (ProvisioningFeatureDefinition uninstallFeature : uninstallFeatures) {
            UninstallAsset ua = new UninstallAsset(uninstallFeature);
            uninstallAssets.add(ua);
            this.log(Level.FINE, ua.getDisplayName());
        }
        this.log(Level.FINE, InstallUtils.NEWLINE);
        Map<UninstallAsset, String> notUninstallableFeatures = this.getNotUninstallableAssets(uninstallAssets, installedFeatureDefinitions, null, true);
        if (!notUninstallableFeatures.isEmpty()) {
            StringBuffer message = new StringBuffer();
            Collection<String> installFeatureRequiredFeatures = this.getInstallFeatureRequiredFeatures(featureNames);
            boolean throwException = false;
            for (Map.Entry<UninstallAsset, String> entries : notUninstallableFeatures.entrySet()) {
                if (!force && !installFeatureRequiredFeatures.contains(entries.getKey().getProvisioningFeatureDefinition().getSymbolicName())) {
                    throwException = true;
                }
                message.append(entries.getValue());
            }
            if (force) {
                message.insert(0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_UNINSTALL_FEATURE_DEPENDENCIES", new Object[0]) + InstallUtils.NEWLINE);
                message.append(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_UNINSTALL_FEATURE_DEPENDENCIES_EXPLANATION", new Object[0]) + InstallUtils.NEWLINE);
            } else {
                message.insert(0, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNINSTALL_DEPENDENCY_CHECKING_FAILED", new Object[0]));
                message.append(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNINSTALL_DEPENDENCY_CHECKING_FAILED_ACTION", new Object[0]));
            }
            if (throwException) {
                throw new InstallException(message.toString());
            }
            if (force) {
                this.log(Level.INFO, message.toString());
            } else {
                this.log(Level.FINEST, message.toString());
            }
        }
    }

    void uninstallFix(Collection<String> fixNames) throws InstallException {
        this.fireProgressEvent(16, 1, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING_FIXES", new Object[0]));
        Set<IFixInfo> fixInfoSet = FixAdaptor.getInstalledIFixes(this.product.getInstallDir());
        this.uninstallAssets = new ArrayList<UninstallAsset>();
        for (String fix : fixNames) {
            IFixInfo targetFix = null;
            for (IFixInfo fixInfo : fixInfoSet) {
                if (!fixInfo.getId().equals(fix)) continue;
                targetFix = fixInfo;
                break;
            }
            if (targetFix == null) {
                throw ExceptionUtils.createByKey("ERROR_IFIX_NOT_INSTALLED", fix);
            }
            this.uninstallAssets.add(new UninstallAsset(targetFix));
        }
        this.fixDependencyChecker = new FixDependencyChecker();
        for (UninstallAsset uninstallAsset : this.uninstallAssets) {
            if (!this.fixDependencyChecker.isUninstallable(uninstallAsset, fixInfoSet, this.uninstallAssets)) {
                throw ExceptionUtils.createByKey("ERROR_IFIX_UNINSTALLABLE", uninstallAsset.getIFixInfo().getId());
            }
            for (Problem problem : uninstallAsset.getIFixInfo().getResolves().getProblems()) {
                ArrayList<String> dependency = FixDependencyChecker.fixRequiredByFeature(problem.getDisplayId(), this.product.getFeatureDefinitions());
                if (dependency == null) continue;
                this.log(Level.FINE, "Dependent features:");
                for (String f : dependency) {
                    this.log(Level.FINE, f);
                }
                throw ExceptionUtils.createByKey("ERROR_IFIX_UNINSTALLABLE_REQUIRED_BY_FEATURE", uninstallAsset.getIFixInfo().getId(), dependency.get(0));
            }
        }
        this.uninstallAssets = this.fixDependencyChecker.determineOrder(this.uninstallAssets);
    }

    void uninstallFix(String fixId) throws InstallException {
        this.fireProgressEvent(16, 1, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CHECKING_FIXES", new Object[0]));
        this.uninstallAssets = new ArrayList<UninstallAsset>();
        Set<IFixInfo> fixInfoSet = FixAdaptor.getInstalledIFixes(this.product.getInstallDir());
        for (IFixInfo fixInfo : fixInfoSet) {
            if (!fixInfo.getId().equals(fixId)) continue;
            if (!FixDependencyChecker.isUninstallable(fixInfoSet, fixInfo)) {
                throw ExceptionUtils.createByKey("ERROR_IFIX_UNINSTALLABLE", fixId);
            }
            for (Problem problem : fixInfo.getResolves().getProblems()) {
                ArrayList<String> dependency = FixDependencyChecker.fixRequiredByFeature(problem.getDisplayId(), this.product.getFeatureDefinitions());
                if (dependency == null) continue;
                this.log(Level.FINE, "Dependent features:");
                for (String f : dependency) {
                    this.log(Level.FINE, f);
                }
                throw ExceptionUtils.createByKey("ERROR_IFIX_UNINSTALLABLE_REQUIRED_BY_FEATURE", fixId, dependency.get(0));
            }
            this.uninstallAssets.add(new UninstallAsset(fixInfo));
            return;
        }
        throw ExceptionUtils.createByKey("ERROR_IFIX_NOT_INSTALLED", fixId);
    }

    private Collection<ProvisioningFeatureDefinition> getInstalledAutoFeatures(Collection<ProvisioningFeatureDefinition> installedFeatureDefinitions) {
        ArrayList<ProvisioningFeatureDefinition> autoFeatures = new ArrayList<ProvisioningFeatureDefinition>();
        for (ProvisioningFeatureDefinition pfd : installedFeatureDefinitions) {
            if (!this.isAutoFeature(pfd)) continue;
            autoFeatures.add(pfd);
        }
        return autoFeatures;
    }

    private Collection<String> getInstallFeatureRequiredFeatures(Collection<String> featureNames) {
        ArrayList<String> installFeatureRequiredFeatures = new ArrayList<String>();
        Map installFeatures = this.product.getManifestFileProcessor().getInstallFeatureDefinitions();
        if (installFeatures == null || installFeatures.isEmpty()) {
            return installFeatureRequiredFeatures;
        }
        for (String feature : featureNames) {
            ProvisioningFeatureDefinition pd = this.getProvisioningFeatureDefinition(installFeatures.values(), feature);
            if (pd == null || pd.getVisibility() == null || !pd.getVisibility().equals((Object)Visibility.INSTALL)) continue;
            Collection resources = pd.getConstituents(null);
            for (FeatureResource fr : resources) {
                if (!fr.getType().equals((Object)SubsystemContentType.FEATURE_TYPE)) continue;
                installFeatureRequiredFeatures.add(fr.getSymbolicName());
            }
        }
        return installFeatureRequiredFeatures;
    }

    private Collection<String> getInstallFeatures(Collection<String> featureNames) {
        ArrayList<String> installTypeFeatures = new ArrayList<String>();
        Map installFeatures = this.product.getManifestFileProcessor().getInstallFeatureDefinitions();
        if (installFeatures == null || installFeatures.isEmpty()) {
            return installTypeFeatures;
        }
        for (String feature : featureNames) {
            ProvisioningFeatureDefinition pd = this.getProvisioningFeatureDefinition(installFeatures.values(), feature);
            if (pd == null || pd.getVisibility() == null || !pd.getVisibility().equals((Object)Visibility.INSTALL)) continue;
            installTypeFeatures.add(pd.getSymbolicName());
        }
        return installTypeFeatures;
    }

    private Collection<String> getNotInstalledFeatures(Collection<ProvisioningFeatureDefinition> featureDefinitions, Collection<String> features) {
        ArrayList<String> f = new ArrayList<String>();
        for (String feature : features) {
            ProvisioningFeatureDefinition pp = this.getProvisioningFeatureDefinition(featureDefinitions, feature);
            if (pp != null) continue;
            f.add(feature);
        }
        return f;
    }

    private Collection<String> getUnfoundUserFeatures(Collection<ProvisioningFeatureDefinition> featureDefinitions, Collection<String> features) {
        ArrayList<String> f = new ArrayList<String>();
        for (String feature : features) {
            ProvisioningFeatureDefinition ppE = this.getUserProvisioningFeatureDefinition(featureDefinitions, feature);
            if (ppE != null) continue;
            f.add(feature);
        }
        return f;
    }

    private Collection<String> getFeaturesWithUnfoundExtension(Collection<String> features) {
        ArrayList<String> featuresWithUnfoundExtension = new ArrayList<String>();
        for (String f : features) {
            String[] extFeat;
            String ext;
            if (f == null || !f.contains(":") || f.split(":").length != 2 || (ext = (extFeat = f.split(":"))[0]).isEmpty() || BundleRepositoryRegistry.keys().contains(ext)) continue;
            featuresWithUnfoundExtension.add(f);
        }
        return featuresWithUnfoundExtension;
    }

    private Map<UninstallAsset, String> getNotUninstallableAssets(List<UninstallAsset> uninstallAssets, Collection<ProvisioningFeatureDefinition> installedFeatureDefinitions, Collection<String> uninstallingInstallFeatures, boolean isChecking) {
        LinkedHashMap<UninstallAsset, String> notUninstallableAssets = new LinkedHashMap<UninstallAsset, String>();
        this.dependencyChecker = new FeatureDependencyChecker();
        uninstallAssets = this.dependencyChecker.determineOrder(uninstallAssets);
        for (UninstallAsset uninstallAsset : uninstallAssets) {
            Collection<ProvisioningFeatureDefinition> requiredByThisFeature = this.dependencyChecker.isUninstallable(uninstallAsset, installedFeatureDefinitions, uninstallingInstallFeatures, isChecking);
            Collection<ProvisioningFeatureDefinition> notToBeUninstalled = this.dependencyChecker.getNotToBeUninstall(requiredByThisFeature, uninstallAssets);
            if (notToBeUninstalled.isEmpty() || this.isAutoFeature(notToBeUninstalled)) continue;
            StringBuffer displayNames = new StringBuffer();
            int counter = 0;
            for (ProvisioningFeatureDefinition p : notToBeUninstalled) {
                ++counter;
                String shortName = p.getHeader("IBM-ShortName");
                if (shortName != null && !shortName.isEmpty()) {
                    displayNames.append(shortName);
                } else {
                    displayNames.append(p.getSymbolicName());
                }
                if (counter >= notToBeUninstalled.size()) continue;
                displayNames.append(", ");
            }
            String featureName = uninstallAsset.getProvisioningFeatureDefinition().getHeader("IBM-ShortName") != null && !uninstallAsset.getProvisioningFeatureDefinition().getHeader("IBM-ShortName").isEmpty() ? uninstallAsset.getProvisioningFeatureDefinition().getHeader("IBM-ShortName") : uninstallAsset.getProvisioningFeatureDefinition().getSymbolicName();
            notUninstallableAssets.put(uninstallAsset, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNINSTALL_DEPENDENCY_CHECKING_FAILED_REQUIRED_BY", featureName, displayNames));
        }
        return notUninstallableAssets;
    }

    private Collection<ProvisioningFeatureDefinition> getProvisioningFeatureDefinition(Collection<ProvisioningFeatureDefinition> featureDefinitions, Collection<String> features) {
        ArrayList<ProvisioningFeatureDefinition> p = new ArrayList<ProvisioningFeatureDefinition>();
        for (String feature : features) {
            ProvisioningFeatureDefinition pp = this.getProvisioningFeatureDefinition(featureDefinitions, feature);
            if (pp == null) continue;
            p.add(pp);
        }
        return p;
    }

    private ProvisioningFeatureDefinition getProvisioningFeatureDefinition(Collection<ProvisioningFeatureDefinition> featureDefinitions, String feature) {
        for (ProvisioningFeatureDefinition pfd : featureDefinitions) {
            if (!this.isFeatureDefinition(pfd, feature)) continue;
            return pfd;
        }
        return null;
    }

    private ProvisioningFeatureDefinition getUserProvisioningFeatureDefinition(Collection<ProvisioningFeatureDefinition> featureDefinitions, String feature) {
        for (ProvisioningFeatureDefinition pfd : featureDefinitions) {
            if (!this.isUserFeatureaDefinition(pfd, feature)) continue;
            return pfd;
        }
        return null;
    }

    private Collection<String> getRequiredInternalFeatures(Collection<String> features, Collection<ProvisioningFeatureDefinition> installedFeatureDefinitions) {
        ArrayList<String> internalFeatures = new ArrayList<String>();
        for (String feature : features) {
            ProvisioningFeatureDefinition pd = this.getProvisioningFeatureDefinition(installedFeatureDefinitions, feature);
            if (pd != null) {
                Collection resources = pd.getConstituents(null);
                for (FeatureResource fr : resources) {
                    ProvisioningFeatureDefinition dependentPd;
                    if (!fr.getType().equals((Object)SubsystemContentType.FEATURE_TYPE) || (dependentPd = this.getProvisioningFeatureDefinition(installedFeatureDefinitions, fr.getSymbolicName())) == null || dependentPd.getVisibility() != null && dependentPd.getVisibility().equals((Object)Visibility.PUBLIC)) continue;
                    try {
                        this.log(Level.FINEST, "Perform uninstall prereq checking for the internal feature: " + fr.getSymbolicName());
                        this.uninstallFeaturesPrereqChecking(fr.getSymbolicName());
                        this.log(Level.FINEST, "Internel dependent feature to be uninstalled: " + fr.getSymbolicName());
                        internalFeatures.add(fr.getSymbolicName());
                    }
                    catch (InstallException e) {
                        this.log(Level.FINEST, e.getMessage(), e);
                    }
                }
                continue;
            }
            this.log(Level.FINEST, feature + " is already uninstalled.");
        }
        return internalFeatures;
    }

    private Collection<String> getUsrFeatures(Collection<String> featureNames) {
        ArrayList<String> userFeatures = new ArrayList<String>();
        Map usrFeatures = this.product.getManifestFileProcessor().getFeatureDefinitions("usr");
        Map extFeatures = this.product.getManifestFileProcessor().getFeatureDefinitions("ext");
        HashMap allUsrfeatures = new HashMap();
        if ((usrFeatures == null || usrFeatures.isEmpty()) && (extFeatures == null || extFeatures.isEmpty())) {
            return userFeatures;
        }
        if (usrFeatures != null && !usrFeatures.isEmpty()) {
            allUsrfeatures.putAll(usrFeatures);
        }
        if (extFeatures != null && !extFeatures.isEmpty()) {
            allUsrfeatures.putAll(extFeatures);
        }
        for (String feature : featureNames) {
            if (feature.contains(":") && feature.split(":").length == 2) {
                feature = feature.split(":")[1];
            }
            for (ProvisioningFeatureDefinition pfd : allUsrfeatures.values()) {
                if (!pfd.getSymbolicName().equals(feature) && (InstallUtils.getShortName(pfd) == null || !InstallUtils.getShortName(pfd).equals(feature))) continue;
                userFeatures.add(feature);
            }
        }
        return userFeatures;
    }

    private boolean isAutoFeature(ProvisioningFeatureDefinition pfd) {
        String installPolicy = pfd.getHeader("IBM-Install-Policy");
        if (pfd.isAutoFeature() && installPolicy != null && installPolicy.equals("when-satisfied")) {
            this.log(Level.FINEST, pfd.getSymbolicName() + " is auto feature.");
            return true;
        }
        return false;
    }

    private boolean isAutoFeature(Collection<ProvisioningFeatureDefinition> pfd) {
        for (ProvisioningFeatureDefinition p : pfd) {
            if (this.isAutoFeature(p)) continue;
            return false;
        }
        return true;
    }

    private boolean isUserFeatureaDefinition(ProvisioningFeatureDefinition pd, String feature) {
        String featureName = feature;
        String ext = "";
        if (feature.contains(":") && feature.split(":").length == 2) {
            String[] extFeature = feature.split(":");
            ext = extFeature[0];
            featureName = extFeature[1];
            String shortName = InstallUtils.getShortName(pd);
            String br = pd.getBundleRepositoryType();
            if (ext.isEmpty()) {
                return true;
            }
            return br.equals(ext) && (pd.getSymbolicName().equals(featureName) || shortName != null && shortName.equalsIgnoreCase(featureName));
        }
        return true;
    }

    private boolean isFeatureDefinition(ProvisioningFeatureDefinition pd, String feature) {
        String[] extFeature;
        String featureName = feature;
        String ext = "";
        if (feature.contains(":") && feature.split(":").length == 2 && !(ext = (extFeature = feature.split(":"))[0]).isEmpty()) {
            featureName = extFeature[1];
        }
        String shortName = InstallUtils.getShortName(pd);
        String br = pd.getBundleRepositoryType();
        return (br.equals(ext) || ext.isEmpty() && !br.isEmpty()) && (pd.getSymbolicName().equals(featureName) || shortName != null && shortName.equalsIgnoreCase(featureName));
    }

    private boolean isInstalledAutoFeatureStillRequired(ProvisioningFeatureDefinition autoFeature, Collection<ProvisioningFeatureDefinition> featureDefinitionsToCheck) {
        if (autoFeature.isCapabilitySatisfied(featureDefinitionsToCheck)) {
            this.log(Level.FINEST, "auto feature " + autoFeature.getSymbolicName() + " is still required.");
            return true;
        }
        this.log(Level.FINEST, "auto feature " + autoFeature.getSymbolicName() + " is not required.");
        return false;
    }

    private List<UninstallAsset> removeUninstallableAssets(Collection<UninstallAsset> featuresToBeUninstalled, Collection<UninstallAsset> featuresNotUninstallable) {
        ArrayList<UninstallAsset> uninstallAssets = new ArrayList<UninstallAsset>();
        for (UninstallAsset asset : featuresToBeUninstalled) {
            boolean add = true;
            for (UninstallAsset featureNotUninstallable : featuresNotUninstallable) {
                if (!asset.getProvisioningFeatureDefinition().getSymbolicName().equals(featureNotUninstallable.getProvisioningFeatureDefinition().getSymbolicName())) continue;
                this.log(Level.FINEST, asset.getProvisioningFeatureDefinition().getSymbolicName() + " cannot be uninstalled.");
                add = false;
                break;
            }
            if (!add) continue;
            uninstallAssets.add(asset);
        }
        return uninstallAssets;
    }

    private void uninstallInternalAndAutoFeatures(Collection<String> featureNames, Collection<ProvisioningFeatureDefinition> installedFeatureDefinitions, Collection<String> installFeatureNames) throws InstallException {
        ArrayList<String> uninstallInternalAndAutoFeatures = new ArrayList<String>();
        uninstallInternalAndAutoFeatures.addAll(this.getRequiredInternalFeatures(featureNames, installedFeatureDefinitions));
        Collection<ProvisioningFeatureDefinition> autoFeatures = this.getInstalledAutoFeatures(installedFeatureDefinitions);
        for (ProvisioningFeatureDefinition autoFeature : autoFeatures) {
            if (this.isInstalledAutoFeatureStillRequired(autoFeature, this.product.getAllFeatureDefinitions().values())) continue;
            this.log(Level.FINEST, "Auto feature to be uninstalled: " + autoFeature.getSymbolicName());
            uninstallInternalAndAutoFeatures.add(autoFeature.getSymbolicName());
        }
        this.uninstallFeatures(uninstallInternalAndAutoFeatures, installFeatureNames, false);
    }

    private void uninstallFeaturesPrereqChecking(String featureName) throws InstallException {
        ArrayList<String> featureNames = new ArrayList<String>();
        featureNames.add(featureName);
        this.uninstallFeaturesPrereqChecking(featureNames, true, false);
    }

    public boolean needToSetScriptsPermission() {
        return this.setScriptsPermission;
    }

    private void checkSetScriptsPermission(List<File> filesRestored) {
        if (this.setScriptsPermission) {
            return;
        }
        this.setScriptsPermission = this.containScript(filesRestored);
    }
}

