/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.internal.asset.ESABaseAsset;
import com.ibm.ws.kernel.feature.internal.cmdline.ThirdPartyLicenseProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.ZipLicenseProvider;

public class ESAVirtualAsset
extends ESABaseAsset {
    public ESAVirtualAsset(ZipFile indexZip, String featureName, String repoType, boolean isTemporary) throws IOException {
        super(indexZip, featureName, repoType, isTemporary);
    }

    @Override
    protected LicenseProvider createLicenseProvider(String licenseAgreementPrefix, String licenseInformationPrefix, String subsystemLicenseType) {
        String featureLicenseInformationPrefix;
        String featureLicenseAgreementPrefix = this.featureName + "/" + licenseAgreementPrefix;
        String string = featureLicenseInformationPrefix = licenseInformationPrefix == null ? null : this.featureName + "/" + licenseInformationPrefix;
        if (featureLicenseInformationPrefix == null) {
            LicenseProvider lp = ZipLicenseProvider.createInstance((ZipFile)this.zip, (String)featureLicenseAgreementPrefix);
            if (lp != null) {
                return lp;
            }
        } else {
            ReturnCode licenseReturnCode = ZipLicenseProvider.buildInstance((ZipFile)this.zip, (String)featureLicenseAgreementPrefix, featureLicenseInformationPrefix);
            if (licenseReturnCode == ReturnCode.OK) {
                return ZipLicenseProvider.getInstance();
            }
        }
        if (subsystemLicenseType != null && subsystemLicenseType.length() > 0) {
            return new ThirdPartyLicenseProvider(this.featureDefinition.getFeatureName(), subsystemLicenseType);
        }
        return null;
    }

    @Override
    protected String getHeader(String header, Locale locale) {
        ResourceBundle rb;
        String value = this.featureDefinition.getHeader(header);
        if (value == null || value.isEmpty() || locale == null) {
            return value;
        }
        if (value.charAt(0) == '%' && (rb = this.getResourceBundle(locale)) != null) {
            value = rb.getString(value.substring(1));
        }
        return value;
    }

    @Override
    protected ResourceBundle getResourceBundle(Locale locale) {
        try {
            ZipEntry entry = this.getEntry(this.featureName + "/OSGI-INF/l10n/subsystem_" + locale.getLanguage() + ".properties");
            if (entry == null) {
                entry = this.getEntry(this.featureName + "/OSGI-INF/l10n/subsystem.properties");
            }
            if (entry != null) {
                return new PropertyResourceBundle(this.getInputStream(entry));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public long size() {
        try {
            ZipEntry entry = this.getEntry("feature.properties");
            if (entry != null) {
                Properties p = new Properties();
                InputStream inStream = this.getInputStream(entry);
                p.load(inStream);
                String size = p.getProperty(this.featureName + ".size");
                return Long.valueOf(size);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0L;
    }
}

