/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.writer;

import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.writer.RepositoryExporter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;

public class CompatibilityRepositoryExporter
implements RepositoryExporter {
    private final PrintStream out;
    private boolean closeStream = false;
    private final HpelFormatter formatter;
    private boolean isClosed = false;
    private boolean isInitialized = false;

    public CompatibilityRepositoryExporter(File outputFile, HpelFormatter formatter) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(outputFile, false)), formatter);
        this.closeStream = true;
    }

    protected CompatibilityRepositoryExporter(OutputStream out, HpelFormatter formatter) {
        this(new PrintStream(out), formatter);
    }

    public CompatibilityRepositoryExporter(PrintStream out, HpelFormatter formatter) {
        this.out = out;
        this.formatter = formatter;
    }

    @Override
    public void close() {
        this.out.flush();
        if (this.closeStream) {
            this.out.close();
        }
        this.isClosed = true;
    }

    @Override
    public void storeHeader(Properties header) {
        this.storeHeader(header, null);
    }

    @Override
    public void storeHeader(Properties header, String subProcess) {
        if (this.isClosed) {
            throw new IllegalStateException("This instance of the exporter is already closed");
        }
        if (subProcess != null) {
            this.out.print("----------  ");
            this.out.print(subProcess);
            this.out.print("  ----------");
            this.out.print(this.formatter.getLineSeparator());
        }
        this.formatter.setHeaderProps(header);
        for (String headerLine : this.formatter.getHeader()) {
            this.out.print(headerLine);
            this.out.print(this.formatter.getLineSeparator());
        }
        this.isInitialized = true;
    }

    @Override
    public void storeRecord(RepositoryLogRecord record) {
        if (this.isClosed) {
            throw new IllegalStateException("This instance of the exporter is already closed");
        }
        if (!this.isInitialized) {
            throw new IllegalStateException("This instance of the exporter does not have header information yet");
        }
        String formatRecord = this.formatter.formatRecord(record);
        this.out.print(formatRecord);
        this.out.print(this.formatter.getLineSeparator());
    }
}

