/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.ras.instrument.internal.bci.AbstractRasClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter;
import com.ibm.ws.ras.instrument.internal.bci.RasMethodAdapter;
import com.ibm.ws.ras.instrument.internal.main.LibertyTracePreprocessInstrumentation;
import com.ibm.ws.ras.instrument.internal.model.ClassInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class FFDCClassAdapter
extends AbstractRasClassAdapter {
    public static final Type INJECTED_FFDC_TYPE = Type.getType(InjectedFFDC.class);
    private boolean injectedFFDCAnnotation;
    private boolean instrumented;

    public FFDCClassAdapter(ClassVisitor visitor, ClassInfo classInfo) {
        super(visitor, classInfo);
    }

    public FFDCClassAdapter(ClassVisitor visitor, ClassInfo classInfo, LibertyTracePreprocessInstrumentation.ClassTraceInfo ignored) {
        super(visitor, classInfo);
    }

    @Override
    public RasMethodAdapter createRasMethodAdapter(MethodVisitor mv, int access, String name, String descriptor, String signature, String[] exceptions) {
        return new FFDCMethodAdapter(this, mv, access, name, descriptor, signature, exceptions);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (INJECTED_FFDC_TYPE.getDescriptor().equals(desc)) {
            this.injectedFFDCAnnotation = true;
            this.instrumented = true;
        }
        return av;
    }

    @Override
    protected void ensureAnnotated() {
        super.ensureAnnotated();
        if (!this.injectedFFDCAnnotation) {
            super.visitAnnotation(INJECTED_FFDC_TYPE.getDescriptor(), true).visitEnd();
            this.injectedFFDCAnnotation = true;
        }
    }

    protected boolean isClassInstrumentedByThisAdapter() {
        return this.instrumented;
    }

    @Override
    public String getTraceObjectFieldName() {
        return null;
    }

    @Override
    public Type getTraceObjectFieldType() {
        return null;
    }

    @Override
    public boolean isTraceObjectFieldDefinitionRequired() {
        return false;
    }

    @Override
    public boolean isTraceObjectFieldInitializationRequired() {
        return false;
    }

    public boolean isCallFFDCOnThrow() {
        return false;
    }

    @Override
    public boolean isTrivial() {
        return false;
    }

    @Override
    public boolean isStaticInitializerRequired() {
        return false;
    }

    @Override
    public boolean isInjectedTraceAnnotationRequired() {
        return false;
    }
}

