/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetatypeUtils {
    static final TraceComponent tc = Tr.register(MetatypeUtils.class);
    private static final Map<String, TimeUnit> UNIT_DESCRIPTORS;
    private static final Pattern INTERVAL_STRING;

    @FFDCIgnore(value={NumberFormatException.class})
    public static Long evaluateDuration(String strVal, TimeUnit endUnit) {
        try {
            return Long.valueOf(strVal);
        }
        catch (NumberFormatException numberFormatException) {
            return MetatypeUtils.evaluateDuration(strVal, endUnit, UNIT_DESCRIPTORS);
        }
    }

    private static Long evaluateDuration(String strVal, TimeUnit endUnit, Map<String, TimeUnit> unitDescriptors) {
        Matcher m = INTERVAL_STRING.matcher(strVal);
        long retVal = 0L;
        boolean somethingParsed = false;
        while (m.find()) {
            somethingParsed = true;
            Long numberVal = Long.valueOf(m.group(1));
            String unitStr = m.group(2);
            if (unitStr == null) {
                throw new IllegalArgumentException("Could not parse configuration value as a duration: " + strVal);
            }
            TimeUnit sourceUnit = unitDescriptors.get(unitStr.trim().toLowerCase());
            if (sourceUnit == null) {
                throw new IllegalArgumentException("Could not parse configuration value as a duration: " + strVal);
            }
            retVal += endUnit.convert(numberVal, sourceUnit);
        }
        if (!somethingParsed) {
            throw new IllegalArgumentException("Could not parse configuration value as a duration: " + strVal);
        }
        return retVal;
    }

    static {
        HashMap<String, TimeUnit> units = new HashMap<String, TimeUnit>();
        units.put("d", TimeUnit.DAYS);
        units.put("dn\u016f", TimeUnit.DAYS);
        units.put("g", TimeUnit.DAYS);
        units.put("j", TimeUnit.DAYS);
        units.put("n", TimeUnit.DAYS);
        units.put("t", TimeUnit.DAYS);
        units.put("z", TimeUnit.DAYS);
        units.put("\u0434", TimeUnit.DAYS);
        units.put("\u5929", TimeUnit.DAYS);
        units.put("h", TimeUnit.HOURS);
        units.put("hod", TimeUnit.HOURS);
        units.put("\u00f3", TimeUnit.HOURS);
        units.put("\u0447", TimeUnit.HOURS);
        units.put("\u5c0f\u6642", TimeUnit.HOURS);
        units.put("m", TimeUnit.MINUTES);
        units.put("min", TimeUnit.MINUTES);
        units.put("\u043c", TimeUnit.MINUTES);
        units.put("\u5206", TimeUnit.MINUTES);
        units.put("e", TimeUnit.SECONDS);
        units.put("mp", TimeUnit.SECONDS);
        units.put("s", TimeUnit.SECONDS);
        units.put("\u0441", TimeUnit.SECONDS);
        units.put("\u79d2", TimeUnit.SECONDS);
        units.put("ms", TimeUnit.MILLISECONDS);
        units.put("\u043c\u0441", TimeUnit.MILLISECONDS);
        units.put("\u6beb\u79d2", TimeUnit.MILLISECONDS);
        UNIT_DESCRIPTORS = Collections.unmodifiableMap(units);
        INTERVAL_STRING = Pattern.compile("(\\d+)(\\D+)");
    }
}

