/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureManifestException;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.ActivationType;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.feature.LibertyFeature;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class FeatureRepository2
implements FeatureResolver.Repository {
    private static final TraceComponent tc = Tr.register(FeatureRepository2.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    public static final boolean isBeta = Boolean.valueOf(System.getProperty("com.ibm.ws.beta.edition"));
    private static final int FEATURE_CACHE_VERSION = 3;
    private final BundleContext bundleContext;
    private static final String TOLERATE_PREFIX = "tolerates.";
    private final WsResource cacheResource;
    private boolean cacheOk = true;
    private boolean isDirty;
    private static final long LAST_MODIFIED_PRECISION = 1000L;
    private final Map<String, SubsystemFeatureDefinitionImpl> installedFeatures = new HashMap<String, SubsystemFeatureDefinitionImpl>();
    private final Map<String, LibertyFeatureServiceFactory> featureServiceFactories = new ConcurrentHashMap<String, LibertyFeatureServiceFactory>();
    private Map<File, BadFeature> knownBadFeatureFiles;
    private Map<File, SubsystemFeatureDefinitionImpl> knownGoodFeatureFiles;
    private List<SubsystemFeatureDefinitionImpl> autoFeatures;
    private Map<String, SubsystemFeatureDefinitionImpl> compatibilityFeatures;
    private volatile Set<String> configuredPlatforms = Collections.emptySet();
    private volatile String platformEnvVar;
    private volatile Set<String> configuredFeatures = Collections.emptySet();
    private volatile Set<String> resolvedFeatures = Collections.emptySet();
    private volatile boolean configurationError = true;
    private final Map<String, String> lcFeatures = new HashMap<String, String>();
    private static final boolean DO_STORE = true;
    private final Map<String, String> publicFeatureNameToSymbolicName = new HashMap<String, String>();
    private final Map<String, String> alternateFeatureNameToPublicName = new HashMap<String, String>();
    private static final String EMPTY = "";
    private static final String MANIFEST_EXT = ".mf";
    private static final int MANIFEST_EXT_LEN = ".mf".length();
    static final long serialVersionUID = 2129917747953339067L;

    private static void debug(String message, String parm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[]{parm});
        }
    }

    private static void debug(String message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        }
    }

    @Trivial
    private static String consumeEmpty(String s) {
        return s != null && s.isEmpty() ? null : s;
    }

    @Trivial
    private static boolean equals(String s0, String s1) {
        if (s0 == null) {
            return s1 == null;
        }
        if (s1 == null) {
            return false;
        }
        return s0.equals(s1);
    }

    @Trivial
    private static <T> Set<T> asUnmodifiable(Collection<T> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<T>(source));
    }

    public static int getCacheVersion() {
        return isBeta ? 4 : 3;
    }

    public FeatureRepository2() {
        this.cacheResource = null;
        this.isDirty = true;
        this.bundleContext = null;
    }

    public FeatureRepository2(WsResource cacheResource, BundleContext bundleContext) {
        this.cacheResource = cacheResource;
        this.isDirty = false;
        this.bundleContext = bundleContext;
    }

    @Override
    public List<String> getConfiguredTolerates(String baseSymbolicName) {
        if (this.bundleContext == null) {
            return Collections.emptyList();
        }
        String tolerates = this.bundleContext.getProperty(TOLERATE_PREFIX + baseSymbolicName);
        if (tolerates == null) {
            return Collections.emptyList();
        }
        String[] parts = tolerates.split(",");
        ArrayList<String> versions = new ArrayList<String>(parts.length);
        for (String p : parts) {
            if ((p = p.trim()).isEmpty()) continue;
            versions.add(p);
        }
        return versions;
    }

    private void cacheWarning(IOException ioe) {
        if (this.cacheOk) {
            this.cacheOk = false;
            Tr.warning((TraceComponent)tc, (String)"UPDATE_BUNDLE_CACHE_WARNING", (Object[])new Object[]{this.cacheResource.toExternalURI(), ioe.toString()});
        }
    }

    private boolean isCacheReadable() {
        return this.cacheOk && this.cacheResource != null && this.cacheResource.exists();
    }

    private boolean isCacheWritable() {
        return this.cacheOk && this.cacheResource != null;
    }

    private void setClean() {
        this.isDirty = false;
    }

    private void setDirty() {
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private static long getLastModified(File f) {
        return FeatureRepository2.reducePrecision(f.lastModified(), 1000L);
    }

    private static long reducePrecision(long value, long precision) {
        return value / precision * precision;
    }

    private void putBadFeature(File file) {
        this.knownBadFeatureFiles.put(file, new BadFeature(file));
    }

    private SubsystemFeatureDefinitionImpl getFeatureSymbolic(String symbolicName) {
        return this.installedFeatures.get(symbolicName);
    }

    public Map<String, SubsystemFeatureDefinitionImpl> getAllFeatures() {
        return this.installedFeatures;
    }

    private SubsystemFeatureDefinitionImpl putInstalledFeature(String symbolicName, SubsystemFeatureDefinitionImpl featureDef) {
        return this.installedFeatures.put(symbolicName, featureDef);
    }

    private void removeFeature(String symbolicName) {
        this.installedFeatures.remove(symbolicName);
    }

    @Override
    public List<ProvisioningFeatureDefinition> getFeatures() {
        return new ArrayList<ProvisioningFeatureDefinition>(this.installedFeatures.values());
    }

    @Override
    public SubsystemFeatureDefinitionImpl getFeature(String featureName) {
        SubsystemFeatureDefinitionImpl featureDef = this.installedFeatures.get(featureName);
        if (featureDef == null) {
            String symbolicName = this.getSymbolicName(featureName);
            featureDef = this.installedFeatures.get(symbolicName);
        }
        return featureDef;
    }

    public boolean disableAllFeaturesOnConflict(String featureName) {
        SubsystemFeatureDefinitionImpl feature = this.getFeature(featureName);
        return feature != null && feature.getImmutableAttributes().disableOnConflict;
    }

    @Override
    public Collection<ProvisioningFeatureDefinition> getAutoFeatures() {
        if (this.autoFeatures == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        return Collections.unmodifiableCollection(this.autoFeatures);
    }

    public static String getCompatibilityPlatform(SubsystemFeatureDefinitionImpl def, FeatureDefinitionUtils.ImmutableAttributes attr) {
        if (def.getVisibility() != Visibility.PRIVATE) {
            return null;
        }
        if (attr.platforms == null || attr.platforms.isEmpty()) {
            return null;
        }
        return def.getPlatformName();
    }

    public ProvisioningFeatureDefinition getCompatibilityFeature(String platformName) {
        return this.compatibilityFeatures.get(this.toLower(platformName, true));
    }

    private void putCompatibilityFeature(String platformName, SubsystemFeatureDefinitionImpl featureDef) {
        this.compatibilityFeatures.put(this.toLower(platformName, true), featureDef);
    }

    private void removeCompatibilityFeature(String platformName) {
        this.compatibilityFeatures.remove(this.toLower(platformName, false));
    }

    public Set<String> getConfiguredPlatforms() {
        return this.configuredPlatforms;
    }

    public void setPlatformEnvVar(String platformEnvVar) {
        this.platformEnvVar = FeatureRepository2.consumeEmpty(platformEnvVar);
    }

    public String getPlatformEnvVar() {
        return this.platformEnvVar;
    }

    public Set<String> getConfiguredFeatures() {
        return this.configuredFeatures;
    }

    @Deprecated
    public Set<String> getInstalledFeatures() {
        return this.getResolvedFeatures();
    }

    public Set<String> getResolvedFeatures() {
        return this.resolvedFeatures;
    }

    public boolean emptyFeatures() {
        return this.resolvedFeatures.isEmpty();
    }

    public boolean hasConfigurationError() {
        return this.configurationError;
    }

    @Deprecated
    public void copyInstalledFeaturesTo(Set<String> features) {
        this.copyResolvedFeaturesTo(features);
    }

    public void copyResolvedFeaturesTo(Set<String> features) {
        features.addAll(this.resolvedFeatures);
    }

    public boolean featureSetEquals(Set<String> newFeatureSet) {
        if (newFeatureSet == null) {
            return false;
        }
        return !this.isDirty && newFeatureSet.equals(this.resolvedFeatures);
    }

    @Deprecated
    public void setInstalledFeatures(Set<String> newResolvedFeatures, Set<String> newConfiguredFeatures, boolean configurationError) {
        this.setResolvedFeatures(newResolvedFeatures, newConfiguredFeatures, configurationError, Collections.emptySet(), null);
    }

    public void setResolvedFeatures(Set<String> newResolvedFeatures, Set<String> newConfiguredFeatures, boolean configurationError, Set<String> newConfiguredPlatforms, String platformEnv) {
        if (isBeta) {
            if (!this.configuredPlatforms.equals(newConfiguredPlatforms)) {
                this.setDirty();
                this.configuredPlatforms = FeatureRepository2.asUnmodifiable(newConfiguredPlatforms);
            }
            if (!FeatureRepository2.equals(this.platformEnvVar, platformEnv = FeatureRepository2.consumeEmpty(platformEnv))) {
                this.setDirty();
                this.platformEnvVar = platformEnv;
            }
        }
        if (!this.configuredFeatures.equals(newConfiguredFeatures)) {
            this.setDirty();
            this.configuredFeatures = FeatureRepository2.asUnmodifiable(newConfiguredFeatures);
        }
        if (!this.resolvedFeatures.equals(newResolvedFeatures)) {
            this.setDirty();
            this.resolvedFeatures = FeatureRepository2.asUnmodifiable(newResolvedFeatures);
        }
        this.configurationError = configurationError;
    }

    @Deprecated
    public void removeInstalledFeature(String feature) {
        this.removeResolvedFeature(feature);
    }

    public void removeResolvedFeature(String feature) {
        this.configurationError = true;
        this.resolvedFeatures.remove(feature);
    }

    public boolean areConfiguredFeaturesGood(Set<String> newConfiguredFeatures, Set<String> newConfiguredPlatforms, String newPlatformEnvironmentVar) {
        if (this.isDirty() || this.hasConfigurationError()) {
            return false;
        }
        if (isBeta) {
            if (!this.getConfiguredPlatforms().equals(newConfiguredPlatforms)) {
                return false;
            }
            if (!FeatureRepository2.equals(this.getPlatformEnvVar(), newPlatformEnvironmentVar)) {
                return false;
            }
        }
        if (!this.getConfiguredFeatures().equals(newConfiguredFeatures)) {
            return false;
        }
        for (String resolvedFeature : this.getResolvedFeatures()) {
            if (this.getFeature(resolvedFeature) != null) continue;
            return false;
        }
        return true;
    }

    @Trivial
    public static String lowerFeature(String feature) {
        if (feature == null || feature.isEmpty()) {
            return feature;
        }
        int colonIndex = feature.indexOf(":");
        if (colonIndex > -1 && feature.length() > colonIndex) {
            String prefix = feature.substring(0, colonIndex).trim();
            String suffix = feature.substring(colonIndex + 1).trim();
            suffix = suffix.toLowerCase(Locale.ENGLISH);
            feature = prefix + ':' + suffix;
        } else {
            feature = feature.trim();
            feature = feature.toLowerCase(Locale.ENGLISH);
        }
        return feature;
    }

    @Trivial
    public String toLower(String feature, boolean doStore) {
        if (feature == null || feature.isEmpty()) {
            return feature;
        }
        String lcFeature = this.lcFeatures.get(feature);
        if (lcFeature == null) {
            lcFeature = FeatureRepository2.lowerFeature(feature);
            if (doStore) {
                this.lcFeatures.put(feature, lcFeature);
            }
        }
        return lcFeature;
    }

    private void putSymbolicName(String featureName, String symbolicName) {
        this.publicFeatureNameToSymbolicName.put(this.toLower(featureName, true), symbolicName);
    }

    private void removeSymbolicName(String featureName) {
        this.publicFeatureNameToSymbolicName.remove(this.toLower(featureName, false));
    }

    private String getSymbolicName(String featureName) {
        return this.publicFeatureNameToSymbolicName.get(this.toLower(featureName, false));
    }

    private void putAlternateName(String altName, String featureName) {
        this.alternateFeatureNameToPublicName.put(this.toLower(altName, true), featureName);
    }

    public String matchesAlternate(String featureName) {
        return this.alternateFeatureNameToPublicName.get(this.toLower(featureName, true));
    }

    public void init() {
        boolean firstInit = this.installedFeatures.isEmpty();
        this.autoFeatures = new ArrayList<SubsystemFeatureDefinitionImpl>();
        this.knownGoodFeatureFiles = new HashMap<File, SubsystemFeatureDefinitionImpl>();
        this.knownBadFeatureFiles = new HashMap<File, BadFeature>();
        this.compatibilityFeatures = new HashMap<String, SubsystemFeatureDefinitionImpl>();
        this.setClean();
        this.readCache(firstInit);
        this.readFeatureManifests();
        if (firstInit && this.isDirty()) {
            this.resolvedFeatures = Collections.emptySet();
            this.configuredFeatures = Collections.emptySet();
            this.configurationError = false;
            this.configuredPlatforms = Collections.emptySet();
            this.platformEnvVar = null;
        }
    }

    public void dispose() {
        this.storeCache();
        this.autoFeatures = null;
        this.knownGoodFeatureFiles = null;
        this.knownBadFeatureFiles = null;
        this.compatibilityFeatures = null;
        for (SubsystemFeatureDefinitionImpl def : this.installedFeatures.values()) {
            def.setProvisioningDetails(null);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readCache(boolean firstInit) {
        boolean cachedConfigError;
        HashSet<String> cachedResolvedFeatures;
        HashSet<String> cachedConfiguredFeatures;
        String cachedEnvVar;
        HashSet<String> cachedConfiguredPlatforms;
        HashMap<File, BadFeature> knownBad;
        ArrayList<SubsystemFeatureDefinitionImpl> cachedInstalledFeatures;
        block25: {
            if (!this.isCacheReadable()) {
                return;
            }
            cachedInstalledFeatures = new ArrayList<SubsystemFeatureDefinitionImpl>();
            knownBad = new HashMap<File, BadFeature>();
            cachedConfiguredPlatforms = new HashSet<String>();
            cachedEnvVar = null;
            cachedConfiguredFeatures = new HashSet<String>();
            cachedResolvedFeatures = new HashSet<String>();
            cachedConfigError = false;
            try {
                InputStream input = this.cacheResource.get();
                try {
                    DataInputStream in;
                    block24: {
                        block23: {
                            in = new DataInputStream(new BufferedInputStream(input));
                            if (in.readInt() == FeatureRepository2.getCacheVersion()) break block23;
                            in.close();
                            if (input == null) return;
                            input.close();
                            return;
                        }
                        try {
                            int numFeatures = in.readInt();
                            for (int i = 0; i < numFeatures; ++i) {
                                FeatureDefinitionUtils.ImmutableAttributes attr = FeatureRepository2.loadFeatureAttributes(in);
                                FeatureDefinitionUtils.ProvisioningDetails details = FeatureRepository2.loadProvisioningDetails(in, attr);
                                String symbolicName = attr.symbolicName;
                                SubsystemFeatureDefinitionImpl installedFeature = this.getFeatureSymbolic(symbolicName);
                                if (!attr.featureFile.exists()) {
                                    this.setDirty();
                                    if (installedFeature == null) continue;
                                    this.removeFeature(symbolicName);
                                    continue;
                                }
                                if (installedFeature != null) {
                                    installedFeature.setProvisioningDetails(details);
                                } else {
                                    if (!firstInit) {
                                        this.setDirty();
                                    }
                                    installedFeature = new SubsystemFeatureDefinitionImpl(attr, details);
                                }
                                cachedInstalledFeatures.add(installedFeature);
                            }
                            int numResolved = in.readInt();
                            for (int i = 0; i < numResolved; ++i) {
                                cachedResolvedFeatures.add(in.readUTF());
                            }
                            int numConfigured = in.readInt();
                            for (int i = 0; i < numConfigured; ++i) {
                                cachedConfiguredFeatures.add(in.readUTF());
                            }
                            cachedConfigError = in.readBoolean();
                            int numBad = in.readInt();
                            for (int i = 0; i < numBad; ++i) {
                                File f = new File(in.readUTF());
                                if (!f.isFile()) continue;
                                knownBad.put(f, new BadFeature(f));
                            }
                            if (!isBeta) break block24;
                            int numPlatforms = in.readInt();
                            for (int i = 0; i < numPlatforms; ++i) {
                                cachedConfiguredPlatforms.add(in.readUTF());
                            }
                            boolean hasPlatformEnv = in.readBoolean();
                            if (!hasPlatformEnv) break block24;
                            cachedEnvVar = in.readUTF();
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"882", (Object)this, (Object[])new Object[]{firstInit});
                            try {
                                in.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"882", (Object)this, (Object[])new Object[]{firstInit});
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    in.close();
                    if (input == null) break block25;
                }
                catch (Throwable in) {
                    FFDCFilter.processException((Throwable)in, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"882", (Object)this, (Object[])new Object[]{firstInit});
                    if (input == null) throw in;
                    try {
                        input.close();
                        throw in;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"882", (Object)this, (Object[])new Object[]{firstInit});
                        in.addSuppressed(throwable);
                    }
                    throw in;
                }
                input.close();
            }
            catch (IOException input) {
                void e;
                FFDCFilter.processException((Throwable)input, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"965", (Object)this, (Object[])new Object[]{firstInit});
                this.cacheWarning((IOException)e);
                return;
            }
        }
        this.knownBadFeatureFiles.putAll(knownBad);
        this.configuredPlatforms = Collections.unmodifiableSet(cachedConfiguredPlatforms);
        this.platformEnvVar = cachedEnvVar;
        this.configuredFeatures = Collections.unmodifiableSet(cachedConfiguredFeatures);
        this.resolvedFeatures = Collections.unmodifiableSet(cachedResolvedFeatures);
        this.configurationError = cachedConfigError;
        Iterator iterator = cachedInstalledFeatures.iterator();
        while (iterator.hasNext()) {
            SubsystemFeatureDefinitionImpl cachedInstalledFeature = (SubsystemFeatureDefinitionImpl)iterator.next();
            this.updateMaps(cachedInstalledFeature);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeCache() {
        if (!this.isDirty || !this.isCacheWritable()) {
            return;
        }
        ArrayList<AbstractMap.SimpleEntry<FeatureDefinitionUtils.ImmutableAttributes, FeatureDefinitionUtils.ProvisioningDetails>> features = new ArrayList<AbstractMap.SimpleEntry<FeatureDefinitionUtils.ImmutableAttributes, FeatureDefinitionUtils.ProvisioningDetails>>();
        for (SubsystemFeatureDefinitionImpl entry : this.installedFeatures.values()) {
            FeatureDefinitionUtils.ImmutableAttributes imAttrs = entry.getImmutableAttributes();
            FeatureDefinitionUtils.ProvisioningDetails provisioningDetails = entry.getProvisioningDetails();
            if (imAttrs != null && provisioningDetails != null) {
                features.add(new AbstractMap.SimpleEntry<FeatureDefinitionUtils.ImmutableAttributes, FeatureDefinitionUtils.ProvisioningDetails>(imAttrs, provisioningDetails));
                continue;
            }
            FeatureRepository2.debug("Unable to write out " + entry.getFeatureName() + " to cache because the provisioning detail: " + provisioningDetails + " or imAttrs: " + imAttrs + " is null");
        }
        try {
            OutputStream cacheOutput = this.cacheResource.putStream();
            try {
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(cacheOutput));
                try {
                    out.writeInt(FeatureRepository2.getCacheVersion());
                    out.writeInt(features.size());
                    for (Map.Entry entry : features) {
                        FeatureRepository2.writeFeatureAttributes((FeatureDefinitionUtils.ImmutableAttributes)entry.getKey(), (FeatureDefinitionUtils.ProvisioningDetails)entry.getValue(), out);
                    }
                    Set<String> curResolved = this.resolvedFeatures;
                    out.writeInt(curResolved.size());
                    for (String string : curResolved) {
                        out.writeUTF(string);
                    }
                    Set<String> set = this.configuredFeatures;
                    out.writeInt(set.size());
                    for (String configured : set) {
                        out.writeUTF(configured);
                    }
                    out.writeBoolean(this.configurationError);
                    Map<File, BadFeature> map = this.knownBadFeatureFiles;
                    out.writeInt(map.size());
                    for (Map.Entry<File, BadFeature> entry : this.knownBadFeatureFiles.entrySet()) {
                        out.writeUTF(entry.getKey().getAbsolutePath());
                        out.writeLong(entry.getValue().lastModified);
                        out.writeLong(entry.getValue().length);
                    }
                    if (isBeta) {
                        out.writeInt(this.configuredPlatforms.size());
                        for (String plat : this.configuredPlatforms) {
                            out.writeUTF(plat);
                        }
                        if (this.platformEnvVar == null) {
                            out.writeBoolean(false);
                        } else {
                            out.writeBoolean(true);
                            out.writeUTF(this.platformEnvVar);
                        }
                    }
                    this.setClean();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"1003", (Object)this, (Object[])new Object[0]);
                    try {
                        out.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"1003", (Object)this, (Object[])new Object[0]);
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                out.close();
                if (cacheOutput == null) return;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"1003", (Object)this, (Object[])new Object[0]);
                if (cacheOutput == null) throw throwable;
                try {
                    cacheOutput.close();
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"1003", (Object)this, (Object[])new Object[0]);
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            cacheOutput.close();
            return;
        }
        catch (IOException cacheOutput) {
            void e;
            FFDCFilter.processException((Throwable)cacheOutput, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"1059", (Object)this, (Object[])new Object[0]);
            this.cacheWarning((IOException)e);
        }
    }

    static void writeFeatureAttributes(FeatureDefinitionUtils.ImmutableAttributes iAttr, FeatureDefinitionUtils.ProvisioningDetails details, DataOutputStream out) throws IOException {
        out.writeUTF(iAttr.bundleRepositoryType == null ? EMPTY : iAttr.bundleRepositoryType);
        out.writeUTF(iAttr.symbolicName);
        out.writeUTF(iAttr.featureFile == null ? EMPTY : iAttr.featureFile.getAbsolutePath());
        out.writeLong(iAttr.lastModified);
        out.writeLong(iAttr.length);
        out.writeUTF(iAttr.shortName == null ? EMPTY : iAttr.shortName);
        out.writeInt(iAttr.featureVersion);
        out.writeUTF(iAttr.visibility.toString());
        out.writeUTF(iAttr.appRestart.toString());
        out.writeInt(iAttr.version.getMajor());
        out.writeInt(iAttr.version.getMinor());
        out.writeInt(iAttr.version.getMicro());
        String qualifier = iAttr.version.getQualifier();
        out.writeUTF(qualifier == null ? EMPTY : qualifier);
        out.writeBoolean(iAttr.isAutoFeature);
        out.writeBoolean(iAttr.hasApiServices);
        out.writeBoolean(iAttr.hasApiPackages);
        out.writeBoolean(iAttr.hasSpiPackages);
        out.writeBoolean(iAttr.isSingleton);
        out.writeBoolean(iAttr.disableOnConflict);
        out.writeInt(iAttr.processTypes.size());
        for (ProcessType type : iAttr.processTypes) {
            out.writeUTF(type.toString());
        }
        out.writeUTF(iAttr.activationType.toString());
        out.writeInt(iAttr.alternateNames.size());
        for (String s : iAttr.alternateNames) {
            out.writeUTF(s);
        }
        out.writeInt(iAttr.platforms.size());
        for (String s : iAttr.platforms) {
            out.writeUTF(s);
        }
        if (iAttr.isAutoFeature) {
            FeatureRepository2.writeLongString(out, details.getCachedRawHeader("IBM-Provision-Capability"));
        }
        if (iAttr.hasApiServices) {
            FeatureRepository2.writeLongString(out, details.getCachedRawHeader("IBM-API-Service"));
        }
        if (iAttr.hasApiPackages) {
            FeatureRepository2.writeLongString(out, details.getCachedRawHeader("IBM-API-Package"));
        }
        if (iAttr.hasSpiPackages) {
            FeatureRepository2.writeLongString(out, details.getCachedRawHeader("IBM-SPI-Package"));
        }
    }

    private static void writeLongString(DataOutputStream out, String longString) throws IOException {
        byte[] data = longString.getBytes();
        if (data.length > 65535) {
            out.writeBoolean(true);
            out.writeInt(data.length);
            out.write(data);
        } else {
            out.writeBoolean(false);
            out.writeUTF(longString);
        }
    }

    static FeatureDefinitionUtils.ImmutableAttributes loadFeatureAttributes(DataInputStream in) throws IOException {
        String repositoryType = in.readUTF();
        if (repositoryType.isEmpty()) {
            repositoryType = EMPTY;
        }
        String symbolicName = in.readUTF();
        String featurePath = in.readUTF();
        File featureFile = featurePath.isEmpty() ? null : new File(featurePath);
        long lastModified = in.readLong();
        long fileSize = in.readLong();
        String shortName = in.readUTF();
        if (shortName.isEmpty()) {
            shortName = null;
        }
        int featureVersion = in.readInt();
        Visibility visibility = FeatureRepository2.valueOf(in.readUTF(), Visibility.PRIVATE);
        AppForceRestart appRestart = FeatureRepository2.valueOf(in.readUTF(), AppForceRestart.NEVER);
        Version version = new Version(in.readInt(), in.readInt(), in.readInt(), in.readUTF());
        boolean isAutoFeature = in.readBoolean();
        boolean hasApiServices = in.readBoolean();
        boolean hasApiPackages = in.readBoolean();
        boolean hasSpiPackages = in.readBoolean();
        boolean isSingleton = in.readBoolean();
        boolean disableOnConflict = in.readBoolean();
        int processTypeNum = in.readInt();
        EnumSet<ProcessType> processTypes = EnumSet.noneOf(ProcessType.class);
        for (int i = 0; i < processTypeNum; ++i) {
            processTypes.add(FeatureRepository2.valueOf(in.readUTF(), ProcessType.SERVER));
        }
        ActivationType activationType = FeatureRepository2.valueOf(in.readUTF(), ActivationType.SEQUENTIAL);
        int altNamesCount = in.readInt();
        ArrayList<String> altNames = new ArrayList<String>(altNamesCount);
        for (int x = 0; x < altNamesCount; ++x) {
            altNames.add(in.readUTF());
        }
        int platformsCount = in.readInt();
        ArrayList<String> platforms = new ArrayList<String>(platformsCount);
        for (int i = 0; i < platformsCount; ++i) {
            platforms.add(in.readUTF());
        }
        return new FeatureDefinitionUtils.ImmutableAttributes(repositoryType, symbolicName, shortName, altNames, featureVersion, visibility, appRestart, version, featureFile, lastModified, fileSize, isAutoFeature, hasApiServices, hasApiPackages, hasSpiPackages, isSingleton, disableOnConflict, processTypes, activationType, platforms);
    }

    static FeatureDefinitionUtils.ProvisioningDetails loadProvisioningDetails(DataInputStream in, FeatureDefinitionUtils.ImmutableAttributes iAttr) throws IOException {
        String autoFeatureCapability = iAttr.isAutoFeature ? FeatureRepository2.readLongString(in) : null;
        String apiServices = iAttr.hasApiServices ? FeatureRepository2.readLongString(in) : null;
        String apiPackages = iAttr.hasApiPackages ? FeatureRepository2.readLongString(in) : null;
        String spiPackages = iAttr.hasSpiPackages ? FeatureRepository2.readLongString(in) : null;
        return new FeatureDefinitionUtils.ProvisioningDetails(iAttr, autoFeatureCapability, apiServices, apiPackages, spiPackages);
    }

    private static String readLongString(DataInputStream in) throws IOException {
        if (in.readBoolean()) {
            byte[] data = new byte[in.readInt()];
            in.readFully(data);
            return new String(data, StandardCharsets.UTF_8);
        }
        return in.readUTF();
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public static <T extends Enum<T>> T valueOf(String name, T defaultValue) {
        try {
            return (T)Enum.valueOf(defaultValue.getClass(), name);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    private void readFeatureManifests() {
        for (BundleRepositoryRegistry.BundleRepositoryHolder holder : BundleRepositoryRegistry.holders()) {
            final String featureType = holder.getFeatureType();
            File libFeatureDir = new File(holder.getInstallDir(), "lib/features/");
            if (!libFeatureDir.isDirectory()) continue;
            libFeatureDir.listFiles(new FileFilter(){
                static final long serialVersionUID = 4274848263940184281L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public boolean accept(File file) {
                    FeatureRepository2.this.processFeatureManifest(featureType, file);
                    return false;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processFeatureManifest(String featureType, File file) {
        FeatureDefinitionUtils.ImmutableAttributes attr;
        FeatureDefinitionUtils.ProvisioningDetails details;
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            return;
        }
        if (!FeatureRepository2.isManifest(file)) {
            return;
        }
        BadFeature bad = this.knownBadFeatureFiles.get(file);
        if (bad != null && bad.sameAs(file)) {
            return;
        }
        SubsystemFeatureDefinitionImpl def = this.knownGoodFeatureFiles.get(file);
        if (def != null) {
            if (this.isUnchanged(file, def)) {
                return;
            }
            this.removeFromMaps(def);
        }
        this.setDirty();
        try {
            details = new FeatureDefinitionUtils.ProvisioningDetails(file, null);
            attr = FeatureDefinitionUtils.loadAttributes(featureType, file, details);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2", (String)"1301", (Object)this, (Object[])new Object[]{featureType, file});
            FeatureRepository2.debug("Exception reading feature manifest [ " + file.getAbsolutePath() + " ]", e.toString());
            this.putBadFeature(file);
            return;
        }
        if (!attr.isSupportedFeatureVersion()) {
            FeatureRepository2.debug("Unsupported feature version [ " + file.getAbsolutePath() + " ]");
            this.putBadFeature(file);
            return;
        }
        def = new SubsystemFeatureDefinitionImpl(attr, details);
        this.updateMaps(def);
    }

    private static boolean isManifest(File file) {
        String name = file.getName();
        int len = name.length();
        if (len < MANIFEST_EXT_LEN) {
            return false;
        }
        return name.regionMatches(true, len - MANIFEST_EXT_LEN, MANIFEST_EXT, 0, 3);
    }

    private boolean isUnchanged(File f, SubsystemFeatureDefinitionImpl featureDef) {
        FeatureDefinitionUtils.ImmutableAttributes attr = featureDef.getImmutableAttributes();
        return FeatureRepository2.reducePrecision(attr.lastModified, 1000L) == FeatureRepository2.getLastModified(f) && attr.length == f.length();
    }

    private void removeFromMaps(SubsystemFeatureDefinitionImpl featureDef) {
        FeatureDefinitionUtils.ImmutableAttributes attr = featureDef.getImmutableAttributes();
        this.removeSymbolicName(attr.featureName);
        this.removeFeature(attr.symbolicName);
        this.autoFeatures.remove(featureDef);
        String platform = FeatureRepository2.getCompatibilityPlatform(featureDef, attr);
        if (platform != null) {
            this.removeCompatibilityFeature(platform);
        }
    }

    private void updateMaps(SubsystemFeatureDefinitionImpl def) {
        FeatureDefinitionUtils.ImmutableAttributes attr = def.getImmutableAttributes();
        SubsystemFeatureDefinitionImpl oldDef = this.putInstalledFeature(attr.symbolicName, def);
        if (oldDef != null && !oldDef.equals(def)) {
            this.putInstalledFeature(attr.symbolicName, oldDef);
            String msg = "Duplicate symbolic name: " + attr.symbolicName + ", " + def.getFeatureDefinitionFile().getAbsolutePath() + " will be ignored. The file " + oldDef.getFeatureDefinitionFile().getAbsolutePath() + " will be used instead.";
            FeatureManifestException fme = new FeatureManifestException(msg, (String)null);
            FFDCFilter.processException((Throwable)fme, (String)this.getClass().getName(), (String)"updateMaps", (Object)this, (Object[])new Object[]{oldDef, def});
            this.putBadFeature(attr.featureFile);
            return;
        }
        this.knownGoodFeatureFiles.put(attr.featureFile, def);
        if (!attr.featureName.equals(attr.symbolicName)) {
            this.putSymbolicName(attr.featureName, attr.symbolicName);
        }
        if (def.getVisibility() == Visibility.PUBLIC) {
            this.putSymbolicName(attr.symbolicName, attr.symbolicName);
            for (String altName : attr.alternateNames) {
                this.putAlternateName(altName, attr.featureName);
            }
        } else if (def.getVisibility() == Visibility.PRIVATE && attr.platforms != null && !attr.platforms.isEmpty()) {
            this.putCompatibilityFeature(def.getPlatformName(), def);
        }
        if (attr.isAutoFeature) {
            this.autoFeatures.add(def);
        }
    }

    public void updateServices() {
        if (this.bundleContext == null) {
            return;
        }
        HashSet<String> resolvedSymbolicNames = new HashSet<String>();
        for (String featureName : this.resolvedFeatures) {
            String symbolicName = this.getSymbolicName(featureName);
            if (symbolicName == null) continue;
            resolvedSymbolicNames.add(symbolicName);
        }
        HashSet<String> removedFactories = new HashSet<String>(this.featureServiceFactories.keySet());
        removedFactories.removeAll(resolvedSymbolicNames);
        for (String symbolicName : removedFactories) {
            LibertyFeatureServiceFactory factory = this.featureServiceFactories.remove(symbolicName);
            if (factory == null) continue;
            factory.unregisterService();
        }
        for (String symbolicName : resolvedSymbolicNames) {
            SubsystemFeatureDefinitionImpl featureDef = this.getFeatureSymbolic(symbolicName);
            if (featureDef == null) continue;
            LibertyFeatureServiceFactory factory = this.featureServiceFactories.get(symbolicName);
            if (factory == null) {
                factory = new LibertyFeatureServiceFactory();
                this.featureServiceFactories.put(symbolicName, factory);
            }
            factory.update(featureDef, this.bundleContext);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class BadFeature {
        public final long lastModified;
        public final long length;
        static final long serialVersionUID = -6121819392722334511L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BadFeature(File f) {
            this(FeatureRepository2.getLastModified(f), f.length());
        }

        protected BadFeature(long lastModified, long length) {
            this.lastModified = lastModified;
            this.length = length;
        }

        public boolean sameAs(File f) {
            return FeatureRepository2.getLastModified(f) == this.lastModified && f.length() == this.length;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2$BadFeature", BadFeature.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class LibertyFeatureServiceFactory
    implements ServiceFactory<LibertyFeature> {
        private volatile SubsystemFeatureDefinitionImpl featureDef;
        private final Hashtable<String, Object> serviceProps = new Hashtable(4);
        private ServiceRegistration<LibertyFeature> registration;
        private static final String FEATURE_SERVICE_NAME = "ibm.featureName";
        private static final String FEATURE_SERVICE_SYMBOLIC_NAME = "osgi.symbolicName";
        private static final String FEATURE_SERVICE_VERSION = "osgi.version";
        private static final String FEATURE_SERVICE_CATEGORY = "osgi.category";
        private static final String FEATURE_SUBSYSTEM_CATEGORY = "Subsystem-Category";
        static final long serialVersionUID = -5163514004978770245L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private LibertyFeatureServiceFactory() {
        }

        void update(SubsystemFeatureDefinitionImpl featureDef, BundleContext bundleContext) {
            if (this.featureDef == featureDef) {
                return;
            }
            this.unregisterService();
            this.clearServiceProps();
            this.featureDef = featureDef;
            this.setServiceProps();
            this.registerService(bundleContext);
        }

        /*
         * WARNING - void declaration
         */
        public LibertyFeature getService(Bundle bundle, ServiceRegistration<LibertyFeature> useRegistration) {
            FeatureDefinitionUtils.ProvisioningDetails details = this.featureDef.getProvisioningDetails();
            if (details == null) {
                try {
                    details = new FeatureDefinitionUtils.ProvisioningDetails(this.featureDef.getImmutableAttributes().featureFile, null);
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2$LibertyFeatureServiceFactory", (String)"1559", (Object)this, (Object[])new Object[]{bundle, useRegistration});
                    FeatureRepository2.debug("An exception occurred while reading the feature manifest", e.toString());
                }
            }
            this.featureDef.setProvisioningDetails(details);
            return this.featureDef;
        }

        public void ungetService(Bundle bundle, ServiceRegistration<LibertyFeature> useRegistration, LibertyFeature service) {
            this.featureDef.setProvisioningDetails(null);
        }

        void registerService(BundleContext bundleContext) {
            this.registration = bundleContext.registerService(LibertyFeature.class, (ServiceFactory)this, this.serviceProps);
        }

        void unregisterService() {
            if (this.registration != null) {
                this.registration.unregister();
                this.registration = null;
            }
        }

        private void clearServiceProps() {
            this.serviceProps.clear();
        }

        private void setServiceProps() {
            this.serviceProps.put(FEATURE_SERVICE_NAME, this.featureDef.getFeatureName());
            this.serviceProps.put(FEATURE_SERVICE_SYMBOLIC_NAME, this.featureDef.getSymbolicName());
            this.serviceProps.put(FEATURE_SERVICE_VERSION, this.featureDef.getVersion());
            String category = this.featureDef.getHeader(FEATURE_SUBSYSTEM_CATEGORY);
            if (category != null) {
                this.serviceProps.put(FEATURE_SERVICE_CATEGORY, category.split("\\s*,\\s*"));
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository2$LibertyFeatureServiceFactory", LibertyFeatureServiceFactory.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

