/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.resolver;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Version;

public interface FeatureResolver {
    public static final List<String> EMPTY_STRINGS = Collections.emptyList();

    public Result resolveFeatures(Repository var1, Collection<String> var2, Set<String> var3, boolean var4);

    public Result resolveFeatures(Repository var1, Collection<ProvisioningFeatureDefinition> var2, Collection<String> var3, Set<String> var4, boolean var5);

    public Result resolveFeatures(Repository var1, Collection<ProvisioningFeatureDefinition> var2, Collection<String> var3, Set<String> var4, boolean var5, EnumSet<ProcessType> var6);

    public Result resolveFeatures(Repository var1, Collection<ProvisioningFeatureDefinition> var2, Collection<String> var3, Set<String> var4, Set<String> var5, EnumSet<ProcessType> var6);

    public Result resolve(Repository var1, Collection<String> var2, Set<String> var3, boolean var4, Collection<String> var5);

    public Result resolve(Repository var1, Collection<ProvisioningFeatureDefinition> var2, Collection<String> var3, Set<String> var4, boolean var5, Collection<String> var6);

    public Result resolve(Repository var1, Collection<ProvisioningFeatureDefinition> var2, Collection<String> var3, Set<String> var4, boolean var5, EnumSet<ProcessType> var6, Collection<String> var7);

    public Result resolve(Repository var1, Collection<ProvisioningFeatureDefinition> var2, Collection<String> var3, Set<String> var4, Set<String> var5, EnumSet<ProcessType> var6, Collection<String> var7);

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Chain {
        private final List<String> _chain;
        private final String _featureName;
        private final Version _preferredVersion;
        private final List<String> _candidates;
        private final String toString;
        static final long serialVersionUID = 142436509021378396L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private static Version parseVersion(String preferredVersion) {
            try {
                return Version.parseVersion((String)preferredVersion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.kernel.feature.resolver.FeatureResolver$Chain", (String)"125", null, (Object[])new Object[]{preferredVersion});
                return Version.emptyVersion;
            }
        }

        private static List<String> copyChain(Collection<String> chain) {
            return chain.isEmpty() ? EMPTY_STRINGS : new ArrayList<String>(chain);
        }

        public Chain(String featureName, String preferredVersion) {
            this(EMPTY_STRINGS, Collections.singletonList(featureName), preferredVersion, featureName);
        }

        public Chain(Chain otherChain) {
            this._chain = Chain.copyChain(otherChain._chain);
            this._featureName = otherChain._featureName;
            this._preferredVersion = otherChain._preferredVersion;
            this._candidates = new ArrayList<String>(otherChain.getCandidates());
            this.toString = this.getString();
        }

        public Chain(Collection<String> chain, List<String> candidates, String preferredVersion, String featureName) {
            this._chain = Chain.copyChain(chain);
            this._featureName = featureName;
            this._preferredVersion = Chain.parseVersion(preferredVersion);
            this._candidates = candidates;
            this.toString = this.getString();
        }

        public Chain(String candidate, String preferredVersion, String featureName) {
            this._chain = EMPTY_STRINGS;
            this._featureName = featureName;
            this._preferredVersion = Chain.parseVersion(preferredVersion);
            this._candidates = Collections.singletonList(candidate);
            this.toString = this.getString();
        }

        public List<String> getChain() {
            return this._chain;
        }

        public List<String> getCandidates() {
            return this._candidates;
        }

        public Version getPreferredVersion() {
            return this._preferredVersion;
        }

        public String getFeatureRequirement() {
            return this._featureName;
        }

        private String getString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ROOT->");
            for (String featureName : this._chain) {
                builder.append(featureName);
                builder.append("->");
            }
            builder.append(this._candidates);
            builder.append(" ");
            builder.append(this._preferredVersion);
            return builder.toString();
        }

        public String toString() {
            return this.toString;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.resolver.FeatureResolver$Chain", Chain.class, null, null);
        }
    }

    public static interface Result {
        public Set<String> getResolvedFeatures();

        public boolean hasErrors();

        public Set<String> getMissing();

        public Set<String> getNonPublicRoots();

        public Map<String, Chain> getWrongProcessTypes();

        public Map<String, Collection<Chain>> getConflicts();

        public Set<String> getUnresolvedVersionless();
    }

    public static interface Repository {
        public List<ProvisioningFeatureDefinition> getFeatures();

        public Collection<ProvisioningFeatureDefinition> getAutoFeatures();

        public ProvisioningFeatureDefinition getFeature(String var1);

        public List<String> getConfiguredTolerates(String var1);
    }

    public static interface Selector<T> {
        public boolean test(T var1);
    }
}

