/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.BootstrapLocations;
import com.ibm.ws.kernel.boot.LaunchArguments;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.LocationException;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.KernelBootstrap;
import com.ibm.ws.kernel.boot.internal.ServerLock;
import com.ibm.wsspi.kernel.embeddable.Server;
import com.ibm.wsspi.kernel.embeddable.ServerEventListener;
import com.ibm.wsspi.kernel.embeddable.ServerException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;

public class EmbeddedServerImpl
implements Server {
    protected final BootstrapConfig bootProps = new BootstrapConfig();
    protected final ServerLock testServerLock;
    protected final ServerEventListener externalListener;
    protected volatile ServerEventListener.ServerEvent lastEvent = null;
    protected final AtomicReference<StopOperation> pendingStop = new AtomicReference();
    protected final AtomicReference<StartOperation> pendingStart = new AtomicReference();
    protected final AtomicReference<ServerTask> runningServer = new AtomicReference();
    protected final ExecutorService opQueue;

    public EmbeddedServerImpl(String serverName, File userDir, File outputDir, ServerEventListener listener) {
        this(serverName, userDir, outputDir, null, listener, null, null, null);
    }

    public EmbeddedServerImpl(String serverName, File userDir, File outputDir, File logDir, ServerEventListener listener) {
        this(serverName, userDir, outputDir, logDir, listener, null, null, null);
    }

    public EmbeddedServerImpl(String serverName, File userDir, File outputDir, File logDir, ServerEventListener listener, HashMap<String, Properties> extraProductExtensions) {
        this(serverName, userDir, outputDir, logDir, listener, extraProductExtensions, null, null);
    }

    public EmbeddedServerImpl(String serverName, File userDir, File outputDir, File logDir, ServerEventListener listener, HashMap<String, Properties> extraProductExtensions, ExecutorService executor) {
        this(serverName, userDir, outputDir, logDir, listener, extraProductExtensions, executor, null);
    }

    public EmbeddedServerImpl(String serverName, File userDir, File outputDir, File logDir, ServerEventListener listener, HashMap<String, Properties> extraProductExtensions, ExecutorService executor, String workareaDirStr) {
        String logDirPath;
        this.opQueue = executor == null ? Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("EmbeddedLibertyOperation-" + t.getName());
                return t;
            }
        }) : executor;
        String userDirPath = userDir == null ? null : userDir.getAbsolutePath();
        String outputDirPath = outputDir == null ? null : outputDir.getAbsolutePath();
        String string = logDirPath = logDir == null ? null : logDir.getAbsolutePath();
        if (serverName == null) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.defaultServer"), "defaultServer"));
        }
        this.externalListener = listener;
        BootstrapLocations locations = new BootstrapLocations();
        locations.setProcessName(serverName);
        locations.setUserDir(userDirPath);
        locations.setServerDir(outputDirPath);
        locations.setLogDir(logDirPath);
        locations.setWorkAreaDir(workareaDirStr);
        this.bootProps.findLocations(locations);
        if (userDirPath != null) {
            System.setProperty("WLP_USER_DIR", userDirPath);
        }
        if (outputDirPath != null) {
            System.setProperty("WLP_OUTPUT_DIR", outputDirPath);
        }
        if (logDirPath != null) {
            System.setProperty("LOG_DIR", logDirPath);
        }
        System.clearProperty("PRODUCT_EXTENSIONS_ADDED_BY_EMBEDDER");
        if (extraProductExtensions != null) {
            StringBuffer buf = new StringBuffer();
            for (Map.Entry<String, Properties> entry : extraProductExtensions.entrySet()) {
                String name = entry.getKey();
                Properties featureProperties = entry.getValue();
                String installLocation = featureProperties.getProperty("com.ibm.websphere.productInstall");
                String productId = featureProperties.getProperty("com.ibm.websphere.productId");
                buf.append(name + "\n" + productId + "\n" + installLocation + "\n");
            }
            String embededData = buf.toString();
            System.setProperty("PRODUCT_EXTENSIONS_ADDED_BY_EMBEDDER", embededData);
        }
        this.testServerLock = ServerLock.createTestLock(this.bootProps);
    }

    @Override
    public boolean isRunning() {
        return this.testServerLock.testServerRunning();
    }

    @Override
    public Future<Server.Result> start(String ... arguments) {
        return this.start((Map<String, String>)null, arguments);
    }

    @Override
    public Future<Server.Result> start(Map<String, String> props, String ... arguments) {
        return this.opQueue.submit(new StartOperation(props, arguments));
    }

    @Override
    public Future<Server.Result> stop(String ... arguments) {
        return this.opQueue.submit(new StopOperation(arguments));
    }

    public Set<String> getServerContent(String osRequest) throws FileNotFoundException, IOException {
        ServerTask serverTask = this.runningServer.get();
        try {
            if (serverTask != null) {
                return serverTask.getServerContent(osRequest);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    public Set<String> getServerFeatures() {
        ServerTask serverTask = this.runningServer.get();
        try {
            if (serverTask != null) {
                return serverTask.getServerFeatures();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    private void fireEvent(ServerEventListener.ServerEvent.Type type, ServerException ex) {
        this.lastEvent = new ServerEventImpl(type, ex);
        ServerEventImpl event = this.lastEvent;
        if (this.externalListener != null) {
            try {
                this.externalListener.serverEvent(event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Thread createServerThread(ServerTask r) {
        Thread t = new Thread(r);
        t.setName("EmbeddedLibertyServer-" + t.getName());
        return t;
    }

    protected class ServerTask
    implements Runnable {
        protected final KernelBootstrap kernelBootstrap;

        ServerTask(KernelBootstrap bootstrap) {
            this.kernelBootstrap = bootstrap;
        }

        public boolean waitForStarted() throws InterruptedException {
            return this.kernelBootstrap.waitForStarted();
        }

        public ReturnCode shutdown() throws InterruptedException {
            return this.kernelBootstrap.shutdown();
        }

        public ReturnCode shutdown(boolean force) throws InterruptedException {
            return this.kernelBootstrap.shutdown(force);
        }

        public Set<String> getServerContent(String osRequest) throws FileNotFoundException, IOException, InterruptedException {
            return this.kernelBootstrap.getServerContent(osRequest);
        }

        public Set<String> getServerFeatures() throws InterruptedException {
            return this.kernelBootstrap.getServerFeatures();
        }

        @Override
        public void run() {
            EmbeddedServerImpl.this.fireEvent(ServerEventListener.ServerEvent.Type.STARTING, null);
            LaunchException ex = null;
            try {
                this.kernelBootstrap.go();
            }
            catch (LaunchException e) {
                ex = e;
            }
            finally {
                EmbeddedServerImpl.this.fireEvent(ServerEventListener.ServerEvent.Type.STOPPED, ex);
                EmbeddedServerImpl.this.runningServer.compareAndSet(this, null);
            }
        }
    }

    private class StartOperation
    implements Callable<Server.Result> {
        final Map<String, String> props;
        final String[] args;

        StartOperation(Map<String, String> props, String ... arguments) {
            this.props = props;
            this.args = arguments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public Server.Result call() {
            if (EmbeddedServerImpl.this.runningServer.get() != null || !EmbeddedServerImpl.this.pendingStart.compareAndSet(null, this)) {
                return new ServerResult(false, ReturnCode.REDUNDANT_ACTION_STATUS, null);
            }
            try {
                HashMap<String, String> initProps = new HashMap<String, String>(20);
                if (this.props != null && !this.props.isEmpty()) {
                    initProps.putAll(this.props);
                }
                ArrayList<String> cmdArgs = new ArrayList<String>(Arrays.asList(this.args));
                Object launchArgs = new LaunchArguments(cmdArgs, initProps);
                if (!ReturnCode.OK.equals(((LaunchArguments)launchArgs).getRc())) {
                    LaunchException le = new LaunchException("Invalid argument passed to embedded start: " + ((LaunchArguments)launchArgs).getAction(), MessageFormat.format(BootstrapConstants.messages.getString("warning.unrecognized.command"), ((LaunchArguments)launchArgs).getAction()), null, ReturnCode.BAD_ARGUMENT);
                    EmbeddedServerImpl.this.fireEvent(ServerEventListener.ServerEvent.Type.FAILED, le);
                    ServerResult serverResult = new ServerResult(false, le);
                    return serverResult;
                }
                EmbeddedServerImpl.this.bootProps.verifyProcess(BootstrapConstants.VerifyServer.EXISTS, null);
                try {
                    EmbeddedServerImpl.this.bootProps.configure(initProps);
                }
                catch (LocationException le) {
                    System.err.println(EmbeddedServerImpl.this.bootProps.printLocations(true));
                    EmbeddedServerImpl.this.fireEvent(ServerEventListener.ServerEvent.Type.FAILED, le);
                    launchArgs = new ServerResult(false, ReturnCode.LOCATION_EXCEPTION, le);
                    EmbeddedServerImpl.this.pendingStart.set(null);
                    return launchArgs;
                }
                catch (LaunchException le) {
                    System.err.println(EmbeddedServerImpl.this.bootProps.printLocations(true));
                    EmbeddedServerImpl.this.fireEvent(ServerEventListener.ServerEvent.Type.FAILED, le);
                    launchArgs = new ServerResult(false, le.getReturnCode(), le);
                    EmbeddedServerImpl.this.pendingStart.set(null);
                    return launchArgs;
                }
                KernelBootstrap bootstrap = new KernelBootstrap(EmbeddedServerImpl.this.bootProps);
                ServerTask serverTask = new ServerTask(bootstrap);
                if (!EmbeddedServerImpl.this.runningServer.compareAndSet(null, serverTask)) {
                    ServerResult t = new ServerResult(true, ReturnCode.REDUNDANT_ACTION_STATUS, null);
                    return t;
                }
                Object t = EmbeddedServerImpl.this.createServerThread(serverTask);
                ((Thread)t).start();
                if (serverTask.waitForStarted()) {
                    EmbeddedServerImpl.this.fireEvent(ServerEventListener.ServerEvent.Type.STARTED, null);
                    t = new ServerResult(true, ReturnCode.OK, null);
                    return t;
                }
                EmbeddedServerImpl.this.fireEvent(ServerEventListener.ServerEvent.Type.FAILED, null);
                t = new ServerResult(false, ReturnCode.ERROR_SERVER_START, null);
                return t;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                EmbeddedServerImpl.this.pendingStart.set(null);
            }
        }
    }

    private class StopOperation
    implements Callable<Server.Result> {
        private boolean isForceShutdown = false;

        StopOperation(String ... arguments) {
            List<String> cmdArgs = Arrays.asList(arguments);
            if (0 < cmdArgs.size()) {
                ListIterator<String> i = cmdArgs.listIterator();
                while (i.hasNext()) {
                    String arg = (String)i.next();
                    if (arg == null || !arg.equalsIgnoreCase("--force")) continue;
                    this.isForceShutdown = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Server.Result call() {
            if (EmbeddedServerImpl.this.runningServer.get() == null || !EmbeddedServerImpl.this.pendingStop.compareAndSet(null, this)) {
                return new ServerResult(false, ReturnCode.REDUNDANT_ACTION_STATUS, null);
            }
            try {
                ServerTask server = EmbeddedServerImpl.this.runningServer.get();
                if (server != null) {
                    ReturnCode rc = this.isForceShutdown ? server.shutdown(this.isForceShutdown) : server.shutdown();
                    ServerResult serverResult = new ServerResult(rc == ReturnCode.OK, rc, null);
                    return serverResult;
                }
                ServerResult serverResult = new ServerResult(false, ReturnCode.REDUNDANT_ACTION_STATUS, null);
                return serverResult;
            }
            catch (InterruptedException e) {
                ServerResult serverResult = new ServerResult(false, ReturnCode.SERVER_UNKNOWN_STATUS, null);
                return serverResult;
            }
            finally {
                EmbeddedServerImpl.this.pendingStop.set(null);
            }
        }
    }

    class ServerEventImpl
    implements ServerEventListener.ServerEvent {
        final ServerEventListener.ServerEvent.Type t;
        final ServerException ex;

        ServerEventImpl(ServerEventListener.ServerEvent.Type t, ServerException ex) {
            this.t = t;
            this.ex = ex;
        }

        @Override
        public Server getServer() {
            return EmbeddedServerImpl.this;
        }

        @Override
        public ServerEventListener.ServerEvent.Type getType() {
            return this.t;
        }

        @Override
        public ServerException getException() {
            return this.ex;
        }

        public String toString() {
            return "ServerEvent[" + (Object)((Object)this.t) + (this.ex == null ? "" : ", ex=" + this.ex.toString()) + "]";
        }
    }

    static class ServerResult
    implements Server.Result {
        final boolean successful;
        final ReturnCode rc;
        final ServerException srvEx;

        ServerResult(boolean successful, ReturnCode rc, ServerException srvEx) {
            this.successful = successful;
            this.rc = rc;
            this.srvEx = srvEx;
        }

        ServerResult(boolean successful, LaunchException srvEx) {
            this.successful = successful;
            this.rc = srvEx.getReturnCode();
            this.srvEx = srvEx;
        }

        ServerResult(boolean successful, ServerEventListener.ServerEvent event) {
            this.successful = successful;
            this.srvEx = event.getException();
            this.rc = this.srvEx != null ? (this.srvEx instanceof LaunchException ? ((LaunchException)this.srvEx).getReturnCode() : ReturnCode.UNKNOWN_EXCEPTION) : ReturnCode.OK;
        }

        @Override
        public boolean successful() {
            return this.successful;
        }

        @Override
        public int getReturnCode() {
            return this.rc.val;
        }

        @Override
        public ServerException getException() {
            return this.srvEx;
        }
    }
}

