/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.classloader;

import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.Shared;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassURLHelper;
import com.ibm.ws.kernel.boot.classloader.ClassLoaderHook;
import java.net.URL;

final class SharedClassCacheHook
implements ClassLoaderHook {
    private static final SharedClassHelperFactory helperFactory = Shared.getSharedClassHelperFactory();
    private final SharedClassURLHelper sharedClassURLHelper;

    static ClassLoaderHook newInstance(ClassLoader loader) {
        if (helperFactory == null) {
            return null;
        }
        try {
            return new SharedClassCacheHook(helperFactory.getURLHelper(loader));
        }
        catch (HelperAlreadyDefinedException helperAlreadyDefinedException) {
            return null;
        }
    }

    private SharedClassCacheHook(SharedClassURLHelper sharedClassHelper) {
        this.sharedClassURLHelper = sharedClassHelper;
    }

    @Override
    public byte[] loadClass(URL path, String name) {
        return this.sharedClassURLHelper.findSharedClass(path, name);
    }

    @Override
    public void storeClass(URL path, Class<?> clazz) {
        this.sharedClassURLHelper.storeSharedClass(path, clazz);
    }
}

