/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.logging.internal.DisabledFFDCService;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import com.ibm.wsspi.logprovider.FFDCFilterService;
import com.ibm.wsspi.logprovider.LogProviderConfig;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class FFDCConfigurator {
    public static final String FFDC_DIR = "ffdc";
    public static final String FFDC_FILE_NAME = "ffdc";
    public static final String FFDC_SUMMARY_FILE_NAME = "exception_summary";
    public static final String FFDC_EXTENSION = ".log";
    static final AtomicReference<LogProviderConfig> loggingConfig = new AtomicReference<Object>(null);
    static FFDCFilterService delegate = null;

    public static synchronized void init(LogProviderConfig config) {
        if (config == null) {
            throw new NullPointerException("LogProviderConfig must not be null");
        }
        if (loggingConfig.compareAndSet(null, config)) {
            delegate = config.getFfdcDelegate();
            if (delegate == null) {
                throw new NullPointerException("LogProviderConfig must provide a FFDCFilterService delegate");
            }
            delegate.init(config);
        }
    }

    public static synchronized void update(Map<String, Object> newConfig) {
        if (newConfig == null) {
            throw new NullPointerException("Updated config must not be null");
        }
        LogProviderConfig config = loggingConfig.get();
        if (config != null) {
            config.update(newConfig);
            FFDCConfigurator.getDelegate().update(config);
        }
    }

    public static FFDCFilterService getDelegate() {
        FFDCFilterService ffdcDelegate = delegate;
        if (ffdcDelegate != null) {
            return ffdcDelegate;
        }
        LogProviderConfig config = loggingConfig.get();
        if (config != null && (ffdcDelegate = config.getFfdcDelegate()) != null) {
            delegate = ffdcDelegate;
            return ffdcDelegate;
        }
        return DisabledDelegateSingleton.instance;
    }

    public static synchronized void stop() {
        FFDCFilterService service = FFDCConfigurator.getDelegate();
        if (service != null) {
            service.stop();
        }
    }

    public static File getFFDCLocation() {
        LogProviderConfig cfg = loggingConfig.get();
        if (cfg == null) {
            throw new IllegalStateException("FFDC not initialized");
        }
        return FFDCConfigurator.getDelegate().getFFDCLogLocation();
    }

    public static TextFileOutputStreamFactory getFileOutputStreamFactory() {
        LogProviderConfig cfg = loggingConfig.get();
        if (cfg == null) {
            throw new IllegalStateException("FFDC not initialized");
        }
        return cfg.getTextFileOutputStreamFactory();
    }

    static class DisabledDelegateSingleton {
        static DisabledFFDCService instance = new DisabledFFDCService();

        DisabledDelegateSingleton() {
        }
    }
}

