/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.ProgressBar;
import com.ibm.ws.repository.connections.DirectoryRepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.connections.RestRepositoryConnection;
import com.ibm.ws.repository.connections.ZipRepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.fusesource.jansi.AnsiConsole;

public class InstallLogUtils {
    public static Logger getInstallLogger() {
        return Logger.getLogger("com.ibm.ws.install");
    }

    public static void enableConsoleErrorLogging(boolean verbose) {
        Handler[] handlers;
        Logger logger = InstallLogUtils.getInstallLogger();
        for (Handler handler : handlers = logger.getHandlers()) {
            if (!(handler instanceof InstallKernelErrorConsoleHandler)) continue;
            return;
        }
        InstallKernelErrorConsoleHandler ch = new InstallKernelErrorConsoleHandler(verbose);
        ch.setFormatter(new SimpleFormatter());
        InstallLogUtils.getInstallLogger().addHandler(ch);
    }

    public static void enableConsoleLogging(Level logLevel, boolean verbose) {
        Handler[] handlers;
        Logger logger = InstallLogUtils.getInstallLogger();
        for (Handler handler : handlers = logger.getHandlers()) {
            if (!(handler instanceof InstallKernelConsoleHandler) || handler.getLevel().equals(logLevel)) continue;
            logger.removeHandler(handler);
            break;
        }
        InstallKernelConsoleHandler ch = new InstallKernelConsoleHandler(verbose);
        ch.setLevel(logLevel);
        ch.setFormatter(new SimpleFormatter());
        InstallLogUtils.getInstallLogger().addHandler(ch);
    }

    public static void fixLogger(PrintWriter log, String fixID, String message) {
        Date d = new Date();
        String dateString = InstallUtils.getDateFormat().format(d);
        log.println("[" + dateString + "] " + fixID + " " + message);
        log.flush();
    }

    public static void logLoginInfo(RepositoryConnectionList logininfo, String logLable) {
        Logger logger = InstallLogUtils.getInstallLogger();
        if (null == logLable) {
            logLable = "";
        } else if (!logLable.isEmpty()) {
            logLable = logLable + "   ";
        }
        for (RepositoryConnection c : logininfo) {
            if (c instanceof RestRepositoryConnection) {
                String userAgent;
                String apiKey;
                RestRepositoryConnection l = (RestRepositoryConnection)c;
                String repURL = l.getRepositoryUrl();
                if (null != repURL && !repURL.isEmpty()) {
                    logger.log(Level.FINEST, logLable + "Repository URL: " + repURL);
                }
                if (null != (apiKey = l.getApiKey()) && !apiKey.isEmpty()) {
                    logger.log(Level.FINEST, logLable + "API Key: " + apiKey);
                }
                if (null == (userAgent = l.getUserAgent()) || userAgent.isEmpty()) continue;
                logger.log(Level.FINEST, logLable + "User Agent: " + userAgent);
                continue;
            }
            if (!(c instanceof DirectoryRepositoryConnection) && !(c instanceof ZipRepositoryConnection)) continue;
            logger.log(Level.FINEST, logLable + "Directory Repository: " + c.getRepositoryLocation());
        }
    }

    public static void activateProgressBar() {
        Handler[] handlers;
        Logger logger = InstallLogUtils.getInstallLogger();
        for (Handler handler : handlers = logger.getHandlers()) {
            if (handler instanceof InstallKernelConsoleHandler) {
                ((InstallKernelConsoleHandler)handler).activateProgressBar();
                continue;
            }
            if (!(handler instanceof InstallKernelErrorConsoleHandler)) continue;
            ((InstallKernelErrorConsoleHandler)handler).activateProgressBar();
        }
    }

    public static void deactivateProgressBar() {
        Handler[] handlers;
        Logger logger = InstallLogUtils.getInstallLogger();
        for (Handler handler : handlers = logger.getHandlers()) {
            if (handler instanceof InstallKernelConsoleHandler) {
                ((InstallKernelConsoleHandler)handler).deactivateProgressBar();
                continue;
            }
            if (!(handler instanceof InstallKernelErrorConsoleHandler)) continue;
            ((InstallKernelErrorConsoleHandler)handler).deactivateProgressBar();
        }
    }

    static class InstallKernelErrorConsoleHandler
    extends Handler {
        private final boolean verbose;
        private boolean progressBarActive = false;

        public InstallKernelErrorConsoleHandler() {
            this(false);
        }

        public InstallKernelErrorConsoleHandler(boolean verbose) {
            this.verbose = verbose;
            super.setLevel(Level.SEVERE);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                this.logToErrStream(record);
            }
        }

        private void logToErrStream(LogRecord record) {
            Throwable t;
            String strDate;
            String string = strDate = this.verbose ? DataFormatHelper.formatCurrentTime() : "";
            if (null != record.getMessage()) {
                if (this.progressBarActive) {
                    ProgressBar.getInstance().clearProgress();
                    AnsiConsole.err().println(strDate + this.getFormatter().formatMessage(record));
                } else {
                    System.err.println(strDate + this.getFormatter().formatMessage(record));
                }
            }
            if (null != (t = record.getThrown()) && this.verbose) {
                String failingConnection = this.getFailingConnection(t);
                if (failingConnection != null) {
                    System.err.println(strDate + "The following exception was related to the repository " + failingConnection);
                }
                t.printStackTrace(System.err);
            }
            System.err.flush();
        }

        private String getFailingConnection(Throwable t) {
            RepositoryConnection fc;
            RepositoryBackendException rbe = null;
            if (t instanceof RepositoryBackendException) {
                rbe = (RepositoryBackendException)t;
            } else {
                Throwable c = t.getCause();
                if (c != null && c instanceof RepositoryBackendException) {
                    rbe = (RepositoryBackendException)c;
                }
            }
            if (rbe != null && (fc = rbe.getFailingConnection()) != null) {
                return fc.getRepositoryLocation();
            }
            return null;
        }

        @Override
        public void close() {
            this.flush();
        }

        @Override
        public void flush() {
            System.err.flush();
        }

        @Override
        public synchronized void setLevel(Level newLevel) throws SecurityException {
        }

        public void activateProgressBar() {
            this.progressBarActive = true;
        }

        public void deactivateProgressBar() {
            this.progressBarActive = false;
        }
    }

    static class InstallKernelConsoleHandler
    extends Handler {
        private final boolean verbose;
        private boolean progressBarActive = false;

        public InstallKernelConsoleHandler() {
            this(false);
        }

        public InstallKernelConsoleHandler(boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public synchronized void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                this.logToOutStream(record);
            }
        }

        private void logToOutStream(LogRecord record) {
            String strDate;
            String string = strDate = this.verbose ? DataFormatHelper.formatCurrentTime() : "";
            if (null != record.getMessage()) {
                if (this.progressBarActive) {
                    ProgressBar.getInstance().clearProgress();
                    System.out.println(strDate + this.getFormatter().formatMessage(record));
                    ProgressBar.getInstance().display();
                } else {
                    System.out.println(strDate + this.getFormatter().formatMessage(record));
                }
            }
            System.out.flush();
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return super.isLoggable(record) && !record.getLevel().equals(Level.SEVERE);
        }

        @Override
        public void close() {
            this.flush();
        }

        @Override
        public void flush() {
            System.out.flush();
        }

        void activateProgressBar() {
            this.progressBarActive = true;
        }

        void deactivateProgressBar() {
            this.progressBarActive = false;
        }
    }

    public static enum Messages {
        INSTALL_KERNEL_MESSAGES("com.ibm.ws.install.internal.resources.InstallKernel"),
        UTILITY_MESSAGES("com.ibm.ws.product.utility.resources.UtilityMessages"),
        PROVISIONER_MESSAGES("com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages"),
        SELF_EXTRACTOR_MESSAGES("wlp.lib.extract.SelfExtractMessages"),
        PASSWORD_UTIL_MESSAGES("com.ibm.ws.crypto.util.internal.resources.Messages");

        private static final String explanationTag = ".explanation";
        private static final String useractionTag = ".useraction";
        private static Locale locale;
        private final String resourceBunbleName;
        private ResourceBundle messages;

        private Messages(String name) {
            this.resourceBunbleName = name;
            this.messages = null;
        }

        public String getMessage(String key, Object ... args) {
            this.initResourceBundle();
            String message = this.messages.getString(key);
            if (args.length > 0) {
                message = new MessageFormat(message, locale).format(args);
            }
            return message;
        }

        public String getLogMessage(String key, Object ... args) {
            StringBuilder logMessage = new StringBuilder(this.getMessage(key, args));
            if (this.messages.containsKey(key.concat(explanationTag))) {
                logMessage.append(InstallUtils.NEWLINE);
                logMessage.append(this.messages.getString(key.concat(explanationTag)));
            }
            if (this.messages.containsKey(key.concat(useractionTag))) {
                logMessage.append(InstallUtils.NEWLINE);
                logMessage.append(this.messages.getString(key.concat(useractionTag)));
            }
            return logMessage.toString();
        }

        private void initResourceBundle() {
            if (this.messages == null) {
                this.messages = ResourceBundle.getBundle(this.resourceBunbleName, locale);
            } else if (!locale.equals(this.messages.getLocale())) {
                this.messages = ResourceBundle.getBundle(this.resourceBunbleName, locale);
            }
        }

        public static void setLocale(Locale locale) {
            if (locale != null && !Messages.locale.equals(locale)) {
                Messages.locale = locale;
            }
        }

        static {
            locale = Locale.getDefault();
        }
    }
}

