/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigUtil {
    private static final TraceComponent tc = Tr.register(ConfigUtil.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    static final long serialVersionUID = 1788124975690671635L;

    ConfigUtil() {
    }

    @FFDCIgnore(value={Throwable.class})
    public static void closeIO(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean exists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -3133309549088362536L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ConfigUtil$1", 1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        });
    }

    public static void delete(final File file) {
        boolean success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -1364545652795303377L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.delete();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ConfigUtil$2", 2.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        });
        if (!success && tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"warn.file.delete.failed", (Object[])new Object[]{file});
        }
    }

    public static void mkdirs(final File file) {
        boolean success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 7233209210368763473L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.mkdirs();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ConfigUtil$3", 3.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        });
        if (!success && tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"warn.file.mkdirs.failed", (Object[])new Object[]{file});
        }
    }

    public static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 8187653322482208193L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(name);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ConfigUtil$4", 4.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        });
    }
}

