/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant.jsp;

import io.openliberty.tools.ant.ServerTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.War;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ZipFileSet;

public class CompileJSPs
extends Task {
    private File wlpHome;
    private File war;
    private String ref;
    private List<String> features = new ArrayList<String>();
    private String featureVersion = "2.3";
    private boolean cleanup = true;
    private File srcdir;
    private File tmpdir;
    private File destdir;
    private String classpath = "";
    private String classpathRef;
    private String source;
    private int timeout = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        block17: {
            this.validate();
            try {
                File compileDir;
                if (this.tmpdir == null) {
                    compileDir = File.createTempFile("compileJsp", "");
                    compileDir.delete();
                } else {
                    compileDir = new File(this.tmpdir, "compileJsp");
                }
                try {
                    File serverDir = new File(compileDir, "servers/defaultServer/");
                    String warSuffix = this.war == null ? "fake" : this.trimExtension(this.war.getName());
                    File jspCompileDir = new File(serverDir, "jsps/default_node/SMF_WebContainer/jspCompile/" + warSuffix);
                    if (jspCompileDir.exists()) {
                        this.delete(jspCompileDir);
                    }
                    if (serverDir.exists() || serverDir.mkdirs()) {
                        this.writeServerXML(serverDir);
                        this.createAppXML(serverDir);
                        ServerTask server = this.createServerTask(compileDir);
                        server.setOperation("start");
                        server.execute();
                        boolean compileSuccess = false;
                        try {
                            this.checkFeaturesExist(serverDir);
                            compileSuccess = this.waitForCompilation(serverDir, jspCompileDir, this.war);
                        }
                        finally {
                            server.setOperation("stop");
                            server.execute();
                        }
                        if (compileSuccess) {
                            if (this.war != null) {
                                this.updateSourceWar(jspCompileDir);
                            } else {
                                this.copyClassFiles(jspCompileDir);
                            }
                            break block17;
                        }
                        this.printCompileErrors(new File(serverDir, "logs/console.log"));
                        throw new BuildException("JSP compile failed");
                    }
                    throw new BuildException("Unable to create folder for usr dir");
                }
                finally {
                    if (this.cleanup) {
                        this.delete(compileDir);
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException("A failure occurred: " + e.toString(), (Throwable)e);
            }
        }
    }

    private void copyClassFiles(File jspCompileDir) {
        Copy copy = new Copy();
        copy.setProject(this.getProject());
        copy.setTaskName(this.getTaskName());
        this.destdir.mkdirs();
        copy.setTodir(this.destdir);
        FileSet files = new FileSet();
        files.setDir(jspCompileDir);
        files.setIncludes("**/*.class");
        copy.addFileset(files);
        copy.execute();
    }

    private void updateSourceWar(File jspCompileDir) {
        War warTask = new War();
        warTask.setProject(this.getProject());
        warTask.setDestFile(this.war);
        warTask.setUpdate(true);
        ZipFileSet jspFiles = new ZipFileSet();
        jspFiles.setDir(jspCompileDir);
        warTask.addClasses(jspFiles);
        warTask.setTaskName(this.getTaskName());
        warTask.execute();
    }

    private void validate() {
        if (this.war == null && this.srcdir == null) {
            throw new BuildException("One of war or srcdir must be specified");
        }
        if (this.srcdir != null && this.destdir == null) {
            throw new BuildException("The destdir must be specified");
        }
        if (this.wlpHome == null) {
            throw new BuildException("Liberty installation directory must be set");
        }
        if (this.source == null) {
            this.setSource(System.getProperty("java.specification.version"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFeaturesExist(File serverDir) {
        BufferedReader reader = null;
        boolean fail = false;
        try {
            String line;
            reader = new BufferedReader(new FileReader(new File(serverDir, "logs/console.log")));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("CWWKF0001E")) continue;
                this.log(line);
                fail = true;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (fail) {
            throw new BuildException("Features required to compile are missing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printCompileErrors(File log) {
        try (BufferedReader reader = new BufferedReader(new FileReader(log));){
            String line;
            boolean reprint = false;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("JSPG0049E") || line.startsWith("JSPG0091E") || line.startsWith("JSPG0093E")) {
                    reprint = true;
                }
                if (line.startsWith("[")) {
                    reprint = false;
                }
                if (!reprint) continue;
                this.log(line, 0);
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Unable to load compile log");
        }
    }

    private boolean waitForCompilation(File serverDir, File jspCompileDir, File war2) throws IOException {
        ArrayList<File> jsps = new ArrayList<File>();
        if (war2 != null) {
            this.fillFromWar(jsps, war2, jspCompileDir);
        } else {
            this.fillFromSource(jsps, this.srcdir, jspCompileDir);
        }
        HashSet<File> javaFiles = new HashSet<File>();
        boolean equalDetected = false;
        for (int i = 0; i < this.timeout; ++i) {
            if (jspCompileDir.exists()) {
                Iterator it = jsps.iterator();
                while (it.hasNext()) {
                    File classFile = (File)it.next();
                    if (classFile.exists()) {
                        it.remove();
                        equalDetected = false;
                    }
                    String classFileName = classFile.getName();
                    String javaFileName = classFileName.substring(0, classFileName.length() - 6) + ".java";
                    File javaFile = new File(classFile.getParentFile(), javaFileName);
                    if (javaFile.exists()) {
                        if (!javaFiles.add(javaFile)) continue;
                        equalDetected = false;
                        continue;
                    }
                    if (!javaFiles.remove(javaFile)) continue;
                    equalDetected = false;
                }
            }
            if (equalDetected) break;
            boolean bl = equalDetected = jsps.size() == javaFiles.size();
            if (jsps.isEmpty()) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!jsps.isEmpty()) {
            this.log("Failed to create: " + jsps, 0);
        }
        return jsps.isEmpty();
    }

    private void fillFromSource(List<File> jsps, File srcdir2, File jspCompileDir) {
        File[] files = srcdir2.listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (file.isFile() && fileName.endsWith(".jsp")) {
                    String expectedJSPName = this.jspToClassFileName(fileName);
                    jsps.add(new File(jspCompileDir, expectedJSPName));
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.fillFromSource(jsps, file, new File(jspCompileDir, file.getName()));
            }
        }
    }

    private String jspToClassFileName(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append('_');
        char[] chars = name.toCharArray();
        for (int i = 0; i < name.length() - 4; ++i) {
            char c = chars[i];
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
            sb.append(Integer.toHexString(c).toUpperCase());
            sb.append('_');
        }
        sb.append(".class");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillFromWar(List<File> jsps, File war2, File jspCompileDir) {
        ZipInputStream zipIn = null;
        try {
            ZipEntry entry;
            zipIn = new ZipInputStream(new FileInputStream(war2));
            while ((entry = zipIn.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (!entryName.endsWith(".jsp")) continue;
                String expectedJSPName = this.jspToClassFileName(entryName);
                jsps.add(new File(jspCompileDir, expectedJSPName));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipIn != null) {
                try {
                    zipIn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ServerTask createServerTask(File usrDir) {
        ServerTask server = new ServerTask();
        server.setProject(this.getProject());
        server.setRef(this.ref);
        server.setInstallDir(this.wlpHome);
        server.setUserDir(usrDir);
        server.setTaskName(this.getTaskName());
        return server;
    }

    private void writeServerXML(File serverDir) throws FileNotFoundException {
        PrintStream ps = new PrintStream(new File(serverDir, "server.xml"));
        ps.println("<server>");
        ps.println("<featureManager>");
        for (String feature : this.features) {
            ps.print("<feature>");
            ps.print(feature);
            ps.println("</feature>");
        }
        ps.print("<feature>jsp-");
        ps.print(this.featureVersion);
        ps.println("</feature>");
        ps.println("</featureManager>");
        if (this.war != null) {
            ps.println("<webApplication name=\"jspCompile\" location=\"" + this.war.getAbsolutePath() + "\"/>");
        } else {
            ps.println("<webApplication name=\"jspCompile\" location=\"fake.war\"/>");
        }
        ps.println("<httpEndpoint id=\"defaultHttpEndpoint\" host=\"localhost\" httpPort=\"0\"/>");
        ps.print("<jspEngine prepareJsps=\"0\" scratchdir=\"" + serverDir.getAbsolutePath() + "/jsps\" jdkSourceLevel=\"" + this.source + "\"/>");
        ps.println("<webContainer deferServletLoad=\"false\"/>");
        ps.println("<keyStore password=\"dummyKeystore\"/>");
        ps.println("</server>");
        ps.close();
    }

    private void createAppXML(File serverDir) throws FileNotFoundException {
        if (this.srcdir != null) {
            String[] cp;
            File appsDir = new File(serverDir, "apps");
            appsDir.mkdirs();
            PrintStream ps = new PrintStream(new File(appsDir, "fake.war.xml"));
            ps.println("<archive>");
            ps.println("  <dir targetInArchive=\"/\" sourceOnDisk=\"" + this.srcdir.getAbsolutePath() + "\"/>");
            Path p = new Path(this.getProject(), this.classpath);
            if (this.classpathRef != null) {
                Path path = (Path)this.getProject().getReference(this.classpathRef);
                p.add(path);
            }
            for (String entry : cp = p.toString().split(File.pathSeparator)) {
                File f = new File(entry);
                String basename = f.getName();
                if (f.isFile() && f.exists() && f.getName().endsWith(".jar")) {
                    ps.println("  <file targetInArchive=\"/WEB-INF/lib/" + basename + "\" sourceOnDisk=\"" + f.getAbsolutePath() + "\"/>");
                    continue;
                }
                if (!f.isDirectory() || !f.exists()) continue;
                ps.println("  <dir targetInArchive=\"/WEB-INF/classes\" sourceOnDisk=\"" + f.getAbsolutePath() + "\"/>");
            }
            ps.println("</archive>");
            ps.close();
        }
    }

    private String trimExtension(String name) {
        if (name.endsWith(".war")) {
            return name.substring(0, name.length() - 4);
        }
        return name;
    }

    private void delete(File f) {
        if (f.isFile()) {
            f.delete();
        } else if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.delete(file);
                }
            }
            f.delete();
        }
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public void setInstallDir(File home) {
        this.wlpHome = home;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setWar(File war) {
        this.war = war;
    }

    public void setFeatures(String features) {
        String[] featuresArray = features.split(",");
        this.features.addAll(Arrays.asList(featuresArray));
    }

    public void setJspVersion(String version) {
        this.featureVersion = version;
    }

    public void setSrcdir(File srcdir) {
        this.srcdir = srcdir;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setTempdir(File tmpdir) {
        this.tmpdir = tmpdir;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setClasspathRef(String classpathRef) {
        this.classpathRef = classpathRef;
    }

    public void setSource(String src) {
        if ("1.3".equals(src)) {
            this.source = "13";
        } else if ("1.4".equals(src)) {
            this.source = "14";
        } else if ("1.5".equals(src) || "5".equals(src)) {
            this.source = "15";
        } else if ("1.6".equals(src) || "6".equals(src)) {
            this.source = "16";
        } else if ("1.7".equals(src) || "7".equals(src)) {
            this.source = "17";
        } else if ("1.8".equals(src) || "8".equals(src)) {
            this.source = "18";
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

