/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.jdk.internal;

import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.sender.jdk.internal.BodyPublisher;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.ProxyOptions;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;

public final class JdkHttpSender
implements HttpSender {
    private static final Set<Integer> retryableStatusCodes = Set.of(Integer.valueOf(429), Integer.valueOf(502), Integer.valueOf(503), Integer.valueOf(504));
    private static final ThreadLocal<NoCopyByteArrayOutputStream> threadLocalBaos = ThreadLocal.withInitial(NoCopyByteArrayOutputStream::new);
    private static final ThreadLocal<ByteBufferPool> threadLocalByteBufPool = ThreadLocal.withInitial(() -> new ByteBufferPool());
    private final ExecutorService executorService = Executors.newFixedThreadPool(5);
    private final HttpClient client;
    private final URI uri;
    @Nullable
    private final Compressor compressor;
    private final boolean exportAsJson;
    private final String contentType;
    private final long timeoutNanos;
    private final Supplier<Map<String, List<String>>> headerSupplier;
    @Nullable
    private final RetryPolicy retryPolicy;

    JdkHttpSender(HttpClient client, String endpoint, @Nullable Compressor compressor, boolean exportAsJson, String contentType, long timeoutNanos, Supplier<Map<String, List<String>>> headerSupplier, @Nullable RetryPolicy retryPolicy) {
        this.client = client;
        try {
            this.uri = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.compressor = compressor;
        this.exportAsJson = exportAsJson;
        this.contentType = contentType;
        this.timeoutNanos = timeoutNanos;
        this.headerSupplier = headerSupplier;
        this.retryPolicy = retryPolicy;
    }

    JdkHttpSender(String endpoint, @Nullable Compressor compressor, boolean exportAsJson, String contentType, long timeoutNanos, long connectTimeoutNanos, Supplier<Map<String, List<String>>> headerSupplier, @Nullable RetryPolicy retryPolicy, @Nullable ProxyOptions proxyOptions, @Nullable SSLContext sslContext) {
        this(JdkHttpSender.configureClient(sslContext, connectTimeoutNanos, proxyOptions), endpoint, compressor, exportAsJson, contentType, timeoutNanos, headerSupplier, retryPolicy);
    }

    private static HttpClient configureClient(@Nullable SSLContext sslContext, long connectionTimeoutNanos, @Nullable ProxyOptions proxyOptions) {
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(Duration.ofNanos(connectionTimeoutNanos));
        if (sslContext != null) {
            builder.sslContext(sslContext);
        }
        if (proxyOptions != null) {
            builder.proxy(proxyOptions.getProxySelector());
        }
        return builder.build();
    }

    public void send(Marshaler marshaler, int contentLength, Consumer<HttpSender.Response> onResponse, Consumer<Throwable> onError) {
        CompletionStage unused = CompletableFuture.supplyAsync(() -> {
            try {
                return this.sendInternal(marshaler);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, this.executorService).whenComplete((httpResponse, throwable) -> {
            if (throwable != null) {
                onError.accept((Throwable)throwable);
                return;
            }
            onResponse.accept(JdkHttpSender.toHttpResponse(httpResponse));
        });
    }

    HttpResponse<byte[]> sendInternal(Marshaler marshaler) throws IOException {
        NoCopyByteArrayOutputStream os;
        HttpRequest.Builder requestBuilder;
        long startTimeNanos;
        block19: {
            startTimeNanos = System.nanoTime();
            requestBuilder = HttpRequest.newBuilder().uri(this.uri).timeout(Duration.ofNanos(this.timeoutNanos));
            Map<String, List<String>> headers = this.headerSupplier.get();
            if (headers != null) {
                headers.forEach((key, values) -> values.forEach(value -> requestBuilder.header((String)key, (String)value)));
            }
            requestBuilder.header("Content-Type", this.contentType);
            os = threadLocalBaos.get();
            os.reset();
            if (this.compressor != null) {
                requestBuilder.header("Content-Encoding", this.compressor.getEncoding());
                try (OutputStream compressed = this.compressor.compress((OutputStream)os);){
                    this.write(marshaler, compressed);
                    break block19;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.write(marshaler, os);
        }
        ByteBufferPool byteBufferPool = threadLocalByteBufPool.get();
        requestBuilder.POST(new BodyPublisher(os.buf(), os.size(), () -> byteBufferPool.getBuffer()));
        if (this.retryPolicy == null) {
            return this.sendRequest(requestBuilder, byteBufferPool);
        }
        long attempt = 0L;
        long nextBackoffNanos = this.retryPolicy.getInitialBackoff().toNanos();
        HttpResponse<byte[]> httpResponse = null;
        IOException exception = null;
        do {
            if (attempt > 0L) {
                long upperBoundNanos = Math.min(nextBackoffNanos, this.retryPolicy.getMaxBackoff().toNanos());
                long backoffNanos = ThreadLocalRandom.current().nextLong(upperBoundNanos);
                nextBackoffNanos = (long)((double)nextBackoffNanos * this.retryPolicy.getBackoffMultiplier());
                try {
                    TimeUnit.NANOSECONDS.sleep(backoffNanos);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if (System.nanoTime() - startTimeNanos >= this.timeoutNanos) break;
            }
            ++attempt;
            requestBuilder.timeout(Duration.ofNanos(this.timeoutNanos - (System.nanoTime() - startTimeNanos)));
            try {
                httpResponse = this.sendRequest(requestBuilder, byteBufferPool);
            }
            catch (IOException e) {
                exception = e;
            }
            if (httpResponse != null && !retryableStatusCodes.contains(httpResponse.statusCode())) {
                return httpResponse;
            }
            if (exception == null || JdkHttpSender.isRetryableException(exception)) continue;
            throw exception;
        } while (attempt < (long)this.retryPolicy.getMaxAttempts());
        if (httpResponse != null) {
            return httpResponse;
        }
        throw exception;
    }

    private void write(Marshaler marshaler, OutputStream os) throws IOException {
        if (this.exportAsJson) {
            marshaler.writeJsonTo(os);
        } else {
            marshaler.writeBinaryTo(os);
        }
    }

    private HttpResponse<byte[]> sendRequest(HttpRequest.Builder requestBuilder, ByteBufferPool byteBufferPool) throws IOException {
        try {
            HttpResponse<byte[]> httpResponse = this.client.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofByteArray());
            return httpResponse;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        finally {
            byteBufferPool.resetPool();
        }
    }

    private static boolean isRetryableException(IOException throwable) {
        return !(throwable instanceof SSLException);
    }

    private static HttpSender.Response toHttpResponse(final HttpResponse<byte[]> response) {
        return new HttpSender.Response(){

            public int statusCode() {
                return response.statusCode();
            }

            public String statusMessage() {
                return String.valueOf(response.statusCode());
            }

            public byte[] responseBody() {
                return (byte[])response.body();
            }
        };
    }

    public CompletableResultCode shutdown() {
        this.executorService.shutdown();
        return CompletableResultCode.ofSuccess();
    }

    private static class NoCopyByteArrayOutputStream
    extends ByteArrayOutputStream {
        NoCopyByteArrayOutputStream() {
            super(retryableStatusCodes.size());
        }

        private byte[] buf() {
            return this.buf;
        }
    }

    private static class ByteBufferPool {
        private static final int BUF_SIZE = 16384;
        private final ConcurrentLinkedQueue<ByteBuffer> pool = new ConcurrentLinkedQueue();
        private final ConcurrentLinkedQueue<ByteBuffer> out = new ConcurrentLinkedQueue();

        private ByteBufferPool() {
        }

        private ByteBuffer getBuffer() {
            ByteBuffer buffer = this.pool.poll();
            if (buffer == null) {
                buffer = ByteBuffer.allocate(16384);
            }
            this.out.offer(buffer);
            return buffer;
        }

        private void resetPool() {
            ByteBuffer buf = this.out.poll();
            while (buf != null) {
                this.pool.offer(buf);
                buf = this.out.poll();
            }
        }
    }
}

