/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.EnvironmentResource;
import io.opentelemetry.sdk.autoconfigure.MetricExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.PropagatorConfiguration;
import io.opentelemetry.sdk.autoconfigure.TracerProviderConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.SdkMeterProviderConfigurer;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import java.util.HashSet;
import java.util.ServiceLoader;

public final class OpenTelemetrySdkAutoConfiguration {
    private static final Resource RESOURCE = OpenTelemetrySdkAutoConfiguration.buildResource();

    public static Resource getResource() {
        return RESOURCE;
    }

    public static OpenTelemetrySdk initialize() {
        ConfigProperties config = ConfigProperties.get();
        ContextPropagators propagators = PropagatorConfiguration.configurePropagators(config);
        Resource resource = OpenTelemetrySdkAutoConfiguration.getResource();
        OpenTelemetrySdkAutoConfiguration.configureMeterProvider(resource, config);
        SdkTracerProvider tracerProvider = TracerProviderConfiguration.configureTracerProvider(resource, config);
        return OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(propagators).buildAndRegisterGlobal();
    }

    private static void configureMeterProvider(Resource resource, ConfigProperties config) {
        SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder().setResource(resource);
        for (SdkMeterProviderConfigurer configurer : ServiceLoader.load(SdkMeterProviderConfigurer.class)) {
            configurer.configure(meterProviderBuilder);
        }
        SdkMeterProvider meterProvider = meterProviderBuilder.buildAndRegisterGlobal();
        String exporterName = config.getString("otel.metrics.exporter");
        if (exporterName == null) {
            exporterName = "otlp";
        }
        MetricExporterConfiguration.configureExporter(exporterName, config, meterProvider);
    }

    private static Resource buildResource() {
        ConfigProperties config = ConfigProperties.get();
        Resource result = Resource.getDefault();
        HashSet<String> disabledProviders = new HashSet<String>(config.getCommaSeparatedValues("otel.java.disabled.resource.providers"));
        for (ResourceProvider resourceProvider : ServiceLoader.load(ResourceProvider.class)) {
            if (disabledProviders.contains(resourceProvider.getClass().getName())) continue;
            result = result.merge(resourceProvider.createResource(config));
        }
        result = result.merge(EnvironmentResource.create(config));
        return result;
    }

    private OpenTelemetrySdkAutoConfiguration() {
    }
}

