/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.baggage.BaggageField;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.opentracing.SpanContext;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class BraveSpanContext
implements SpanContext {
    public abstract TraceContext unwrap();

    public abstract Iterable<Map.Entry<String, String>> baggageItems();

    static BraveSpanContext create(TraceContext context) {
        return new Complete(context);
    }

    static BraveSpanContext create(TraceContextOrSamplingFlags extractionResult) {
        return extractionResult.context() != null ? new Complete(extractionResult.context()) : new Incomplete(extractionResult);
    }

    BraveSpanContext() {
    }

    static final class Complete
    extends BraveSpanContext {
        final TraceContext context;

        Complete(TraceContext context) {
            this.context = context;
        }

        @Override
        public TraceContext unwrap() {
            return this.context;
        }

        public String toTraceId() {
            return this.context.traceIdString();
        }

        public String toSpanId() {
            return this.context.spanIdString();
        }

        @Override
        public Iterable<Map.Entry<String, String>> baggageItems() {
            return BaggageItems.CONTEXT.baggageItems(this.context);
        }
    }

    static final class Incomplete
    extends BraveSpanContext {
        final TraceContextOrSamplingFlags extractionResult;

        Incomplete(TraceContextOrSamplingFlags extractionResult) {
            this.extractionResult = extractionResult;
        }

        TraceContextOrSamplingFlags extractionResult() {
            return this.extractionResult;
        }

        @Override
        public TraceContext unwrap() {
            return this.extractionResult.context();
        }

        public String toTraceId() {
            TraceContext context = this.extractionResult.context();
            return context != null ? context.traceIdString() : null;
        }

        public String toSpanId() {
            TraceContext context = this.extractionResult.context();
            return context != null ? context.spanIdString() : null;
        }

        @Override
        public Iterable<Map.Entry<String, String>> baggageItems() {
            return BaggageItems.EXTRACTION.baggageItems(this.extractionResult);
        }
    }

    static enum BaggageItems {
        CONTEXT{

            @Override
            List<BaggageField> getAll(Object input) {
                return BaggageField.getAll((TraceContext)((TraceContext)input));
            }

            @Override
            String getValue(BaggageField field, Object input) {
                return field.getValue((TraceContext)input);
            }
        }
        ,
        EXTRACTION{

            @Override
            List<BaggageField> getAll(Object input) {
                return BaggageField.getAll((TraceContextOrSamplingFlags)((TraceContextOrSamplingFlags)input));
            }

            @Override
            String getValue(BaggageField field, Object input) {
                return field.getValue((TraceContextOrSamplingFlags)input);
            }
        };


        abstract List<BaggageField> getAll(Object var1);

        @Nullable
        abstract String getValue(BaggageField var1, Object var2);

        Iterable<Map.Entry<String, String>> baggageItems(Object input) {
            List<BaggageField> fields = this.getAll(input);
            if (fields.isEmpty()) {
                return Collections.emptyList();
            }
            LinkedHashMap<String, String> baggage = new LinkedHashMap<String, String>();
            for (BaggageField field : fields) {
                String value = this.getValue(field, input);
                if (value == null) continue;
                baggage.put(field.name(), value);
            }
            return baggage.entrySet();
        }
    }
}

