/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.Session;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.opentracing.Tracer;
import io.opentracing.contrib.cassandra.GuavaCompatibilityUtil;
import io.opentracing.contrib.cassandra.TracingSession;
import io.opentracing.contrib.cassandra.nameprovider.CustomStringSpanName;
import io.opentracing.contrib.cassandra.nameprovider.QuerySpanNameProvider;
import io.opentracing.util.GlobalTracer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TracingCluster
extends Cluster {
    private final Tracer tracer;
    private final QuerySpanNameProvider querySpanNameProvider;
    private final ExecutorService executorService;

    public TracingCluster(Cluster.Initializer initializer, Tracer tracer) {
        this(initializer, tracer, CustomStringSpanName.newBuilder().build("execute"));
    }

    public TracingCluster(Cluster.Initializer initializer) {
        this(initializer, GlobalTracer.get());
    }

    public TracingCluster(Cluster.Initializer initializer, Tracer tracer, QuerySpanNameProvider querySpanNameProvider) {
        this(initializer, tracer, querySpanNameProvider, Executors.newCachedThreadPool());
    }

    public TracingCluster(Cluster.Initializer initializer, Tracer tracer, QuerySpanNameProvider querySpanNameProvider, ExecutorService executorService) {
        super(initializer);
        this.tracer = tracer;
        this.querySpanNameProvider = querySpanNameProvider;
        this.executorService = executorService;
    }

    public TracingCluster(Cluster.Initializer initializer, QuerySpanNameProvider querySpanNameProvider) {
        this(initializer, GlobalTracer.get(), querySpanNameProvider);
    }

    public Session newSession() {
        return new TracingSession(super.newSession(), this.tracer, this.querySpanNameProvider, this.executorService);
    }

    public Session connect() {
        return super.connect();
    }

    public Session connect(String keyspace) {
        return super.connect(keyspace);
    }

    public ListenableFuture<Session> connectAsync() {
        return super.connectAsync();
    }

    public ListenableFuture<Session> connectAsync(String keyspace) {
        if (GuavaCompatibilityUtil.isGuavaCompatibilityFound()) {
            return GuavaCompatibility.INSTANCE.transform(super.connectAsync(keyspace), (Function)new Function<Session, Session>(){

                public Session apply(Session session) {
                    return new TracingSession(session, TracingCluster.this.tracer, TracingCluster.this.querySpanNameProvider, TracingCluster.this.executorService);
                }
            });
        }
        return Futures.transform((ListenableFuture)super.connectAsync(keyspace), (Function)new Function<Session, Session>(){

            public Session apply(Session session) {
                return new TracingSession(session, TracingCluster.this.tracer, TracingCluster.this.querySpanNameProvider, TracingCluster.this.executorService);
            }
        });
    }
}

