/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.cassandra.nameprovider;

import io.opentracing.contrib.cassandra.nameprovider.QuerySpanNameProvider;

public class PrefixedFullQuerySpanName
implements QuerySpanNameProvider {
    private String prefix;

    PrefixedFullQuerySpanName(String prefix) {
        this.prefix = prefix == null || prefix.equals("") ? "" : prefix + ": ";
    }

    @Override
    public String querySpanName(String query) {
        if (query == null || query.equals("")) {
            return this.prefix + "N/A";
        }
        return this.prefix + query;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements QuerySpanNameProvider.Builder {
        @Override
        public QuerySpanNameProvider build() {
            return new PrefixedFullQuerySpanName("Cassandra");
        }

        public QuerySpanNameProvider build(String prefix) {
            return new PrefixedFullQuerySpanName(prefix);
        }
    }
}

