/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.client;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.client.ClientHeadersInjectTextMap;
import io.opentracing.contrib.jaxrs2.client.ClientSpanDecorator;
import io.opentracing.contrib.jaxrs2.client.TracingProperties;
import io.opentracing.contrib.jaxrs2.internal.CastUtils;
import io.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.opentracing.noop.NoopScopeManager;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.opentracing.Traced;

@Priority(value=3000)
public class ClientTracingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger log = Logger.getLogger(ClientTracingFilter.class.getName());
    private Tracer tracer;
    private List<ClientSpanDecorator> spanDecorators;

    public ClientTracingFilter(Tracer tracer, List<ClientSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<ClientSpanDecorator>(spanDecorators);
    }

    public void filter(ClientRequestContext requestContext) {
        if (this.tracingDisabled(requestContext)) {
            log.finest("Client tracing disabled");
            return;
        }
        if (requestContext.getProperty(SpanWrapper.PROPERTY_NAME) != null) {
            return;
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(requestContext.getMethod()).withTag(Tags.SPAN_KIND.getKey(), "client");
        SpanContext parentSpanContext = CastUtils.cast(requestContext.getProperty(TracingProperties.CHILD_OF), SpanContext.class);
        if (parentSpanContext != null) {
            spanBuilder.ignoreActiveSpan().asChildOf(parentSpanContext);
        }
        final Span span = spanBuilder.start();
        if (this.spanDecorators != null) {
            for (ClientSpanDecorator decorator : this.spanDecorators) {
                decorator.decorateRequest(requestContext, span);
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Starting client span");
        }
        this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new ClientHeadersInjectTextMap((MultivaluedMap<String, Object>)requestContext.getHeaders()));
        requestContext.setProperty(SpanWrapper.PROPERTY_NAME, (Object)new SpanWrapper(span, (Scope)new NoopScopeManager.NoopScope(){

            public void close() {
            }

            public Span span() {
                return span;
            }
        }));
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        SpanWrapper spanWrapper = CastUtils.cast(requestContext.getProperty(SpanWrapper.PROPERTY_NAME), SpanWrapper.class);
        if (spanWrapper != null && !spanWrapper.isFinished()) {
            log.finest("Finishing client span");
            if (this.spanDecorators != null) {
                for (ClientSpanDecorator decorator : this.spanDecorators) {
                    decorator.decorateResponse(responseContext, spanWrapper.get());
                }
            }
            spanWrapper.finish();
        }
    }

    private boolean tracingDisabled(ClientRequestContext clientRequestContext) {
        Boolean tracingDisabled = CastUtils.cast(clientRequestContext.getProperty(TracingProperties.TRACING_DISABLED), Boolean.class);
        if (tracingDisabled != null && tracingDisabled.booleanValue()) {
            return true;
        }
        Object invokedMethod = clientRequestContext.getProperty("org.eclipse.microprofile.rest.client.invokedMethod");
        if (invokedMethod == null) {
            return false;
        }
        Method method = (Method)invokedMethod;
        Traced traced = method.getAnnotation(Traced.class);
        return traced != null && !traced.value();
    }
}

