/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ServerAddress;
import com.mongodb.event.CommandListener;
import io.opentracing.contrib.mongo.common.TracingCommandListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TracingMongoClient
extends MongoClient {
    public TracingMongoClient(TracingCommandListener listener) {
        this(listener, new ServerAddress());
    }

    public TracingMongoClient(TracingCommandListener listener, String host) {
        this(listener, new ServerAddress(host));
    }

    public TracingMongoClient(TracingCommandListener listener, String host, MongoClientOptions options) {
        this(listener, new ServerAddress(host), options);
    }

    public TracingMongoClient(TracingCommandListener listener, String host, int port) {
        this(listener, new ServerAddress(host, port));
    }

    public TracingMongoClient(TracingCommandListener listener, ServerAddress addr) {
        this(listener, addr, new MongoClientOptions.Builder().build());
    }

    public TracingMongoClient(TracingCommandListener listener, ServerAddress addr, List<MongoCredential> credentialsList) {
        this(listener, addr, credentialsList, new MongoClientOptions.Builder().build());
    }

    public TracingMongoClient(TracingCommandListener listener, ServerAddress addr, MongoClientOptions options) {
        super(addr, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public TracingMongoClient(TracingCommandListener listener, ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(addr, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public TracingMongoClient(TracingCommandListener listener, ServerAddress addr, MongoCredential credential, MongoClientOptions options) {
        super(addr, credential, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public TracingMongoClient(TracingCommandListener listener, List<ServerAddress> seeds) {
        this(listener, seeds, new MongoClientOptions.Builder().build());
    }

    public TracingMongoClient(TracingCommandListener listener, List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this(listener, seeds, credentialsList, new MongoClientOptions.Builder().build());
    }

    public TracingMongoClient(TracingCommandListener listener, List<ServerAddress> seeds, MongoClientOptions options) {
        super(seeds, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public TracingMongoClient(TracingCommandListener listener, List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(seeds, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public TracingMongoClient(TracingCommandListener listener, List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options) {
        super(seeds, credential, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public TracingMongoClient(TracingCommandListener listener, MongoClientURI uri) {
        this(listener, uri, null);
    }

    public TracingMongoClient(TracingCommandListener listener, List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(seeds, credential, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build(), mongoDriverInformation);
    }

    public TracingMongoClient(TracingCommandListener listener, MongoClientURI uri, MongoDriverInformation mongoDriverInformation) {
        this(listener, TracingMongoClient.toServerAddressList(uri.getHosts()), uri.getCredentials() != null ? Collections.singletonList(uri.getCredentials()) : Collections.emptyList(), uri.getOptions(), mongoDriverInformation);
    }

    public TracingMongoClient(TracingCommandListener listener, ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(addr, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build(), mongoDriverInformation);
    }

    public TracingMongoClient(TracingCommandListener listener, List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(seeds, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build(), mongoDriverInformation);
    }

    private static List<ServerAddress> toServerAddressList(List<String> hosts) {
        ArrayList<ServerAddress> list = new ArrayList<ServerAddress>();
        for (String host : hosts) {
            list.add(new ServerAddress(host));
        }
        return list;
    }
}

