/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.gateway;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.gateway.AbstractHttpHeadersFilter;
import io.opentracing.contrib.spring.web.client.HttpHeadersCarrier;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

final class TraceRequestHttpHeadersFilter
extends AbstractHttpHeadersFilter {
    private final Logger log = LoggerFactory.getLogger(TraceRequestHttpHeadersFilter.class);
    private static final String ROUTE_ID = "route.id";
    private static final String COMPONENT = "java-spring-cloud-gateway";

    protected TraceRequestHttpHeadersFilter(Tracer tracer) {
        super(tracer);
    }

    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        this.log.debug("Will instrument spring cloud gateway the HTTP request headers");
        ServerHttpRequest.Builder builder = exchange.getRequest().mutate();
        Span span = this.tracer.buildSpan(this.path(builder)).asChildOf(this.tracer.activeSpan()).withTag(Tags.COMPONENT.getKey(), COMPONENT).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(ROUTE_ID, this.getRouteId(exchange)).start();
        this.log.debug("Client span {} created for the request. New headers are {}", (Object)span, (Object)builder.build().getHeaders().toSingleValueMap());
        exchange.getAttributes().put(SPAN_ATTRIBUTE, span);
        HttpHeaders headersWithInput = new HttpHeaders();
        try {
            this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersCarrier(headersWithInput));
        }
        catch (Exception ignore) {
            this.log.error("TraceRequestHttpHeadersFilter error", (Throwable)ignore);
        }
        headersWithInput.addAll((MultiValueMap)input);
        this.addHeadersWithInput(builder, headersWithInput);
        return headersWithInput;
    }

    private String getRouteId(ServerWebExchange exchange) {
        String routeId = "unknown";
        Route route = (Route)exchange.getAttribute(ROUTE_ATTRIBUTE);
        if (Objects.nonNull(route)) {
            return route.getId();
        }
        return routeId;
    }

    private void addHeadersWithInput(ServerHttpRequest.Builder builder, HttpHeaders headersWithInput) {
        for (Map.Entry entry : builder.build().getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            headersWithInput.put(key, value);
        }
    }

    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.REQUEST);
    }
}

