/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.kafka;

import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.spring.TracingConsumerFactory;
import io.opentracing.contrib.kafka.spring.TracingProducerFactory;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.ProducerFactory;

@Configuration
@ConditionalOnClass(value={ProducerFactory.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.kafka.enabled"}, havingValue="true", matchIfMissing=true)
class KafkaAutoConfiguration {
    KafkaAutoConfiguration() {
    }

    @Bean
    public BeanPostProcessor kafkaProducerPostProcessor(final Tracer tracer) {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof ProducerFactory && !(bean instanceof TracingProducerFactory)) {
                    return new TracingProducerFactory((ProducerFactory)bean, tracer);
                }
                return bean;
            }
        };
    }

    @Bean
    public BeanPostProcessor kafkaConsumerPostProcessor(final Tracer tracer) {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof ConsumerFactory && !(bean instanceof TracingConsumerFactory)) {
                    return new TracingConsumerFactory((ConsumerFactory)bean, tracer);
                }
                return bean;
            }
        };
    }
}

