/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.reactor;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedScheduledExecutorService;
import io.opentracing.contrib.reactor.TracedSubscriber;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Configuration
@ConditionalOnClass(value={Tracer.class, Hooks.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.reactor.enabled"}, havingValue="true", matchIfMissing=true)
public class ReactorTracingAutoConfiguration {
    private static final Logger log = Logger.getLogger(ReactorTracingAutoConfiguration.class.getName());
    private static final String EXECUTOR_SERVICE_DECORATOR_KEY = ReactorTracingAutoConfiguration.class.getName();
    private static final String HOOK_KEY = ReactorTracingAutoConfiguration.class.getName();

    @Bean
    static HookRegisteringPostProcessor hookRegisteringPostProcessor(ObjectFactory<Tracer> tracerProvider) {
        return new HookRegisteringPostProcessor(tracerProvider);
    }

    private static class HookRegisteringPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final String ERROR_MSG = "Encountered error while retrieving Tracer instance! This reactive operation chain will not be instrumented.";
        private final ObjectFactory<Tracer> tracerProvider;
        private volatile Function<? super Publisher<Object>, ? extends Publisher<Object>> hookFunction;

        private HookRegisteringPostProcessor(ObjectFactory<Tracer> tracerProvider) {
            this.tracerProvider = tracerProvider;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            Hooks.onEachOperator((String)HOOK_KEY, this.hookFunctionWithFallback());
            Schedulers.setExecutorServiceDecorator((String)EXECUTOR_SERVICE_DECORATOR_KEY, this.decoratorWithFallback());
        }

        private Function<? super Publisher<Object>, ? extends Publisher<Object>> hookFunctionWithFallback() {
            return publisher -> {
                try {
                    return this.getHookFunction().apply((Publisher<Object>)publisher);
                }
                catch (BeansException e) {
                    log.log(Level.SEVERE, ERROR_MSG, e);
                    return publisher;
                }
            };
        }

        private Function<? super Publisher<Object>, ? extends Publisher<Object>> getHookFunction() {
            return this.hookFunction == null ? (this.hookFunction = TracedSubscriber.asOperator((Tracer)((Tracer)this.tracerProvider.getObject()))) : this.hookFunction;
        }

        private BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService> decoratorWithFallback() {
            return (scheduler, scheduledExecutorService) -> {
                try {
                    return new TracedScheduledExecutorService(scheduledExecutorService, (Tracer)this.tracerProvider.getObject());
                }
                catch (BeansException e) {
                    log.log(Level.SEVERE, ERROR_MSG, e);
                    return scheduledExecutorService;
                }
            };
        }

        @PreDestroy
        public void cleanupHooks() {
            Hooks.resetOnEachOperator((String)HOOK_KEY);
            Schedulers.removeExecutorServiceDecorator((String)EXECUTOR_SERVICE_DECORATOR_KEY);
        }
    }
}

